/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourceexplorer2;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.resourceexplorer2.ResourceExplorer2Client;
import software.amazon.awssdk.services.resourceexplorer2.model.AccessDeniedException;
import software.amazon.awssdk.services.resourceexplorer2.model.AssociateDefaultViewRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.AssociateDefaultViewResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.BatchGetViewRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.BatchGetViewResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.ConflictException;
import software.amazon.awssdk.services.resourceexplorer2.model.CreateIndexRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.CreateIndexResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.CreateViewRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.CreateViewResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.DeleteIndexRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.DeleteIndexResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.DeleteViewRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.DeleteViewResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.DisassociateDefaultViewRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.DisassociateDefaultViewResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.GetDefaultViewRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.GetDefaultViewResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.GetIndexRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.GetIndexResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.GetViewRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.GetViewResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.InternalServerException;
import software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.ListViewsRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.ListViewsResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.ResourceExplorer2Exception;
import software.amazon.awssdk.services.resourceexplorer2.model.ResourceExplorer2Request;
import software.amazon.awssdk.services.resourceexplorer2.model.ResourceNotFoundException;
import software.amazon.awssdk.services.resourceexplorer2.model.SearchRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.SearchResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.resourceexplorer2.model.TagResourceRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.TagResourceResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.ThrottlingException;
import software.amazon.awssdk.services.resourceexplorer2.model.UnauthorizedException;
import software.amazon.awssdk.services.resourceexplorer2.model.UntagResourceRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.UntagResourceResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.UpdateIndexTypeRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.UpdateIndexTypeResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.UpdateViewRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.UpdateViewResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.ValidationException;
import software.amazon.awssdk.services.resourceexplorer2.paginators.ListIndexesIterable;
import software.amazon.awssdk.services.resourceexplorer2.paginators.ListSupportedResourceTypesIterable;
import software.amazon.awssdk.services.resourceexplorer2.paginators.ListViewsIterable;
import software.amazon.awssdk.services.resourceexplorer2.paginators.SearchIterable;
import software.amazon.awssdk.services.resourceexplorer2.transform.AssociateDefaultViewRequestMarshaller;
import software.amazon.awssdk.services.resourceexplorer2.transform.BatchGetViewRequestMarshaller;
import software.amazon.awssdk.services.resourceexplorer2.transform.CreateIndexRequestMarshaller;
import software.amazon.awssdk.services.resourceexplorer2.transform.CreateViewRequestMarshaller;
import software.amazon.awssdk.services.resourceexplorer2.transform.DeleteIndexRequestMarshaller;
import software.amazon.awssdk.services.resourceexplorer2.transform.DeleteViewRequestMarshaller;
import software.amazon.awssdk.services.resourceexplorer2.transform.DisassociateDefaultViewRequestMarshaller;
import software.amazon.awssdk.services.resourceexplorer2.transform.GetDefaultViewRequestMarshaller;
import software.amazon.awssdk.services.resourceexplorer2.transform.GetIndexRequestMarshaller;
import software.amazon.awssdk.services.resourceexplorer2.transform.GetViewRequestMarshaller;
import software.amazon.awssdk.services.resourceexplorer2.transform.ListIndexesRequestMarshaller;
import software.amazon.awssdk.services.resourceexplorer2.transform.ListSupportedResourceTypesRequestMarshaller;
import software.amazon.awssdk.services.resourceexplorer2.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.resourceexplorer2.transform.ListViewsRequestMarshaller;
import software.amazon.awssdk.services.resourceexplorer2.transform.SearchRequestMarshaller;
import software.amazon.awssdk.services.resourceexplorer2.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.resourceexplorer2.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.resourceexplorer2.transform.UpdateIndexTypeRequestMarshaller;
import software.amazon.awssdk.services.resourceexplorer2.transform.UpdateViewRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultResourceExplorer2Client
implements ResourceExplorer2Client {
    private static final Logger log = Logger.loggerFor(DefaultResourceExplorer2Client.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultResourceExplorer2Client(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateDefaultViewResponse associateDefaultView(AssociateDefaultViewRequest associateDefaultViewRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateDefaultViewResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultResourceExplorer2Client.resolveMetricPublishers(this.clientConfiguration, associateDefaultViewRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Resource Explorer 2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateDefaultView");
            AssociateDefaultViewResponse associateDefaultViewResponse = (AssociateDefaultViewResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateDefaultView").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateDefaultViewRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateDefaultViewRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateDefaultViewResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultResourceExplorer2Client.lambda$associateDefaultView$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetViewResponse batchGetView(BatchGetViewRequest batchGetViewRequest) throws InternalServerException, ValidationException, UnauthorizedException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetViewResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultResourceExplorer2Client.resolveMetricPublishers(this.clientConfiguration, batchGetViewRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Resource Explorer 2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetView");
            BatchGetViewResponse batchGetViewResponse = (BatchGetViewResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetView").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchGetViewRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchGetViewRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchGetViewResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultResourceExplorer2Client.lambda$batchGetView$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateIndexResponse createIndex(CreateIndexRequest createIndexRequest) throws InternalServerException, ValidationException, ConflictException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateIndexResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultResourceExplorer2Client.resolveMetricPublishers(this.clientConfiguration, createIndexRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Resource Explorer 2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateIndex");
            CreateIndexResponse createIndexResponse = (CreateIndexResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateIndex").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createIndexRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateIndexRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createIndexResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultResourceExplorer2Client.lambda$createIndex$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateViewResponse createView(CreateViewRequest createViewRequest) throws InternalServerException, ValidationException, ConflictException, ServiceQuotaExceededException, UnauthorizedException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateViewResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultResourceExplorer2Client.resolveMetricPublishers(this.clientConfiguration, createViewRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Resource Explorer 2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateView");
            CreateViewResponse createViewResponse = (CreateViewResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateView").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createViewRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateViewRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createViewResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultResourceExplorer2Client.lambda$createView$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteIndexResponse deleteIndex(DeleteIndexRequest deleteIndexRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteIndexResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultResourceExplorer2Client.resolveMetricPublishers(this.clientConfiguration, deleteIndexRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Resource Explorer 2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteIndex");
            DeleteIndexResponse deleteIndexResponse = (DeleteIndexResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteIndex").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteIndexRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteIndexRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteIndexResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultResourceExplorer2Client.lambda$deleteIndex$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteViewResponse deleteView(DeleteViewRequest deleteViewRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, UnauthorizedException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteViewResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultResourceExplorer2Client.resolveMetricPublishers(this.clientConfiguration, deleteViewRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Resource Explorer 2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteView");
            DeleteViewResponse deleteViewResponse = (DeleteViewResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteView").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteViewRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteViewRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteViewResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultResourceExplorer2Client.lambda$deleteView$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateDefaultViewResponse disassociateDefaultView(DisassociateDefaultViewRequest disassociateDefaultViewRequest) throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateDefaultViewResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultResourceExplorer2Client.resolveMetricPublishers(this.clientConfiguration, disassociateDefaultViewRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Resource Explorer 2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateDefaultView");
            DisassociateDefaultViewResponse disassociateDefaultViewResponse = (DisassociateDefaultViewResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateDefaultView").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateDefaultViewRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateDefaultViewRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateDefaultViewResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultResourceExplorer2Client.lambda$disassociateDefaultView$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDefaultViewResponse getDefaultView(GetDefaultViewRequest getDefaultViewRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDefaultViewResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultResourceExplorer2Client.resolveMetricPublishers(this.clientConfiguration, getDefaultViewRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Resource Explorer 2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDefaultView");
            GetDefaultViewResponse getDefaultViewResponse = (GetDefaultViewResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDefaultView").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDefaultViewRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDefaultViewRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDefaultViewResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultResourceExplorer2Client.lambda$getDefaultView$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetIndexResponse getIndex(GetIndexRequest getIndexRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetIndexResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultResourceExplorer2Client.resolveMetricPublishers(this.clientConfiguration, getIndexRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Resource Explorer 2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetIndex");
            GetIndexResponse getIndexResponse = (GetIndexResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetIndex").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getIndexRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetIndexRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getIndexResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultResourceExplorer2Client.lambda$getIndex$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetViewResponse getView(GetViewRequest getViewRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, UnauthorizedException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetViewResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultResourceExplorer2Client.resolveMetricPublishers(this.clientConfiguration, getViewRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Resource Explorer 2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetView");
            GetViewResponse getViewResponse = (GetViewResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetView").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getViewRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetViewRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getViewResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultResourceExplorer2Client.lambda$getView$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIndexesResponse listIndexes(ListIndexesRequest listIndexesRequest) throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListIndexesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultResourceExplorer2Client.resolveMetricPublishers(this.clientConfiguration, listIndexesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Resource Explorer 2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListIndexes");
            ListIndexesResponse listIndexesResponse = (ListIndexesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListIndexes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listIndexesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListIndexesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listIndexesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultResourceExplorer2Client.lambda$listIndexes$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListIndexesIterable listIndexesPaginator(ListIndexesRequest listIndexesRequest) throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        return new ListIndexesIterable(this, this.applyPaginatorUserAgent(listIndexesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSupportedResourceTypesResponse listSupportedResourceTypes(ListSupportedResourceTypesRequest listSupportedResourceTypesRequest) throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSupportedResourceTypesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultResourceExplorer2Client.resolveMetricPublishers(this.clientConfiguration, listSupportedResourceTypesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Resource Explorer 2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSupportedResourceTypes");
            ListSupportedResourceTypesResponse listSupportedResourceTypesResponse = (ListSupportedResourceTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSupportedResourceTypes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSupportedResourceTypesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSupportedResourceTypesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSupportedResourceTypesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultResourceExplorer2Client.lambda$listSupportedResourceTypes$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListSupportedResourceTypesIterable listSupportedResourceTypesPaginator(ListSupportedResourceTypesRequest listSupportedResourceTypesRequest) throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        return new ListSupportedResourceTypesIterable(this, this.applyPaginatorUserAgent(listSupportedResourceTypesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, UnauthorizedException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultResourceExplorer2Client.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Resource Explorer 2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultResourceExplorer2Client.lambda$listTagsForResource$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListViewsResponse listViews(ListViewsRequest listViewsRequest) throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListViewsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultResourceExplorer2Client.resolveMetricPublishers(this.clientConfiguration, listViewsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Resource Explorer 2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListViews");
            ListViewsResponse listViewsResponse = (ListViewsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListViews").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listViewsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListViewsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listViewsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultResourceExplorer2Client.lambda$listViews$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListViewsIterable listViewsPaginator(ListViewsRequest listViewsRequest) throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        return new ListViewsIterable(this, this.applyPaginatorUserAgent(listViewsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchResponse search(SearchRequest searchRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, UnauthorizedException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultResourceExplorer2Client.resolveMetricPublishers(this.clientConfiguration, searchRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Resource Explorer 2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"Search");
            SearchResponse searchResponse = (SearchResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("Search").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)searchRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SearchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return searchResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultResourceExplorer2Client.lambda$search$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public SearchIterable searchPaginator(SearchRequest searchRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, UnauthorizedException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        return new SearchIterable(this, this.applyPaginatorUserAgent(searchRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException, ValidationException, ConflictException, UnauthorizedException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultResourceExplorer2Client.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Resource Explorer 2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultResourceExplorer2Client.lambda$tagResource$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, UnauthorizedException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultResourceExplorer2Client.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Resource Explorer 2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultResourceExplorer2Client.lambda$untagResource$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateIndexTypeResponse updateIndexType(UpdateIndexTypeRequest updateIndexTypeRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, ConflictException, ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateIndexTypeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultResourceExplorer2Client.resolveMetricPublishers(this.clientConfiguration, updateIndexTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Resource Explorer 2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateIndexType");
            UpdateIndexTypeResponse updateIndexTypeResponse = (UpdateIndexTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateIndexType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateIndexTypeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateIndexTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateIndexTypeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultResourceExplorer2Client.lambda$updateIndexType$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateViewResponse updateView(UpdateViewRequest updateViewRequest) throws InternalServerException, ValidationException, ServiceQuotaExceededException, UnauthorizedException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateViewResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultResourceExplorer2Client.resolveMetricPublishers(this.clientConfiguration, updateViewRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Resource Explorer 2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateView");
            UpdateViewResponse updateViewResponse = (UpdateViewResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateView").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateViewRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateViewRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateViewResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultResourceExplorer2Client.lambda$updateView$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private <T extends ResourceExplorer2Request> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.20.3").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ResourceExplorer2Request)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public final String serviceName() {
        return "resource-explorer-2";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ResourceExplorer2Exception::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnauthorizedException").exceptionBuilderSupplier(UnauthorizedException::builder).httpStatusCode(Integer.valueOf(401)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateView$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateIndexType$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$search$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listViews$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSupportedResourceTypes$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listIndexes$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getView$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getIndex$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDefaultView$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateDefaultView$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteView$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteIndex$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createView$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createIndex$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetView$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateDefaultView$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

