/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourceexplorer2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resourceexplorer2.model.IncludedProperty;
import software.amazon.awssdk.services.resourceexplorer2.model.IncludedPropertyListCopier;
import software.amazon.awssdk.services.resourceexplorer2.model.ResourceExplorer2Request;
import software.amazon.awssdk.services.resourceexplorer2.model.SearchFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateViewRequest
extends ResourceExplorer2Request
implements ToCopyableBuilder<Builder, UpdateViewRequest> {
    private static final SdkField<SearchFilter> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filters").getter(UpdateViewRequest.getter(UpdateViewRequest::filters)).setter(UpdateViewRequest.setter(Builder::filters)).constructor(SearchFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()}).build();
    private static final SdkField<List<IncludedProperty>> INCLUDED_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IncludedProperties").getter(UpdateViewRequest.getter(UpdateViewRequest::includedProperties)).setter(UpdateViewRequest.setter(Builder::includedProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludedProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IncludedProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VIEW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ViewArn").getter(UpdateViewRequest.getter(UpdateViewRequest::viewArn)).setter(UpdateViewRequest.setter(Builder::viewArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD, INCLUDED_PROPERTIES_FIELD, VIEW_ARN_FIELD));
    private final SearchFilter filters;
    private final List<IncludedProperty> includedProperties;
    private final String viewArn;

    private UpdateViewRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.includedProperties = builder.includedProperties;
        this.viewArn = builder.viewArn;
    }

    public final SearchFilter filters() {
        return this.filters;
    }

    public final boolean hasIncludedProperties() {
        return this.includedProperties != null && !(this.includedProperties instanceof SdkAutoConstructList);
    }

    public final List<IncludedProperty> includedProperties() {
        return this.includedProperties;
    }

    public final String viewArn() {
        return this.viewArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludedProperties() ? this.includedProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.viewArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateViewRequest)) {
            return false;
        }
        UpdateViewRequest other = (UpdateViewRequest)((Object)obj);
        return Objects.equals(this.filters(), other.filters()) && this.hasIncludedProperties() == other.hasIncludedProperties() && Objects.equals(this.includedProperties(), other.includedProperties()) && Objects.equals(this.viewArn(), other.viewArn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateViewRequest").add("Filters", (Object)(this.filters() == null ? null : "*** Sensitive Data Redacted ***")).add("IncludedProperties", this.hasIncludedProperties() ? this.includedProperties() : null).add("ViewArn", (Object)this.viewArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "IncludedProperties": {
                return Optional.ofNullable(clazz.cast(this.includedProperties()));
            }
            case "ViewArn": {
                return Optional.ofNullable(clazz.cast(this.viewArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateViewRequest, T> g) {
        return obj -> g.apply((UpdateViewRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResourceExplorer2Request.BuilderImpl
    implements Builder {
        private SearchFilter filters;
        private List<IncludedProperty> includedProperties = DefaultSdkAutoConstructList.getInstance();
        private String viewArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateViewRequest model) {
            super(model);
            this.filters(model.filters);
            this.includedProperties(model.includedProperties);
            this.viewArn(model.viewArn);
        }

        public final SearchFilter.Builder getFilters() {
            return this.filters != null ? this.filters.toBuilder() : null;
        }

        public final void setFilters(SearchFilter.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(SearchFilter filters) {
            this.filters = filters;
            return this;
        }

        public final List<IncludedProperty.Builder> getIncludedProperties() {
            List<IncludedProperty.Builder> result = IncludedPropertyListCopier.copyToBuilder(this.includedProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIncludedProperties(Collection<IncludedProperty.BuilderImpl> includedProperties) {
            this.includedProperties = IncludedPropertyListCopier.copyFromBuilder(includedProperties);
        }

        @Override
        public final Builder includedProperties(Collection<IncludedProperty> includedProperties) {
            this.includedProperties = IncludedPropertyListCopier.copy(includedProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includedProperties(IncludedProperty ... includedProperties) {
            this.includedProperties(Arrays.asList(includedProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includedProperties(Consumer<IncludedProperty.Builder> ... includedProperties) {
            this.includedProperties(Stream.of(includedProperties).map(c -> (IncludedProperty)((IncludedProperty.Builder)IncludedProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getViewArn() {
            return this.viewArn;
        }

        public final void setViewArn(String viewArn) {
            this.viewArn = viewArn;
        }

        @Override
        public final Builder viewArn(String viewArn) {
            this.viewArn = viewArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateViewRequest build() {
            return new UpdateViewRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResourceExplorer2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateViewRequest> {
        public Builder filters(SearchFilter var1);

        default public Builder filters(Consumer<SearchFilter.Builder> filters) {
            return this.filters((SearchFilter)((SearchFilter.Builder)SearchFilter.builder().applyMutation(filters)).build());
        }

        public Builder includedProperties(Collection<IncludedProperty> var1);

        public Builder includedProperties(IncludedProperty ... var1);

        public Builder includedProperties(Consumer<IncludedProperty.Builder> ... var1);

        public Builder viewArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

