/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourceexplorer2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resourceexplorer2.ResourceExplorer2Client;
import software.amazon.awssdk.services.resourceexplorer2.model.Index;
import software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesResponse;

public class ListIndexesIterable
implements SdkIterable<ListIndexesResponse> {
    private final ResourceExplorer2Client client;
    private final ListIndexesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListIndexesIterable(ResourceExplorer2Client client, ListIndexesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListIndexesResponseFetcher();
    }

    public Iterator<ListIndexesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Index> indexes() {
        Function<ListIndexesResponse, Iterator> getIterator = response -> {
            if (response != null && response.indexes() != null) {
                return response.indexes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListIndexesResponseFetcher
    implements SyncPageFetcher<ListIndexesResponse> {
        private ListIndexesResponseFetcher() {
        }

        public boolean hasNextPage(ListIndexesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListIndexesResponse nextPage(ListIndexesResponse previousPage) {
            if (previousPage == null) {
                return ListIndexesIterable.this.client.listIndexes(ListIndexesIterable.this.firstRequest);
            }
            return ListIndexesIterable.this.client.listIndexes((ListIndexesRequest)((Object)ListIndexesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

