/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourceexplorer2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.resourceexplorer2.model.ResourceExplorer2Response;
import software.amazon.awssdk.services.resourceexplorer2.model.TagMapCopier;
import software.amazon.awssdk.services.resourceexplorer2.model.View;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetViewResponse
extends ResourceExplorer2Response
implements ToCopyableBuilder<Builder, GetViewResponse> {
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(GetViewResponse.getter(GetViewResponse::tags)).setter(GetViewResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<View> VIEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("View").getter(GetViewResponse.getter(GetViewResponse::view)).setter(GetViewResponse.setter(Builder::view)).constructor(View::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("View").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAGS_FIELD, VIEW_FIELD));
    private final Map<String, String> tags;
    private final View view;

    private GetViewResponse(BuilderImpl builder) {
        super(builder);
        this.tags = builder.tags;
        this.view = builder.view;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final View view() {
        return this.view;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.view());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetViewResponse)) {
            return false;
        }
        GetViewResponse other = (GetViewResponse)((Object)obj);
        return this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.view(), other.view());
    }

    public final String toString() {
        return ToString.builder((String)"GetViewResponse").add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).add("View", (Object)this.view()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "View": {
                return Optional.ofNullable(clazz.cast(this.view()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetViewResponse, T> g) {
        return obj -> g.apply((GetViewResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResourceExplorer2Response.BuilderImpl
    implements Builder {
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private View view;

        private BuilderImpl() {
        }

        private BuilderImpl(GetViewResponse model) {
            super(model);
            this.tags(model.tags);
            this.view(model.view);
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final View.Builder getView() {
            return this.view != null ? this.view.toBuilder() : null;
        }

        public final void setView(View.BuilderImpl view) {
            this.view = view != null ? view.build() : null;
        }

        @Override
        public final Builder view(View view) {
            this.view = view;
            return this;
        }

        @Override
        public GetViewResponse build() {
            return new GetViewResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResourceExplorer2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetViewResponse> {
        public Builder tags(Map<String, String> var1);

        public Builder view(View var1);

        default public Builder view(Consumer<View.Builder> view) {
            return this.view((View)((View.Builder)View.builder().applyMutation(view)).build());
        }
    }
}

