/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourceexplorer2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resourceexplorer2.ResourceExplorer2AsyncClient;
import software.amazon.awssdk.services.resourceexplorer2.internal.UserAgentUtils;
import software.amazon.awssdk.services.resourceexplorer2.model.Index;
import software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesResponse;

public class ListIndexesPublisher
implements SdkPublisher<ListIndexesResponse> {
    private final ResourceExplorer2AsyncClient client;
    private final ListIndexesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListIndexesPublisher(ResourceExplorer2AsyncClient client, ListIndexesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListIndexesPublisher(ResourceExplorer2AsyncClient client, ListIndexesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListIndexesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListIndexesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Index> indexes() {
        Function<ListIndexesResponse, Iterator> getIterator = response -> {
            if (response != null && response.indexes() != null) {
                return response.indexes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListIndexesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListIndexesResponseFetcher
    implements AsyncPageFetcher<ListIndexesResponse> {
        private ListIndexesResponseFetcher() {
        }

        public boolean hasNextPage(ListIndexesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListIndexesResponse> nextPage(ListIndexesResponse previousPage) {
            if (previousPage == null) {
                return ListIndexesPublisher.this.client.listIndexes(ListIndexesPublisher.this.firstRequest);
            }
            return ListIndexesPublisher.this.client.listIndexes((ListIndexesRequest)((Object)ListIndexesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

