/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.retries.api;

import java.util.function.Predicate;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.retries.api.AcquireInitialTokenRequest;
import software.amazon.awssdk.retries.api.AcquireInitialTokenResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.retries.api.RecordSuccessRequest;
import software.amazon.awssdk.retries.api.RecordSuccessResponse;
import software.amazon.awssdk.retries.api.RefreshRetryTokenRequest;
import software.amazon.awssdk.retries.api.RefreshRetryTokenResponse;

@ThreadSafe
@SdkPublicApi
public interface RetryStrategy {
    public AcquireInitialTokenResponse acquireInitialToken(AcquireInitialTokenRequest var1);

    public RefreshRetryTokenResponse refreshRetryToken(RefreshRetryTokenRequest var1);

    public RecordSuccessResponse recordSuccess(RecordSuccessRequest var1);

    public int maxAttempts();

    public Builder<?, ?> toBuilder();

    public static interface Builder<B extends Builder<B, T>, T extends RetryStrategy> {
        public B retryOnException(Predicate<Throwable> var1);

        default public B retryOnException(Class<? extends Throwable> throwable) {
            return this.retryOnException((Throwable t) -> t.getClass() == throwable);
        }

        default public B retryOnExceptionInstanceOf(Class<? extends Throwable> throwable) {
            return this.retryOnException((Throwable t) -> throwable.isAssignableFrom(t.getClass()));
        }

        default public B retryOnExceptionOrCause(Class<? extends Throwable> throwable) {
            return this.retryOnException((Throwable t) -> {
                if (t.getClass() == throwable) {
                    return true;
                }
                Throwable cause = t.getCause();
                return cause != null && cause.getClass() == throwable;
            });
        }

        default public B retryOnExceptionOrCauseInstanceOf(Class<? extends Throwable> throwable) {
            return this.retryOnException((Throwable t) -> {
                if (throwable.isAssignableFrom(t.getClass())) {
                    return true;
                }
                Throwable cause = t.getCause();
                return cause != null && throwable.isAssignableFrom(cause.getClass());
            });
        }

        default public B retryOnRootCause(Class<? extends Throwable> throwable) {
            return this.retryOnException((Throwable t) -> {
                boolean shouldRetry = false;
                for (Throwable cause = t.getCause(); cause != null; cause = cause.getCause()) {
                    shouldRetry = throwable == cause.getClass();
                }
                return shouldRetry;
            });
        }

        default public B retryOnRootCauseInstanceOf(Class<? extends Throwable> throwable) {
            return this.retryOnException((Throwable t) -> {
                boolean shouldRetry = false;
                for (Throwable cause = t.getCause(); cause != null; cause = cause.getCause()) {
                    shouldRetry = throwable.isAssignableFrom(cause.getClass());
                }
                return shouldRetry;
            });
        }

        public B maxAttempts(int var1);

        public B backoffStrategy(BackoffStrategy var1);

        public T build();
    }
}

