/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53resolver.Route53ResolverClient;
import software.amazon.awssdk.services.route53resolver.model.FirewallConfig;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallConfigsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallConfigsResponse;

public class ListFirewallConfigsIterable
implements SdkIterable<ListFirewallConfigsResponse> {
    private final Route53ResolverClient client;
    private final ListFirewallConfigsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFirewallConfigsIterable(Route53ResolverClient client, ListFirewallConfigsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListFirewallConfigsResponseFetcher();
    }

    public Iterator<ListFirewallConfigsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FirewallConfig> firewallConfigs() {
        Function<ListFirewallConfigsResponse, Iterator> getIterator = response -> {
            if (response != null && response.firewallConfigs() != null) {
                return response.firewallConfigs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFirewallConfigsResponseFetcher
    implements SyncPageFetcher<ListFirewallConfigsResponse> {
        private ListFirewallConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListFirewallConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFirewallConfigsResponse nextPage(ListFirewallConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListFirewallConfigsIterable.this.client.listFirewallConfigs(ListFirewallConfigsIterable.this.firstRequest);
            }
            return ListFirewallConfigsIterable.this.client.listFirewallConfigs((ListFirewallConfigsRequest)((Object)ListFirewallConfigsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

