/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ShuffleConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ShuffleConfig> {
    private static final SdkField<Long> SEED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(ShuffleConfig.getter(ShuffleConfig::seed)).setter(ShuffleConfig.setter(Builder::seed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Seed").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEED_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long seed;

    private ShuffleConfig(BuilderImpl builder) {
        this.seed = builder.seed;
    }

    public Long seed() {
        return this.seed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.seed());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShuffleConfig)) {
            return false;
        }
        ShuffleConfig other = (ShuffleConfig)obj;
        return Objects.equals(this.seed(), other.seed());
    }

    public String toString() {
        return ToString.builder((String)"ShuffleConfig").add("Seed", (Object)this.seed()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Seed": {
                return Optional.ofNullable(clazz.cast(this.seed()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ShuffleConfig, T> g) {
        return obj -> g.apply((ShuffleConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long seed;

        private BuilderImpl() {
        }

        private BuilderImpl(ShuffleConfig model) {
            this.seed(model.seed);
        }

        public final Long getSeed() {
            return this.seed;
        }

        @Override
        public final Builder seed(Long seed) {
            this.seed = seed;
            return this;
        }

        public final void setSeed(Long seed) {
            this.seed = seed;
        }

        public ShuffleConfig build() {
            return new ShuffleConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ShuffleConfig> {
        public Builder seed(Long var1);
    }
}

