/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AppType;
import software.amazon.awssdk.services.sagemaker.model.HiddenAppTypesListCopier;
import software.amazon.awssdk.services.sagemaker.model.HiddenMlToolsListCopier;
import software.amazon.awssdk.services.sagemaker.model.MlTools;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StudioWebPortalSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StudioWebPortalSettings> {
    private static final SdkField<List<String>> HIDDEN_ML_TOOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HiddenMlTools").getter(StudioWebPortalSettings.getter(StudioWebPortalSettings::hiddenMlToolsAsStrings)).setter(StudioWebPortalSettings.setter(Builder::hiddenMlToolsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HiddenMlTools").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> HIDDEN_APP_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HiddenAppTypes").getter(StudioWebPortalSettings.getter(StudioWebPortalSettings::hiddenAppTypesAsStrings)).setter(StudioWebPortalSettings.setter(Builder::hiddenAppTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HiddenAppTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HIDDEN_ML_TOOLS_FIELD, HIDDEN_APP_TYPES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> hiddenMlTools;
    private final List<String> hiddenAppTypes;

    private StudioWebPortalSettings(BuilderImpl builder) {
        this.hiddenMlTools = builder.hiddenMlTools;
        this.hiddenAppTypes = builder.hiddenAppTypes;
    }

    public final List<MlTools> hiddenMlTools() {
        return HiddenMlToolsListCopier.copyStringToEnum(this.hiddenMlTools);
    }

    public final boolean hasHiddenMlTools() {
        return this.hiddenMlTools != null && !(this.hiddenMlTools instanceof SdkAutoConstructList);
    }

    public final List<String> hiddenMlToolsAsStrings() {
        return this.hiddenMlTools;
    }

    public final List<AppType> hiddenAppTypes() {
        return HiddenAppTypesListCopier.copyStringToEnum(this.hiddenAppTypes);
    }

    public final boolean hasHiddenAppTypes() {
        return this.hiddenAppTypes != null && !(this.hiddenAppTypes instanceof SdkAutoConstructList);
    }

    public final List<String> hiddenAppTypesAsStrings() {
        return this.hiddenAppTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHiddenMlTools() ? this.hiddenMlToolsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHiddenAppTypes() ? this.hiddenAppTypesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StudioWebPortalSettings)) {
            return false;
        }
        StudioWebPortalSettings other = (StudioWebPortalSettings)obj;
        return this.hasHiddenMlTools() == other.hasHiddenMlTools() && Objects.equals(this.hiddenMlToolsAsStrings(), other.hiddenMlToolsAsStrings()) && this.hasHiddenAppTypes() == other.hasHiddenAppTypes() && Objects.equals(this.hiddenAppTypesAsStrings(), other.hiddenAppTypesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"StudioWebPortalSettings").add("HiddenMlTools", this.hasHiddenMlTools() ? this.hiddenMlToolsAsStrings() : null).add("HiddenAppTypes", this.hasHiddenAppTypes() ? this.hiddenAppTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HiddenMlTools": {
                return Optional.ofNullable(clazz.cast(this.hiddenMlToolsAsStrings()));
            }
            case "HiddenAppTypes": {
                return Optional.ofNullable(clazz.cast(this.hiddenAppTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StudioWebPortalSettings, T> g) {
        return obj -> g.apply((StudioWebPortalSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> hiddenMlTools = DefaultSdkAutoConstructList.getInstance();
        private List<String> hiddenAppTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StudioWebPortalSettings model) {
            this.hiddenMlToolsWithStrings(model.hiddenMlTools);
            this.hiddenAppTypesWithStrings(model.hiddenAppTypes);
        }

        public final Collection<String> getHiddenMlTools() {
            if (this.hiddenMlTools instanceof SdkAutoConstructList) {
                return null;
            }
            return this.hiddenMlTools;
        }

        public final void setHiddenMlTools(Collection<String> hiddenMlTools) {
            this.hiddenMlTools = HiddenMlToolsListCopier.copy(hiddenMlTools);
        }

        @Override
        public final Builder hiddenMlToolsWithStrings(Collection<String> hiddenMlTools) {
            this.hiddenMlTools = HiddenMlToolsListCopier.copy(hiddenMlTools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hiddenMlToolsWithStrings(String ... hiddenMlTools) {
            this.hiddenMlToolsWithStrings(Arrays.asList(hiddenMlTools));
            return this;
        }

        @Override
        public final Builder hiddenMlTools(Collection<MlTools> hiddenMlTools) {
            this.hiddenMlTools = HiddenMlToolsListCopier.copyEnumToString(hiddenMlTools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hiddenMlTools(MlTools ... hiddenMlTools) {
            this.hiddenMlTools(Arrays.asList(hiddenMlTools));
            return this;
        }

        public final Collection<String> getHiddenAppTypes() {
            if (this.hiddenAppTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.hiddenAppTypes;
        }

        public final void setHiddenAppTypes(Collection<String> hiddenAppTypes) {
            this.hiddenAppTypes = HiddenAppTypesListCopier.copy(hiddenAppTypes);
        }

        @Override
        public final Builder hiddenAppTypesWithStrings(Collection<String> hiddenAppTypes) {
            this.hiddenAppTypes = HiddenAppTypesListCopier.copy(hiddenAppTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hiddenAppTypesWithStrings(String ... hiddenAppTypes) {
            this.hiddenAppTypesWithStrings(Arrays.asList(hiddenAppTypes));
            return this;
        }

        @Override
        public final Builder hiddenAppTypes(Collection<AppType> hiddenAppTypes) {
            this.hiddenAppTypes = HiddenAppTypesListCopier.copyEnumToString(hiddenAppTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hiddenAppTypes(AppType ... hiddenAppTypes) {
            this.hiddenAppTypes(Arrays.asList(hiddenAppTypes));
            return this;
        }

        public StudioWebPortalSettings build() {
            return new StudioWebPortalSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StudioWebPortalSettings> {
        public Builder hiddenMlToolsWithStrings(Collection<String> var1);

        public Builder hiddenMlToolsWithStrings(String ... var1);

        public Builder hiddenMlTools(Collection<MlTools> var1);

        public Builder hiddenMlTools(MlTools ... var1);

        public Builder hiddenAppTypesWithStrings(Collection<String> var1);

        public Builder hiddenAppTypesWithStrings(String ... var1);

        public Builder hiddenAppTypes(Collection<AppType> var1);

        public Builder hiddenAppTypes(AppType ... var1);
    }
}

