/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.CodeEditorAppImageConfig;
import software.amazon.awssdk.services.sagemaker.model.JupyterLabAppImageConfig;
import software.amazon.awssdk.services.sagemaker.model.KernelGatewayImageConfig;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAppImageConfigRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateAppImageConfigRequest> {
    private static final SdkField<String> APP_IMAGE_CONFIG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppImageConfigName").getter(UpdateAppImageConfigRequest.getter(UpdateAppImageConfigRequest::appImageConfigName)).setter(UpdateAppImageConfigRequest.setter(Builder::appImageConfigName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppImageConfigName").build()}).build();
    private static final SdkField<KernelGatewayImageConfig> KERNEL_GATEWAY_IMAGE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KernelGatewayImageConfig").getter(UpdateAppImageConfigRequest.getter(UpdateAppImageConfigRequest::kernelGatewayImageConfig)).setter(UpdateAppImageConfigRequest.setter(Builder::kernelGatewayImageConfig)).constructor(KernelGatewayImageConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelGatewayImageConfig").build()}).build();
    private static final SdkField<JupyterLabAppImageConfig> JUPYTER_LAB_APP_IMAGE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JupyterLabAppImageConfig").getter(UpdateAppImageConfigRequest.getter(UpdateAppImageConfigRequest::jupyterLabAppImageConfig)).setter(UpdateAppImageConfigRequest.setter(Builder::jupyterLabAppImageConfig)).constructor(JupyterLabAppImageConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JupyterLabAppImageConfig").build()}).build();
    private static final SdkField<CodeEditorAppImageConfig> CODE_EDITOR_APP_IMAGE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CodeEditorAppImageConfig").getter(UpdateAppImageConfigRequest.getter(UpdateAppImageConfigRequest::codeEditorAppImageConfig)).setter(UpdateAppImageConfigRequest.setter(Builder::codeEditorAppImageConfig)).constructor(CodeEditorAppImageConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeEditorAppImageConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_IMAGE_CONFIG_NAME_FIELD, KERNEL_GATEWAY_IMAGE_CONFIG_FIELD, JUPYTER_LAB_APP_IMAGE_CONFIG_FIELD, CODE_EDITOR_APP_IMAGE_CONFIG_FIELD));
    private final String appImageConfigName;
    private final KernelGatewayImageConfig kernelGatewayImageConfig;
    private final JupyterLabAppImageConfig jupyterLabAppImageConfig;
    private final CodeEditorAppImageConfig codeEditorAppImageConfig;

    private UpdateAppImageConfigRequest(BuilderImpl builder) {
        super(builder);
        this.appImageConfigName = builder.appImageConfigName;
        this.kernelGatewayImageConfig = builder.kernelGatewayImageConfig;
        this.jupyterLabAppImageConfig = builder.jupyterLabAppImageConfig;
        this.codeEditorAppImageConfig = builder.codeEditorAppImageConfig;
    }

    public final String appImageConfigName() {
        return this.appImageConfigName;
    }

    public final KernelGatewayImageConfig kernelGatewayImageConfig() {
        return this.kernelGatewayImageConfig;
    }

    public final JupyterLabAppImageConfig jupyterLabAppImageConfig() {
        return this.jupyterLabAppImageConfig;
    }

    public final CodeEditorAppImageConfig codeEditorAppImageConfig() {
        return this.codeEditorAppImageConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appImageConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(this.kernelGatewayImageConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.jupyterLabAppImageConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeEditorAppImageConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAppImageConfigRequest)) {
            return false;
        }
        UpdateAppImageConfigRequest other = (UpdateAppImageConfigRequest)((Object)obj);
        return Objects.equals(this.appImageConfigName(), other.appImageConfigName()) && Objects.equals(this.kernelGatewayImageConfig(), other.kernelGatewayImageConfig()) && Objects.equals(this.jupyterLabAppImageConfig(), other.jupyterLabAppImageConfig()) && Objects.equals(this.codeEditorAppImageConfig(), other.codeEditorAppImageConfig());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAppImageConfigRequest").add("AppImageConfigName", (Object)this.appImageConfigName()).add("KernelGatewayImageConfig", (Object)this.kernelGatewayImageConfig()).add("JupyterLabAppImageConfig", (Object)this.jupyterLabAppImageConfig()).add("CodeEditorAppImageConfig", (Object)this.codeEditorAppImageConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppImageConfigName": {
                return Optional.ofNullable(clazz.cast(this.appImageConfigName()));
            }
            case "KernelGatewayImageConfig": {
                return Optional.ofNullable(clazz.cast(this.kernelGatewayImageConfig()));
            }
            case "JupyterLabAppImageConfig": {
                return Optional.ofNullable(clazz.cast(this.jupyterLabAppImageConfig()));
            }
            case "CodeEditorAppImageConfig": {
                return Optional.ofNullable(clazz.cast(this.codeEditorAppImageConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAppImageConfigRequest, T> g) {
        return obj -> g.apply((UpdateAppImageConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String appImageConfigName;
        private KernelGatewayImageConfig kernelGatewayImageConfig;
        private JupyterLabAppImageConfig jupyterLabAppImageConfig;
        private CodeEditorAppImageConfig codeEditorAppImageConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAppImageConfigRequest model) {
            super(model);
            this.appImageConfigName(model.appImageConfigName);
            this.kernelGatewayImageConfig(model.kernelGatewayImageConfig);
            this.jupyterLabAppImageConfig(model.jupyterLabAppImageConfig);
            this.codeEditorAppImageConfig(model.codeEditorAppImageConfig);
        }

        public final String getAppImageConfigName() {
            return this.appImageConfigName;
        }

        public final void setAppImageConfigName(String appImageConfigName) {
            this.appImageConfigName = appImageConfigName;
        }

        @Override
        public final Builder appImageConfigName(String appImageConfigName) {
            this.appImageConfigName = appImageConfigName;
            return this;
        }

        public final KernelGatewayImageConfig.Builder getKernelGatewayImageConfig() {
            return this.kernelGatewayImageConfig != null ? this.kernelGatewayImageConfig.toBuilder() : null;
        }

        public final void setKernelGatewayImageConfig(KernelGatewayImageConfig.BuilderImpl kernelGatewayImageConfig) {
            this.kernelGatewayImageConfig = kernelGatewayImageConfig != null ? kernelGatewayImageConfig.build() : null;
        }

        @Override
        public final Builder kernelGatewayImageConfig(KernelGatewayImageConfig kernelGatewayImageConfig) {
            this.kernelGatewayImageConfig = kernelGatewayImageConfig;
            return this;
        }

        public final JupyterLabAppImageConfig.Builder getJupyterLabAppImageConfig() {
            return this.jupyterLabAppImageConfig != null ? this.jupyterLabAppImageConfig.toBuilder() : null;
        }

        public final void setJupyterLabAppImageConfig(JupyterLabAppImageConfig.BuilderImpl jupyterLabAppImageConfig) {
            this.jupyterLabAppImageConfig = jupyterLabAppImageConfig != null ? jupyterLabAppImageConfig.build() : null;
        }

        @Override
        public final Builder jupyterLabAppImageConfig(JupyterLabAppImageConfig jupyterLabAppImageConfig) {
            this.jupyterLabAppImageConfig = jupyterLabAppImageConfig;
            return this;
        }

        public final CodeEditorAppImageConfig.Builder getCodeEditorAppImageConfig() {
            return this.codeEditorAppImageConfig != null ? this.codeEditorAppImageConfig.toBuilder() : null;
        }

        public final void setCodeEditorAppImageConfig(CodeEditorAppImageConfig.BuilderImpl codeEditorAppImageConfig) {
            this.codeEditorAppImageConfig = codeEditorAppImageConfig != null ? codeEditorAppImageConfig.build() : null;
        }

        @Override
        public final Builder codeEditorAppImageConfig(CodeEditorAppImageConfig codeEditorAppImageConfig) {
            this.codeEditorAppImageConfig = codeEditorAppImageConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAppImageConfigRequest build() {
            return new UpdateAppImageConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAppImageConfigRequest> {
        public Builder appImageConfigName(String var1);

        public Builder kernelGatewayImageConfig(KernelGatewayImageConfig var1);

        default public Builder kernelGatewayImageConfig(Consumer<KernelGatewayImageConfig.Builder> kernelGatewayImageConfig) {
            return this.kernelGatewayImageConfig((KernelGatewayImageConfig)((KernelGatewayImageConfig.Builder)KernelGatewayImageConfig.builder().applyMutation(kernelGatewayImageConfig)).build());
        }

        public Builder jupyterLabAppImageConfig(JupyterLabAppImageConfig var1);

        default public Builder jupyterLabAppImageConfig(Consumer<JupyterLabAppImageConfig.Builder> jupyterLabAppImageConfig) {
            return this.jupyterLabAppImageConfig((JupyterLabAppImageConfig)((JupyterLabAppImageConfig.Builder)JupyterLabAppImageConfig.builder().applyMutation(jupyterLabAppImageConfig)).build());
        }

        public Builder codeEditorAppImageConfig(CodeEditorAppImageConfig var1);

        default public Builder codeEditorAppImageConfig(Consumer<CodeEditorAppImageConfig.Builder> codeEditorAppImageConfig) {
            return this.codeEditorAppImageConfig((CodeEditorAppImageConfig)((CodeEditorAppImageConfig.Builder)CodeEditorAppImageConfig.builder().applyMutation(codeEditorAppImageConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

