/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.LabelingJobSummary;
import software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsResponse;

public class ListLabelingJobsPublisher
implements SdkPublisher<ListLabelingJobsResponse> {
    private final SageMakerAsyncClient client;
    private final ListLabelingJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLabelingJobsPublisher(SageMakerAsyncClient client, ListLabelingJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLabelingJobsPublisher(SageMakerAsyncClient client, ListLabelingJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLabelingJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLabelingJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LabelingJobSummary> labelingJobSummaryList() {
        Function<ListLabelingJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.labelingJobSummaryList() != null) {
                return response.labelingJobSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListLabelingJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListLabelingJobsResponseFetcher
    implements AsyncPageFetcher<ListLabelingJobsResponse> {
        private ListLabelingJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListLabelingJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLabelingJobsResponse> nextPage(ListLabelingJobsResponse previousPage) {
            if (previousPage == null) {
                return ListLabelingJobsPublisher.this.client.listLabelingJobs(ListLabelingJobsPublisher.this.firstRequest);
            }
            return ListLabelingJobsPublisher.this.client.listLabelingJobs((ListLabelingJobsRequest)((Object)ListLabelingJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

