/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ClusterInstanceGroupDetails;
import software.amazon.awssdk.services.sagemaker.model.ClusterInstanceGroupDetailsListCopier;
import software.amazon.awssdk.services.sagemaker.model.ClusterNodeRecovery;
import software.amazon.awssdk.services.sagemaker.model.ClusterOrchestrator;
import software.amazon.awssdk.services.sagemaker.model.ClusterStatus;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeClusterResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeClusterResponse> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterArn").getter(DescribeClusterResponse.getter(DescribeClusterResponse::clusterArn)).setter(DescribeClusterResponse.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterArn").build()}).build();
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterName").getter(DescribeClusterResponse.getter(DescribeClusterResponse::clusterName)).setter(DescribeClusterResponse.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterName").build()}).build();
    private static final SdkField<String> CLUSTER_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterStatus").getter(DescribeClusterResponse.getter(DescribeClusterResponse::clusterStatusAsString)).setter(DescribeClusterResponse.setter(Builder::clusterStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterStatus").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeClusterResponse.getter(DescribeClusterResponse::creationTime)).setter(DescribeClusterResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureMessage").getter(DescribeClusterResponse.getter(DescribeClusterResponse::failureMessage)).setter(DescribeClusterResponse.setter(Builder::failureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMessage").build()}).build();
    private static final SdkField<List<ClusterInstanceGroupDetails>> INSTANCE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceGroups").getter(DescribeClusterResponse.getter(DescribeClusterResponse::instanceGroups)).setter(DescribeClusterResponse.setter(Builder::instanceGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterInstanceGroupDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfig").getter(DescribeClusterResponse.getter(DescribeClusterResponse::vpcConfig)).setter(DescribeClusterResponse.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final SdkField<ClusterOrchestrator> ORCHESTRATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Orchestrator").getter(DescribeClusterResponse.getter(DescribeClusterResponse::orchestrator)).setter(DescribeClusterResponse.setter(Builder::orchestrator)).constructor(ClusterOrchestrator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Orchestrator").build()}).build();
    private static final SdkField<String> NODE_RECOVERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeRecovery").getter(DescribeClusterResponse.getter(DescribeClusterResponse::nodeRecoveryAsString)).setter(DescribeClusterResponse.setter(Builder::nodeRecovery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeRecovery").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD, CLUSTER_NAME_FIELD, CLUSTER_STATUS_FIELD, CREATION_TIME_FIELD, FAILURE_MESSAGE_FIELD, INSTANCE_GROUPS_FIELD, VPC_CONFIG_FIELD, ORCHESTRATOR_FIELD, NODE_RECOVERY_FIELD));
    private final String clusterArn;
    private final String clusterName;
    private final String clusterStatus;
    private final Instant creationTime;
    private final String failureMessage;
    private final List<ClusterInstanceGroupDetails> instanceGroups;
    private final VpcConfig vpcConfig;
    private final ClusterOrchestrator orchestrator;
    private final String nodeRecovery;

    private DescribeClusterResponse(BuilderImpl builder) {
        super(builder);
        this.clusterArn = builder.clusterArn;
        this.clusterName = builder.clusterName;
        this.clusterStatus = builder.clusterStatus;
        this.creationTime = builder.creationTime;
        this.failureMessage = builder.failureMessage;
        this.instanceGroups = builder.instanceGroups;
        this.vpcConfig = builder.vpcConfig;
        this.orchestrator = builder.orchestrator;
        this.nodeRecovery = builder.nodeRecovery;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final ClusterStatus clusterStatus() {
        return ClusterStatus.fromValue(this.clusterStatus);
    }

    public final String clusterStatusAsString() {
        return this.clusterStatus;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String failureMessage() {
        return this.failureMessage;
    }

    public final boolean hasInstanceGroups() {
        return this.instanceGroups != null && !(this.instanceGroups instanceof SdkAutoConstructList);
    }

    public final List<ClusterInstanceGroupDetails> instanceGroups() {
        return this.instanceGroups;
    }

    public final VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public final ClusterOrchestrator orchestrator() {
        return this.orchestrator;
    }

    public final ClusterNodeRecovery nodeRecovery() {
        return ClusterNodeRecovery.fromValue(this.nodeRecovery);
    }

    public final String nodeRecoveryAsString() {
        return this.nodeRecovery;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceGroups() ? this.instanceGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.orchestrator());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeRecoveryAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterResponse)) {
            return false;
        }
        DescribeClusterResponse other = (DescribeClusterResponse)((Object)obj);
        return Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.clusterStatusAsString(), other.clusterStatusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.failureMessage(), other.failureMessage()) && this.hasInstanceGroups() == other.hasInstanceGroups() && Objects.equals(this.instanceGroups(), other.instanceGroups()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.orchestrator(), other.orchestrator()) && Objects.equals(this.nodeRecoveryAsString(), other.nodeRecoveryAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeClusterResponse").add("ClusterArn", (Object)this.clusterArn()).add("ClusterName", (Object)this.clusterName()).add("ClusterStatus", (Object)this.clusterStatusAsString()).add("CreationTime", (Object)this.creationTime()).add("FailureMessage", (Object)this.failureMessage()).add("InstanceGroups", this.hasInstanceGroups() ? this.instanceGroups() : null).add("VpcConfig", (Object)this.vpcConfig()).add("Orchestrator", (Object)this.orchestrator()).add("NodeRecovery", (Object)this.nodeRecoveryAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "ClusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "ClusterStatus": {
                return Optional.ofNullable(clazz.cast(this.clusterStatusAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "FailureMessage": {
                return Optional.ofNullable(clazz.cast(this.failureMessage()));
            }
            case "InstanceGroups": {
                return Optional.ofNullable(clazz.cast(this.instanceGroups()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "Orchestrator": {
                return Optional.ofNullable(clazz.cast(this.orchestrator()));
            }
            case "NodeRecovery": {
                return Optional.ofNullable(clazz.cast(this.nodeRecoveryAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClusterResponse, T> g) {
        return obj -> g.apply((DescribeClusterResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String clusterArn;
        private String clusterName;
        private String clusterStatus;
        private Instant creationTime;
        private String failureMessage;
        private List<ClusterInstanceGroupDetails> instanceGroups = DefaultSdkAutoConstructList.getInstance();
        private VpcConfig vpcConfig;
        private ClusterOrchestrator orchestrator;
        private String nodeRecovery;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterResponse model) {
            super(model);
            this.clusterArn(model.clusterArn);
            this.clusterName(model.clusterName);
            this.clusterStatus(model.clusterStatus);
            this.creationTime(model.creationTime);
            this.failureMessage(model.failureMessage);
            this.instanceGroups(model.instanceGroups);
            this.vpcConfig(model.vpcConfig);
            this.orchestrator(model.orchestrator);
            this.nodeRecovery(model.nodeRecovery);
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getClusterStatus() {
            return this.clusterStatus;
        }

        public final void setClusterStatus(String clusterStatus) {
            this.clusterStatus = clusterStatus;
        }

        @Override
        public final Builder clusterStatus(String clusterStatus) {
            this.clusterStatus = clusterStatus;
            return this;
        }

        @Override
        public final Builder clusterStatus(ClusterStatus clusterStatus) {
            this.clusterStatus(clusterStatus == null ? null : clusterStatus.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final List<ClusterInstanceGroupDetails.Builder> getInstanceGroups() {
            List<ClusterInstanceGroupDetails.Builder> result = ClusterInstanceGroupDetailsListCopier.copyToBuilder(this.instanceGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceGroups(Collection<ClusterInstanceGroupDetails.BuilderImpl> instanceGroups) {
            this.instanceGroups = ClusterInstanceGroupDetailsListCopier.copyFromBuilder(instanceGroups);
        }

        @Override
        public final Builder instanceGroups(Collection<ClusterInstanceGroupDetails> instanceGroups) {
            this.instanceGroups = ClusterInstanceGroupDetailsListCopier.copy(instanceGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(ClusterInstanceGroupDetails ... instanceGroups) {
            this.instanceGroups(Arrays.asList(instanceGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(Consumer<ClusterInstanceGroupDetails.Builder> ... instanceGroups) {
            this.instanceGroups(Stream.of(instanceGroups).map(c -> (ClusterInstanceGroupDetails)((ClusterInstanceGroupDetails.Builder)ClusterInstanceGroupDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final ClusterOrchestrator.Builder getOrchestrator() {
            return this.orchestrator != null ? this.orchestrator.toBuilder() : null;
        }

        public final void setOrchestrator(ClusterOrchestrator.BuilderImpl orchestrator) {
            this.orchestrator = orchestrator != null ? orchestrator.build() : null;
        }

        @Override
        public final Builder orchestrator(ClusterOrchestrator orchestrator) {
            this.orchestrator = orchestrator;
            return this;
        }

        public final String getNodeRecovery() {
            return this.nodeRecovery;
        }

        public final void setNodeRecovery(String nodeRecovery) {
            this.nodeRecovery = nodeRecovery;
        }

        @Override
        public final Builder nodeRecovery(String nodeRecovery) {
            this.nodeRecovery = nodeRecovery;
            return this;
        }

        @Override
        public final Builder nodeRecovery(ClusterNodeRecovery nodeRecovery) {
            this.nodeRecovery(nodeRecovery == null ? null : nodeRecovery.toString());
            return this;
        }

        @Override
        public DescribeClusterResponse build() {
            return new DescribeClusterResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeClusterResponse> {
        public Builder clusterArn(String var1);

        public Builder clusterName(String var1);

        public Builder clusterStatus(String var1);

        public Builder clusterStatus(ClusterStatus var1);

        public Builder creationTime(Instant var1);

        public Builder failureMessage(String var1);

        public Builder instanceGroups(Collection<ClusterInstanceGroupDetails> var1);

        public Builder instanceGroups(ClusterInstanceGroupDetails ... var1);

        public Builder instanceGroups(Consumer<ClusterInstanceGroupDetails.Builder> ... var1);

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder orchestrator(ClusterOrchestrator var1);

        default public Builder orchestrator(Consumer<ClusterOrchestrator.Builder> orchestrator) {
            return this.orchestrator((ClusterOrchestrator)((ClusterOrchestrator.Builder)ClusterOrchestrator.builder().applyMutation(orchestrator)).build());
        }

        public Builder nodeRecovery(String var1);

        public Builder nodeRecovery(ClusterNodeRecovery var1);
    }
}

