/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubAsyncClient;
import software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportRequest;
import software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportResponse;

public class ListEnabledProductsForImportPublisher
implements SdkPublisher<ListEnabledProductsForImportResponse> {
    private final SecurityHubAsyncClient client;
    private final ListEnabledProductsForImportRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEnabledProductsForImportPublisher(SecurityHubAsyncClient client, ListEnabledProductsForImportRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEnabledProductsForImportPublisher(SecurityHubAsyncClient client, ListEnabledProductsForImportRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEnabledProductsForImportResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEnabledProductsForImportResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListEnabledProductsForImportPublisher resume(ListEnabledProductsForImportResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListEnabledProductsForImportPublisher(this.client, (ListEnabledProductsForImportRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListEnabledProductsForImportPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListEnabledProductsForImportResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListEnabledProductsForImportResponseFetcher
    implements AsyncPageFetcher<ListEnabledProductsForImportResponse> {
        private ListEnabledProductsForImportResponseFetcher() {
        }

        public boolean hasNextPage(ListEnabledProductsForImportResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEnabledProductsForImportResponse> nextPage(ListEnabledProductsForImportResponse previousPage) {
            if (previousPage == null) {
                return ListEnabledProductsForImportPublisher.this.client.listEnabledProductsForImport(ListEnabledProductsForImportPublisher.this.firstRequest);
            }
            return ListEnabledProductsForImportPublisher.this.client.listEnabledProductsForImport((ListEnabledProductsForImportRequest)((Object)ListEnabledProductsForImportPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

