/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.EmailTemplateContent;
import software.amazon.awssdk.services.sesv2.model.MessageHeader;
import software.amazon.awssdk.services.sesv2.model.MessageHeaderListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Template
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Template> {
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateName").getter(Template.getter(Template::templateName)).setter(Template.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()}).build();
    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateArn").getter(Template.getter(Template::templateArn)).setter(Template.setter(Builder::templateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateArn").build()}).build();
    private static final SdkField<EmailTemplateContent> TEMPLATE_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TemplateContent").getter(Template.getter(Template::templateContent)).setter(Template.setter(Builder::templateContent)).constructor(EmailTemplateContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateContent").build()}).build();
    private static final SdkField<String> TEMPLATE_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateData").getter(Template.getter(Template::templateData)).setter(Template.setter(Builder::templateData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateData").build()}).build();
    private static final SdkField<List<MessageHeader>> HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Headers").getter(Template.getter(Template::headers)).setter(Template.setter(Builder::headers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Headers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MessageHeader::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_NAME_FIELD, TEMPLATE_ARN_FIELD, TEMPLATE_CONTENT_FIELD, TEMPLATE_DATA_FIELD, HEADERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Template.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String templateName;
    private final String templateArn;
    private final EmailTemplateContent templateContent;
    private final String templateData;
    private final List<MessageHeader> headers;

    private Template(BuilderImpl builder) {
        this.templateName = builder.templateName;
        this.templateArn = builder.templateArn;
        this.templateContent = builder.templateContent;
        this.templateData = builder.templateData;
        this.headers = builder.headers;
    }

    public final String templateName() {
        return this.templateName;
    }

    public final String templateArn() {
        return this.templateArn;
    }

    public final EmailTemplateContent templateContent() {
        return this.templateContent;
    }

    public final String templateData() {
        return this.templateData;
    }

    public final boolean hasHeaders() {
        return this.headers != null && !(this.headers instanceof SdkAutoConstructList);
    }

    public final List<MessageHeader> headers() {
        return this.headers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateData());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHeaders() ? this.headers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Template)) {
            return false;
        }
        Template other = (Template)obj;
        return Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.templateArn(), other.templateArn()) && Objects.equals(this.templateContent(), other.templateContent()) && Objects.equals(this.templateData(), other.templateData()) && this.hasHeaders() == other.hasHeaders() && Objects.equals(this.headers(), other.headers());
    }

    public final String toString() {
        return ToString.builder((String)"Template").add("TemplateName", (Object)this.templateName()).add("TemplateArn", (Object)this.templateArn()).add("TemplateContent", (Object)this.templateContent()).add("TemplateData", (Object)this.templateData()).add("Headers", this.hasHeaders() ? this.headers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TemplateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
            case "TemplateArn": {
                return Optional.ofNullable(clazz.cast(this.templateArn()));
            }
            case "TemplateContent": {
                return Optional.ofNullable(clazz.cast(this.templateContent()));
            }
            case "TemplateData": {
                return Optional.ofNullable(clazz.cast(this.templateData()));
            }
            case "Headers": {
                return Optional.ofNullable(clazz.cast(this.headers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TemplateName", TEMPLATE_NAME_FIELD);
        map.put("TemplateArn", TEMPLATE_ARN_FIELD);
        map.put("TemplateContent", TEMPLATE_CONTENT_FIELD);
        map.put("TemplateData", TEMPLATE_DATA_FIELD);
        map.put("Headers", HEADERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Template, T> g) {
        return obj -> g.apply((Template)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String templateName;
        private String templateArn;
        private EmailTemplateContent templateContent;
        private String templateData;
        private List<MessageHeader> headers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Template model) {
            this.templateName(model.templateName);
            this.templateArn(model.templateArn);
            this.templateContent(model.templateContent);
            this.templateData(model.templateData);
            this.headers(model.headers);
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getTemplateArn() {
            return this.templateArn;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        public final EmailTemplateContent.Builder getTemplateContent() {
            return this.templateContent != null ? this.templateContent.toBuilder() : null;
        }

        public final void setTemplateContent(EmailTemplateContent.BuilderImpl templateContent) {
            this.templateContent = templateContent != null ? templateContent.build() : null;
        }

        @Override
        public final Builder templateContent(EmailTemplateContent templateContent) {
            this.templateContent = templateContent;
            return this;
        }

        public final String getTemplateData() {
            return this.templateData;
        }

        public final void setTemplateData(String templateData) {
            this.templateData = templateData;
        }

        @Override
        public final Builder templateData(String templateData) {
            this.templateData = templateData;
            return this;
        }

        public final List<MessageHeader.Builder> getHeaders() {
            List<MessageHeader.Builder> result = MessageHeaderListCopier.copyToBuilder(this.headers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHeaders(Collection<MessageHeader.BuilderImpl> headers) {
            this.headers = MessageHeaderListCopier.copyFromBuilder(headers);
        }

        @Override
        public final Builder headers(Collection<MessageHeader> headers) {
            this.headers = MessageHeaderListCopier.copy(headers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(MessageHeader ... headers) {
            this.headers(Arrays.asList(headers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(Consumer<MessageHeader.Builder> ... headers) {
            this.headers(Stream.of(headers).map(c -> (MessageHeader)((MessageHeader.Builder)MessageHeader.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Template build() {
            return new Template(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Template> {
        public Builder templateName(String var1);

        public Builder templateArn(String var1);

        public Builder templateContent(EmailTemplateContent var1);

        default public Builder templateContent(Consumer<EmailTemplateContent.Builder> templateContent) {
            return this.templateContent((EmailTemplateContent)((EmailTemplateContent.Builder)EmailTemplateContent.builder().applyMutation(templateContent)).build());
        }

        public Builder templateData(String var1);

        public Builder headers(Collection<MessageHeader> var1);

        public Builder headers(MessageHeader ... var1);

        public Builder headers(Consumer<MessageHeader.Builder> ... var1);
    }
}

