/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that describes workflow billing details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BillingDetails implements SdkPojo, Serializable, ToCopyableBuilder<BillingDetails.Builder, BillingDetails> {
    private static final SdkField<Long> BILLED_MEMORY_USED_IN_MB_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("billedMemoryUsedInMB").getter(getter(BillingDetails::billedMemoryUsedInMB))
            .setter(setter(Builder::billedMemoryUsedInMB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billedMemoryUsedInMB").build())
            .build();

    private static final SdkField<Long> BILLED_DURATION_IN_MILLISECONDS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("billedDurationInMilliseconds")
            .getter(getter(BillingDetails::billedDurationInMilliseconds))
            .setter(setter(Builder::billedDurationInMilliseconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billedDurationInMilliseconds")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BILLED_MEMORY_USED_IN_MB_FIELD, BILLED_DURATION_IN_MILLISECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("billedMemoryUsedInMB", BILLED_MEMORY_USED_IN_MB_FIELD);
                    put("billedDurationInMilliseconds", BILLED_DURATION_IN_MILLISECONDS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Long billedMemoryUsedInMB;

    private final Long billedDurationInMilliseconds;

    private BillingDetails(BuilderImpl builder) {
        this.billedMemoryUsedInMB = builder.billedMemoryUsedInMB;
        this.billedDurationInMilliseconds = builder.billedDurationInMilliseconds;
    }

    /**
     * <p>
     * Billed memory consumption of your workflow, in MB.
     * </p>
     * 
     * @return Billed memory consumption of your workflow, in MB.
     */
    public final Long billedMemoryUsedInMB() {
        return billedMemoryUsedInMB;
    }

    /**
     * <p>
     * Billed duration of your workflow, in milliseconds.
     * </p>
     * 
     * @return Billed duration of your workflow, in milliseconds.
     */
    public final Long billedDurationInMilliseconds() {
        return billedDurationInMilliseconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(billedMemoryUsedInMB());
        hashCode = 31 * hashCode + Objects.hashCode(billedDurationInMilliseconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BillingDetails)) {
            return false;
        }
        BillingDetails other = (BillingDetails) obj;
        return Objects.equals(billedMemoryUsedInMB(), other.billedMemoryUsedInMB())
                && Objects.equals(billedDurationInMilliseconds(), other.billedDurationInMilliseconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BillingDetails").add("BilledMemoryUsedInMB", billedMemoryUsedInMB())
                .add("BilledDurationInMilliseconds", billedDurationInMilliseconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "billedMemoryUsedInMB":
            return Optional.ofNullable(clazz.cast(billedMemoryUsedInMB()));
        case "billedDurationInMilliseconds":
            return Optional.ofNullable(clazz.cast(billedDurationInMilliseconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BillingDetails, T> g) {
        return obj -> g.apply((BillingDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BillingDetails> {
        /**
         * <p>
         * Billed memory consumption of your workflow, in MB.
         * </p>
         * 
         * @param billedMemoryUsedInMB
         *        Billed memory consumption of your workflow, in MB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billedMemoryUsedInMB(Long billedMemoryUsedInMB);

        /**
         * <p>
         * Billed duration of your workflow, in milliseconds.
         * </p>
         * 
         * @param billedDurationInMilliseconds
         *        Billed duration of your workflow, in milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billedDurationInMilliseconds(Long billedDurationInMilliseconds);
    }

    static final class BuilderImpl implements Builder {
        private Long billedMemoryUsedInMB;

        private Long billedDurationInMilliseconds;

        private BuilderImpl() {
        }

        private BuilderImpl(BillingDetails model) {
            billedMemoryUsedInMB(model.billedMemoryUsedInMB);
            billedDurationInMilliseconds(model.billedDurationInMilliseconds);
        }

        public final Long getBilledMemoryUsedInMB() {
            return billedMemoryUsedInMB;
        }

        public final void setBilledMemoryUsedInMB(Long billedMemoryUsedInMB) {
            this.billedMemoryUsedInMB = billedMemoryUsedInMB;
        }

        @Override
        public final Builder billedMemoryUsedInMB(Long billedMemoryUsedInMB) {
            this.billedMemoryUsedInMB = billedMemoryUsedInMB;
            return this;
        }

        public final Long getBilledDurationInMilliseconds() {
            return billedDurationInMilliseconds;
        }

        public final void setBilledDurationInMilliseconds(Long billedDurationInMilliseconds) {
            this.billedDurationInMilliseconds = billedDurationInMilliseconds;
        }

        @Override
        public final Builder billedDurationInMilliseconds(Long billedDurationInMilliseconds) {
            this.billedDurationInMilliseconds = billedDurationInMilliseconds;
            return this;
        }

        @Override
        public BillingDetails build() {
            return new BillingDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
