/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeExecutionResponse extends SfnResponse implements
        ToCopyableBuilder<DescribeExecutionResponse.Builder, DescribeExecutionResponse> {
    private static final SdkField<String> EXECUTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionArn").getter(getter(DescribeExecutionResponse::executionArn))
            .setter(setter(Builder::executionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionArn").build()).build();

    private static final SdkField<String> STATE_MACHINE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stateMachineArn").getter(getter(DescribeExecutionResponse::stateMachineArn))
            .setter(setter(Builder::stateMachineArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DescribeExecutionResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DescribeExecutionResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> START_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startDate").getter(getter(DescribeExecutionResponse::startDate)).setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startDate").build()).build();

    private static final SdkField<Instant> STOP_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("stopDate").getter(getter(DescribeExecutionResponse::stopDate)).setter(setter(Builder::stopDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopDate").build()).build();

    private static final SdkField<String> INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("input")
            .getter(getter(DescribeExecutionResponse::input)).setter(setter(Builder::input))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()).build();

    private static final SdkField<CloudWatchEventsExecutionDataDetails> INPUT_DETAILS_FIELD = SdkField
            .<CloudWatchEventsExecutionDataDetails> builder(MarshallingType.SDK_POJO).memberName("inputDetails")
            .getter(getter(DescribeExecutionResponse::inputDetails)).setter(setter(Builder::inputDetails))
            .constructor(CloudWatchEventsExecutionDataDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDetails").build()).build();

    private static final SdkField<String> OUTPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("output")
            .getter(getter(DescribeExecutionResponse::output)).setter(setter(Builder::output))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("output").build()).build();

    private static final SdkField<CloudWatchEventsExecutionDataDetails> OUTPUT_DETAILS_FIELD = SdkField
            .<CloudWatchEventsExecutionDataDetails> builder(MarshallingType.SDK_POJO).memberName("outputDetails")
            .getter(getter(DescribeExecutionResponse::outputDetails)).setter(setter(Builder::outputDetails))
            .constructor(CloudWatchEventsExecutionDataDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputDetails").build()).build();

    private static final SdkField<String> TRACE_HEADER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("traceHeader").getter(getter(DescribeExecutionResponse::traceHeader))
            .setter(setter(Builder::traceHeader))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("traceHeader").build()).build();

    private static final SdkField<String> MAP_RUN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mapRunArn").getter(getter(DescribeExecutionResponse::mapRunArn)).setter(setter(Builder::mapRunArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mapRunArn").build()).build();

    private static final SdkField<String> ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("error")
            .getter(getter(DescribeExecutionResponse::error)).setter(setter(Builder::error))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final SdkField<String> CAUSE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cause")
            .getter(getter(DescribeExecutionResponse::cause)).setter(setter(Builder::cause))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cause").build()).build();

    private static final SdkField<String> STATE_MACHINE_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stateMachineVersionArn").getter(getter(DescribeExecutionResponse::stateMachineVersionArn))
            .setter(setter(Builder::stateMachineVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineVersionArn").build())
            .build();

    private static final SdkField<String> STATE_MACHINE_ALIAS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stateMachineAliasArn").getter(getter(DescribeExecutionResponse::stateMachineAliasArn))
            .setter(setter(Builder::stateMachineAliasArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineAliasArn").build())
            .build();

    private static final SdkField<Integer> REDRIVE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("redriveCount").getter(getter(DescribeExecutionResponse::redriveCount))
            .setter(setter(Builder::redriveCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redriveCount").build()).build();

    private static final SdkField<Instant> REDRIVE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("redriveDate").getter(getter(DescribeExecutionResponse::redriveDate))
            .setter(setter(Builder::redriveDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redriveDate").build()).build();

    private static final SdkField<String> REDRIVE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("redriveStatus").getter(getter(DescribeExecutionResponse::redriveStatusAsString))
            .setter(setter(Builder::redriveStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redriveStatus").build()).build();

    private static final SdkField<String> REDRIVE_STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("redriveStatusReason").getter(getter(DescribeExecutionResponse::redriveStatusReason))
            .setter(setter(Builder::redriveStatusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redriveStatusReason").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ARN_FIELD,
            STATE_MACHINE_ARN_FIELD, NAME_FIELD, STATUS_FIELD, START_DATE_FIELD, STOP_DATE_FIELD, INPUT_FIELD,
            INPUT_DETAILS_FIELD, OUTPUT_FIELD, OUTPUT_DETAILS_FIELD, TRACE_HEADER_FIELD, MAP_RUN_ARN_FIELD, ERROR_FIELD,
            CAUSE_FIELD, STATE_MACHINE_VERSION_ARN_FIELD, STATE_MACHINE_ALIAS_ARN_FIELD, REDRIVE_COUNT_FIELD, REDRIVE_DATE_FIELD,
            REDRIVE_STATUS_FIELD, REDRIVE_STATUS_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("executionArn", EXECUTION_ARN_FIELD);
                    put("stateMachineArn", STATE_MACHINE_ARN_FIELD);
                    put("name", NAME_FIELD);
                    put("status", STATUS_FIELD);
                    put("startDate", START_DATE_FIELD);
                    put("stopDate", STOP_DATE_FIELD);
                    put("input", INPUT_FIELD);
                    put("inputDetails", INPUT_DETAILS_FIELD);
                    put("output", OUTPUT_FIELD);
                    put("outputDetails", OUTPUT_DETAILS_FIELD);
                    put("traceHeader", TRACE_HEADER_FIELD);
                    put("mapRunArn", MAP_RUN_ARN_FIELD);
                    put("error", ERROR_FIELD);
                    put("cause", CAUSE_FIELD);
                    put("stateMachineVersionArn", STATE_MACHINE_VERSION_ARN_FIELD);
                    put("stateMachineAliasArn", STATE_MACHINE_ALIAS_ARN_FIELD);
                    put("redriveCount", REDRIVE_COUNT_FIELD);
                    put("redriveDate", REDRIVE_DATE_FIELD);
                    put("redriveStatus", REDRIVE_STATUS_FIELD);
                    put("redriveStatusReason", REDRIVE_STATUS_REASON_FIELD);
                }
            });

    private final String executionArn;

    private final String stateMachineArn;

    private final String name;

    private final String status;

    private final Instant startDate;

    private final Instant stopDate;

    private final String input;

    private final CloudWatchEventsExecutionDataDetails inputDetails;

    private final String output;

    private final CloudWatchEventsExecutionDataDetails outputDetails;

    private final String traceHeader;

    private final String mapRunArn;

    private final String error;

    private final String causeValue;

    private final String stateMachineVersionArn;

    private final String stateMachineAliasArn;

    private final Integer redriveCount;

    private final Instant redriveDate;

    private final String redriveStatus;

    private final String redriveStatusReason;

    private DescribeExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.executionArn = builder.executionArn;
        this.stateMachineArn = builder.stateMachineArn;
        this.name = builder.name;
        this.status = builder.status;
        this.startDate = builder.startDate;
        this.stopDate = builder.stopDate;
        this.input = builder.input;
        this.inputDetails = builder.inputDetails;
        this.output = builder.output;
        this.outputDetails = builder.outputDetails;
        this.traceHeader = builder.traceHeader;
        this.mapRunArn = builder.mapRunArn;
        this.error = builder.error;
        this.causeValue = builder.causeValue;
        this.stateMachineVersionArn = builder.stateMachineVersionArn;
        this.stateMachineAliasArn = builder.stateMachineAliasArn;
        this.redriveCount = builder.redriveCount;
        this.redriveDate = builder.redriveDate;
        this.redriveStatus = builder.redriveStatus;
        this.redriveStatusReason = builder.redriveStatusReason;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies the execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies the execution.
     */
    public final String executionArn() {
        return executionArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the executed stated machine.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the executed stated machine.
     */
    public final String stateMachineArn() {
        return stateMachineArn;
    }

    /**
     * <p>
     * The name of the execution.
     * </p>
     * <p>
     * A name must <i>not</i> contain:
     * </p>
     * <ul>
     * <li>
     * <p>
     * white space
     * </p>
     * </li>
     * <li>
     * <p>
     * brackets <code>&lt; &gt; { } [ ]</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * wildcard characters <code>? *</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)
     * </p>
     * </li>
     * </ul>
     * <p>
     * To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
     * </p>
     * 
     * @return The name of the execution.</p>
     *         <p>
     *         A name must <i>not</i> contain:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         white space
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         brackets <code>&lt; &gt; { } [ ]</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         wildcard characters <code>? *</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The current status of the execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the execution.
     * @see ExecutionStatus
     */
    public final ExecutionStatus status() {
        return ExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the execution.
     * @see ExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date the execution is started.
     * </p>
     * 
     * @return The date the execution is started.
     */
    public final Instant startDate() {
        return startDate;
    }

    /**
     * <p>
     * If the execution ended, the date the execution stopped.
     * </p>
     * 
     * @return If the execution ended, the date the execution stopped.
     */
    public final Instant stopDate() {
        return stopDate;
    }

    /**
     * <p>
     * The string that contains the JSON input data of the execution. Length constraints apply to the payload size, and
     * are expressed as bytes in UTF-8 encoding.
     * </p>
     * 
     * @return The string that contains the JSON input data of the execution. Length constraints apply to the payload
     *         size, and are expressed as bytes in UTF-8 encoding.
     */
    public final String input() {
        return input;
    }

    /**
     * Returns the value of the InputDetails property for this object.
     * 
     * @return The value of the InputDetails property for this object.
     */
    public final CloudWatchEventsExecutionDataDetails inputDetails() {
        return inputDetails;
    }

    /**
     * <p>
     * The JSON output data of the execution. Length constraints apply to the payload size, and are expressed as bytes
     * in UTF-8 encoding.
     * </p>
     * <note>
     * <p>
     * This field is set only if the execution succeeds. If the execution fails, this field is null.
     * </p>
     * </note>
     * 
     * @return The JSON output data of the execution. Length constraints apply to the payload size, and are expressed as
     *         bytes in UTF-8 encoding.</p> <note>
     *         <p>
     *         This field is set only if the execution succeeds. If the execution fails, this field is null.
     *         </p>
     */
    public final String output() {
        return output;
    }

    /**
     * Returns the value of the OutputDetails property for this object.
     * 
     * @return The value of the OutputDetails property for this object.
     */
    public final CloudWatchEventsExecutionDataDetails outputDetails() {
        return outputDetails;
    }

    /**
     * <p>
     * The X-Ray trace header that was passed to the execution.
     * </p>
     * 
     * @return The X-Ray trace header that was passed to the execution.
     */
    public final String traceHeader() {
        return traceHeader;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies a Map Run, which dispatched this execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies a Map Run, which dispatched this execution.
     */
    public final String mapRunArn() {
        return mapRunArn;
    }

    /**
     * <p>
     * The error string if the state machine execution failed.
     * </p>
     * 
     * @return The error string if the state machine execution failed.
     */
    public final String error() {
        return error;
    }

    /**
     * <p>
     * The cause string if the state machine execution failed.
     * </p>
     * 
     * @return The cause string if the state machine execution failed.
     */
    public final String cause() {
        return causeValue;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the state machine version associated with the execution. The version ARN is a
     * combination of state machine ARN and the version number separated by a colon (:). For example,
     * <code>stateMachineARN:1</code>.
     * </p>
     * <p>
     * If you start an execution from a <code>StartExecution</code> request without specifying a state machine version
     * or alias ARN, Step Functions returns a null value.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the state machine version associated with the execution. The version
     *         ARN is a combination of state machine ARN and the version number separated by a colon (:). For example,
     *         <code>stateMachineARN:1</code>.</p>
     *         <p>
     *         If you start an execution from a <code>StartExecution</code> request without specifying a state machine
     *         version or alias ARN, Step Functions returns a null value.
     */
    public final String stateMachineVersionArn() {
        return stateMachineVersionArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the state machine alias associated with the execution. The alias ARN is a
     * combination of state machine ARN and the alias name separated by a colon (:). For example,
     * <code>stateMachineARN:PROD</code>.
     * </p>
     * <p>
     * If you start an execution from a <code>StartExecution</code> request with a state machine version ARN, this field
     * will be null.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the state machine alias associated with the execution. The alias ARN is
     *         a combination of state machine ARN and the alias name separated by a colon (:). For example,
     *         <code>stateMachineARN:PROD</code>.</p>
     *         <p>
     *         If you start an execution from a <code>StartExecution</code> request with a state machine version ARN,
     *         this field will be null.
     */
    public final String stateMachineAliasArn() {
        return stateMachineAliasArn;
    }

    /**
     * <p>
     * The number of times you've redriven an execution. If you have not yet redriven an execution, the
     * <code>redriveCount</code> is 0. This count is only updated if you successfully redrive an execution.
     * </p>
     * 
     * @return The number of times you've redriven an execution. If you have not yet redriven an execution, the
     *         <code>redriveCount</code> is 0. This count is only updated if you successfully redrive an execution.
     */
    public final Integer redriveCount() {
        return redriveCount;
    }

    /**
     * <p>
     * The date the execution was last redriven. If you have not yet redriven an execution, the <code>redriveDate</code>
     * is null.
     * </p>
     * <p>
     * The <code>redriveDate</code> is unavailable if you redrive a Map Run that starts child workflow executions of
     * type <code>EXPRESS</code>.
     * </p>
     * 
     * @return The date the execution was last redriven. If you have not yet redriven an execution, the
     *         <code>redriveDate</code> is null.</p>
     *         <p>
     *         The <code>redriveDate</code> is unavailable if you redrive a Map Run that starts child workflow
     *         executions of type <code>EXPRESS</code>.
     */
    public final Instant redriveDate() {
        return redriveDate;
    }

    /**
     * <p>
     * Indicates whether or not an execution can be redriven at a given point in time.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For executions of type <code>STANDARD</code>, <code>redriveStatus</code> is <code>NOT_REDRIVABLE</code> if
     * calling the <a>RedriveExecution</a> API action would return the <code>ExecutionNotRedrivable</code> error.
     * </p>
     * </li>
     * <li>
     * <p>
     * For a Distributed Map that includes child workflows of type <code>STANDARD</code>, <code>redriveStatus</code>
     * indicates whether or not the Map Run can redrive child workflow executions.
     * </p>
     * </li>
     * <li>
     * <p>
     * For a Distributed Map that includes child workflows of type <code>EXPRESS</code>, <code>redriveStatus</code>
     * indicates whether or not the Map Run can redrive child workflow executions.
     * </p>
     * <p>
     * You can redrive failed or timed out <code>EXPRESS</code> workflows <i>only if</i> they're a part of a Map Run.
     * When you <a href="https://docs.aws.amazon.com/step-functions/latest/dg/redrive-map-run.html">redrive</a> the Map
     * Run, these workflows are restarted using the <a>StartExecution</a> API action.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #redriveStatus}
     * will return {@link ExecutionRedriveStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #redriveStatusAsString}.
     * </p>
     * 
     * @return Indicates whether or not an execution can be redriven at a given point in time.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For executions of type <code>STANDARD</code>, <code>redriveStatus</code> is <code>NOT_REDRIVABLE</code>
     *         if calling the <a>RedriveExecution</a> API action would return the <code>ExecutionNotRedrivable</code>
     *         error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For a Distributed Map that includes child workflows of type <code>STANDARD</code>,
     *         <code>redriveStatus</code> indicates whether or not the Map Run can redrive child workflow executions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For a Distributed Map that includes child workflows of type <code>EXPRESS</code>,
     *         <code>redriveStatus</code> indicates whether or not the Map Run can redrive child workflow executions.
     *         </p>
     *         <p>
     *         You can redrive failed or timed out <code>EXPRESS</code> workflows <i>only if</i> they're a part of a Map
     *         Run. When you <a
     *         href="https://docs.aws.amazon.com/step-functions/latest/dg/redrive-map-run.html">redrive</a> the Map Run,
     *         these workflows are restarted using the <a>StartExecution</a> API action.
     *         </p>
     *         </li>
     * @see ExecutionRedriveStatus
     */
    public final ExecutionRedriveStatus redriveStatus() {
        return ExecutionRedriveStatus.fromValue(redriveStatus);
    }

    /**
     * <p>
     * Indicates whether or not an execution can be redriven at a given point in time.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For executions of type <code>STANDARD</code>, <code>redriveStatus</code> is <code>NOT_REDRIVABLE</code> if
     * calling the <a>RedriveExecution</a> API action would return the <code>ExecutionNotRedrivable</code> error.
     * </p>
     * </li>
     * <li>
     * <p>
     * For a Distributed Map that includes child workflows of type <code>STANDARD</code>, <code>redriveStatus</code>
     * indicates whether or not the Map Run can redrive child workflow executions.
     * </p>
     * </li>
     * <li>
     * <p>
     * For a Distributed Map that includes child workflows of type <code>EXPRESS</code>, <code>redriveStatus</code>
     * indicates whether or not the Map Run can redrive child workflow executions.
     * </p>
     * <p>
     * You can redrive failed or timed out <code>EXPRESS</code> workflows <i>only if</i> they're a part of a Map Run.
     * When you <a href="https://docs.aws.amazon.com/step-functions/latest/dg/redrive-map-run.html">redrive</a> the Map
     * Run, these workflows are restarted using the <a>StartExecution</a> API action.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #redriveStatus}
     * will return {@link ExecutionRedriveStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #redriveStatusAsString}.
     * </p>
     * 
     * @return Indicates whether or not an execution can be redriven at a given point in time.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For executions of type <code>STANDARD</code>, <code>redriveStatus</code> is <code>NOT_REDRIVABLE</code>
     *         if calling the <a>RedriveExecution</a> API action would return the <code>ExecutionNotRedrivable</code>
     *         error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For a Distributed Map that includes child workflows of type <code>STANDARD</code>,
     *         <code>redriveStatus</code> indicates whether or not the Map Run can redrive child workflow executions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For a Distributed Map that includes child workflows of type <code>EXPRESS</code>,
     *         <code>redriveStatus</code> indicates whether or not the Map Run can redrive child workflow executions.
     *         </p>
     *         <p>
     *         You can redrive failed or timed out <code>EXPRESS</code> workflows <i>only if</i> they're a part of a Map
     *         Run. When you <a
     *         href="https://docs.aws.amazon.com/step-functions/latest/dg/redrive-map-run.html">redrive</a> the Map Run,
     *         these workflows are restarted using the <a>StartExecution</a> API action.
     *         </p>
     *         </li>
     * @see ExecutionRedriveStatus
     */
    public final String redriveStatusAsString() {
        return redriveStatus;
    }

    /**
     * <p>
     * When <code>redriveStatus</code> is <code>NOT_REDRIVABLE</code>, <code>redriveStatusReason</code> specifies the
     * reason why an execution cannot be redriven.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For executions of type <code>STANDARD</code>, or for a Distributed Map that includes child workflows of type
     * <code>STANDARD</code>, <code>redriveStatusReason</code> can include one of the following reasons:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>State machine is in DELETING status</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Execution is RUNNING and cannot be redriven</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Execution is SUCCEEDED and cannot be redriven</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Execution was started before the launch of RedriveExecution</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Execution history event limit exceeded</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Execution has exceeded the max execution time</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Execution redrivable period exceeded</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * For a Distributed Map that includes child workflows of type <code>EXPRESS</code>,
     * <code>redriveStatusReason</code> is only returned if the child workflows are not redrivable. This happens when
     * the child workflow executions have completed successfully.
     * </p>
     * </li>
     * </ul>
     * 
     * @return When <code>redriveStatus</code> is <code>NOT_REDRIVABLE</code>, <code>redriveStatusReason</code>
     *         specifies the reason why an execution cannot be redriven.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For executions of type <code>STANDARD</code>, or for a Distributed Map that includes child workflows of
     *         type <code>STANDARD</code>, <code>redriveStatusReason</code> can include one of the following reasons:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>State machine is in DELETING status</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Execution is RUNNING and cannot be redriven</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Execution is SUCCEEDED and cannot be redriven</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Execution was started before the launch of RedriveExecution</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Execution history event limit exceeded</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Execution has exceeded the max execution time</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Execution redrivable period exceeded</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         For a Distributed Map that includes child workflows of type <code>EXPRESS</code>,
     *         <code>redriveStatusReason</code> is only returned if the child workflows are not redrivable. This happens
     *         when the child workflow executions have completed successfully.
     *         </p>
     *         </li>
     */
    public final String redriveStatusReason() {
        return redriveStatusReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(executionArn());
        hashCode = 31 * hashCode + Objects.hashCode(stateMachineArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(stopDate());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(inputDetails());
        hashCode = 31 * hashCode + Objects.hashCode(output());
        hashCode = 31 * hashCode + Objects.hashCode(outputDetails());
        hashCode = 31 * hashCode + Objects.hashCode(traceHeader());
        hashCode = 31 * hashCode + Objects.hashCode(mapRunArn());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(cause());
        hashCode = 31 * hashCode + Objects.hashCode(stateMachineVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(stateMachineAliasArn());
        hashCode = 31 * hashCode + Objects.hashCode(redriveCount());
        hashCode = 31 * hashCode + Objects.hashCode(redriveDate());
        hashCode = 31 * hashCode + Objects.hashCode(redriveStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(redriveStatusReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExecutionResponse)) {
            return false;
        }
        DescribeExecutionResponse other = (DescribeExecutionResponse) obj;
        return Objects.equals(executionArn(), other.executionArn()) && Objects.equals(stateMachineArn(), other.stateMachineArn())
                && Objects.equals(name(), other.name()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(startDate(), other.startDate()) && Objects.equals(stopDate(), other.stopDate())
                && Objects.equals(input(), other.input()) && Objects.equals(inputDetails(), other.inputDetails())
                && Objects.equals(output(), other.output()) && Objects.equals(outputDetails(), other.outputDetails())
                && Objects.equals(traceHeader(), other.traceHeader()) && Objects.equals(mapRunArn(), other.mapRunArn())
                && Objects.equals(error(), other.error()) && Objects.equals(cause(), other.cause())
                && Objects.equals(stateMachineVersionArn(), other.stateMachineVersionArn())
                && Objects.equals(stateMachineAliasArn(), other.stateMachineAliasArn())
                && Objects.equals(redriveCount(), other.redriveCount()) && Objects.equals(redriveDate(), other.redriveDate())
                && Objects.equals(redriveStatusAsString(), other.redriveStatusAsString())
                && Objects.equals(redriveStatusReason(), other.redriveStatusReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeExecutionResponse").add("ExecutionArn", executionArn())
                .add("StateMachineArn", stateMachineArn()).add("Name", name()).add("Status", statusAsString())
                .add("StartDate", startDate()).add("StopDate", stopDate())
                .add("Input", input() == null ? null : "*** Sensitive Data Redacted ***").add("InputDetails", inputDetails())
                .add("Output", output() == null ? null : "*** Sensitive Data Redacted ***").add("OutputDetails", outputDetails())
                .add("TraceHeader", traceHeader()).add("MapRunArn", mapRunArn())
                .add("Error", error() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Cause", cause() == null ? null : "*** Sensitive Data Redacted ***")
                .add("StateMachineVersionArn", stateMachineVersionArn()).add("StateMachineAliasArn", stateMachineAliasArn())
                .add("RedriveCount", redriveCount()).add("RedriveDate", redriveDate())
                .add("RedriveStatus", redriveStatusAsString())
                .add("RedriveStatusReason", redriveStatusReason() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "executionArn":
            return Optional.ofNullable(clazz.cast(executionArn()));
        case "stateMachineArn":
            return Optional.ofNullable(clazz.cast(stateMachineArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "startDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        case "stopDate":
            return Optional.ofNullable(clazz.cast(stopDate()));
        case "input":
            return Optional.ofNullable(clazz.cast(input()));
        case "inputDetails":
            return Optional.ofNullable(clazz.cast(inputDetails()));
        case "output":
            return Optional.ofNullable(clazz.cast(output()));
        case "outputDetails":
            return Optional.ofNullable(clazz.cast(outputDetails()));
        case "traceHeader":
            return Optional.ofNullable(clazz.cast(traceHeader()));
        case "mapRunArn":
            return Optional.ofNullable(clazz.cast(mapRunArn()));
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        case "cause":
            return Optional.ofNullable(clazz.cast(cause()));
        case "stateMachineVersionArn":
            return Optional.ofNullable(clazz.cast(stateMachineVersionArn()));
        case "stateMachineAliasArn":
            return Optional.ofNullable(clazz.cast(stateMachineAliasArn()));
        case "redriveCount":
            return Optional.ofNullable(clazz.cast(redriveCount()));
        case "redriveDate":
            return Optional.ofNullable(clazz.cast(redriveDate()));
        case "redriveStatus":
            return Optional.ofNullable(clazz.cast(redriveStatusAsString()));
        case "redriveStatusReason":
            return Optional.ofNullable(clazz.cast(redriveStatusReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeExecutionResponse, T> g) {
        return obj -> g.apply((DescribeExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SfnResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeExecutionResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies the execution.
         * </p>
         * 
         * @param executionArn
         *        The Amazon Resource Name (ARN) that identifies the execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionArn(String executionArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the executed stated machine.
         * </p>
         * 
         * @param stateMachineArn
         *        The Amazon Resource Name (ARN) of the executed stated machine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateMachineArn(String stateMachineArn);

        /**
         * <p>
         * The name of the execution.
         * </p>
         * <p>
         * A name must <i>not</i> contain:
         * </p>
         * <ul>
         * <li>
         * <p>
         * white space
         * </p>
         * </li>
         * <li>
         * <p>
         * brackets <code>&lt; &gt; { } [ ]</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * wildcard characters <code>? *</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)
         * </p>
         * </li>
         * </ul>
         * <p>
         * To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
         * </p>
         * 
         * @param name
         *        The name of the execution.</p>
         *        <p>
         *        A name must <i>not</i> contain:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        white space
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        brackets <code>&lt; &gt; { } [ ]</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        wildcard characters <code>? *</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The current status of the execution.
         * </p>
         * 
         * @param status
         *        The current status of the execution.
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the execution.
         * </p>
         * 
         * @param status
         *        The current status of the execution.
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder status(ExecutionStatus status);

        /**
         * <p>
         * The date the execution is started.
         * </p>
         * 
         * @param startDate
         *        The date the execution is started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(Instant startDate);

        /**
         * <p>
         * If the execution ended, the date the execution stopped.
         * </p>
         * 
         * @param stopDate
         *        If the execution ended, the date the execution stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopDate(Instant stopDate);

        /**
         * <p>
         * The string that contains the JSON input data of the execution. Length constraints apply to the payload size,
         * and are expressed as bytes in UTF-8 encoding.
         * </p>
         * 
         * @param input
         *        The string that contains the JSON input data of the execution. Length constraints apply to the payload
         *        size, and are expressed as bytes in UTF-8 encoding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(String input);

        /**
         * Sets the value of the InputDetails property for this object.
         *
         * @param inputDetails
         *        The new value for the InputDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDetails(CloudWatchEventsExecutionDataDetails inputDetails);

        /**
         * Sets the value of the InputDetails property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link CloudWatchEventsExecutionDataDetails.Builder} avoiding the need to create one manually via
         * {@link CloudWatchEventsExecutionDataDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudWatchEventsExecutionDataDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #inputDetails(CloudWatchEventsExecutionDataDetails)}.
         * 
         * @param inputDetails
         *        a consumer that will call methods on {@link CloudWatchEventsExecutionDataDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDetails(CloudWatchEventsExecutionDataDetails)
         */
        default Builder inputDetails(Consumer<CloudWatchEventsExecutionDataDetails.Builder> inputDetails) {
            return inputDetails(CloudWatchEventsExecutionDataDetails.builder().applyMutation(inputDetails).build());
        }

        /**
         * <p>
         * The JSON output data of the execution. Length constraints apply to the payload size, and are expressed as
         * bytes in UTF-8 encoding.
         * </p>
         * <note>
         * <p>
         * This field is set only if the execution succeeds. If the execution fails, this field is null.
         * </p>
         * </note>
         * 
         * @param output
         *        The JSON output data of the execution. Length constraints apply to the payload size, and are expressed
         *        as bytes in UTF-8 encoding.</p> <note>
         *        <p>
         *        This field is set only if the execution succeeds. If the execution fails, this field is null.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder output(String output);

        /**
         * Sets the value of the OutputDetails property for this object.
         *
         * @param outputDetails
         *        The new value for the OutputDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputDetails(CloudWatchEventsExecutionDataDetails outputDetails);

        /**
         * Sets the value of the OutputDetails property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link CloudWatchEventsExecutionDataDetails.Builder} avoiding the need to create one manually via
         * {@link CloudWatchEventsExecutionDataDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudWatchEventsExecutionDataDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #outputDetails(CloudWatchEventsExecutionDataDetails)}.
         * 
         * @param outputDetails
         *        a consumer that will call methods on {@link CloudWatchEventsExecutionDataDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputDetails(CloudWatchEventsExecutionDataDetails)
         */
        default Builder outputDetails(Consumer<CloudWatchEventsExecutionDataDetails.Builder> outputDetails) {
            return outputDetails(CloudWatchEventsExecutionDataDetails.builder().applyMutation(outputDetails).build());
        }

        /**
         * <p>
         * The X-Ray trace header that was passed to the execution.
         * </p>
         * 
         * @param traceHeader
         *        The X-Ray trace header that was passed to the execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceHeader(String traceHeader);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies a Map Run, which dispatched this execution.
         * </p>
         * 
         * @param mapRunArn
         *        The Amazon Resource Name (ARN) that identifies a Map Run, which dispatched this execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapRunArn(String mapRunArn);

        /**
         * <p>
         * The error string if the state machine execution failed.
         * </p>
         * 
         * @param error
         *        The error string if the state machine execution failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(String error);

        /**
         * <p>
         * The cause string if the state machine execution failed.
         * </p>
         * 
         * @param causeValue
         *        The cause string if the state machine execution failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cause(String causeValue);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the state machine version associated with the execution. The version ARN is
         * a combination of state machine ARN and the version number separated by a colon (:). For example,
         * <code>stateMachineARN:1</code>.
         * </p>
         * <p>
         * If you start an execution from a <code>StartExecution</code> request without specifying a state machine
         * version or alias ARN, Step Functions returns a null value.
         * </p>
         * 
         * @param stateMachineVersionArn
         *        The Amazon Resource Name (ARN) of the state machine version associated with the execution. The version
         *        ARN is a combination of state machine ARN and the version number separated by a colon (:). For
         *        example, <code>stateMachineARN:1</code>.</p>
         *        <p>
         *        If you start an execution from a <code>StartExecution</code> request without specifying a state
         *        machine version or alias ARN, Step Functions returns a null value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateMachineVersionArn(String stateMachineVersionArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the state machine alias associated with the execution. The alias ARN is a
         * combination of state machine ARN and the alias name separated by a colon (:). For example,
         * <code>stateMachineARN:PROD</code>.
         * </p>
         * <p>
         * If you start an execution from a <code>StartExecution</code> request with a state machine version ARN, this
         * field will be null.
         * </p>
         * 
         * @param stateMachineAliasArn
         *        The Amazon Resource Name (ARN) of the state machine alias associated with the execution. The alias ARN
         *        is a combination of state machine ARN and the alias name separated by a colon (:). For example,
         *        <code>stateMachineARN:PROD</code>.</p>
         *        <p>
         *        If you start an execution from a <code>StartExecution</code> request with a state machine version ARN,
         *        this field will be null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateMachineAliasArn(String stateMachineAliasArn);

        /**
         * <p>
         * The number of times you've redriven an execution. If you have not yet redriven an execution, the
         * <code>redriveCount</code> is 0. This count is only updated if you successfully redrive an execution.
         * </p>
         * 
         * @param redriveCount
         *        The number of times you've redriven an execution. If you have not yet redriven an execution, the
         *        <code>redriveCount</code> is 0. This count is only updated if you successfully redrive an execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redriveCount(Integer redriveCount);

        /**
         * <p>
         * The date the execution was last redriven. If you have not yet redriven an execution, the
         * <code>redriveDate</code> is null.
         * </p>
         * <p>
         * The <code>redriveDate</code> is unavailable if you redrive a Map Run that starts child workflow executions of
         * type <code>EXPRESS</code>.
         * </p>
         * 
         * @param redriveDate
         *        The date the execution was last redriven. If you have not yet redriven an execution, the
         *        <code>redriveDate</code> is null.</p>
         *        <p>
         *        The <code>redriveDate</code> is unavailable if you redrive a Map Run that starts child workflow
         *        executions of type <code>EXPRESS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redriveDate(Instant redriveDate);

        /**
         * <p>
         * Indicates whether or not an execution can be redriven at a given point in time.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For executions of type <code>STANDARD</code>, <code>redriveStatus</code> is <code>NOT_REDRIVABLE</code> if
         * calling the <a>RedriveExecution</a> API action would return the <code>ExecutionNotRedrivable</code> error.
         * </p>
         * </li>
         * <li>
         * <p>
         * For a Distributed Map that includes child workflows of type <code>STANDARD</code>, <code>redriveStatus</code>
         * indicates whether or not the Map Run can redrive child workflow executions.
         * </p>
         * </li>
         * <li>
         * <p>
         * For a Distributed Map that includes child workflows of type <code>EXPRESS</code>, <code>redriveStatus</code>
         * indicates whether or not the Map Run can redrive child workflow executions.
         * </p>
         * <p>
         * You can redrive failed or timed out <code>EXPRESS</code> workflows <i>only if</i> they're a part of a Map
         * Run. When you <a href="https://docs.aws.amazon.com/step-functions/latest/dg/redrive-map-run.html">redrive</a>
         * the Map Run, these workflows are restarted using the <a>StartExecution</a> API action.
         * </p>
         * </li>
         * </ul>
         * 
         * @param redriveStatus
         *        Indicates whether or not an execution can be redriven at a given point in time.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For executions of type <code>STANDARD</code>, <code>redriveStatus</code> is
         *        <code>NOT_REDRIVABLE</code> if calling the <a>RedriveExecution</a> API action would return the
         *        <code>ExecutionNotRedrivable</code> error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For a Distributed Map that includes child workflows of type <code>STANDARD</code>,
         *        <code>redriveStatus</code> indicates whether or not the Map Run can redrive child workflow executions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For a Distributed Map that includes child workflows of type <code>EXPRESS</code>,
         *        <code>redriveStatus</code> indicates whether or not the Map Run can redrive child workflow executions.
         *        </p>
         *        <p>
         *        You can redrive failed or timed out <code>EXPRESS</code> workflows <i>only if</i> they're a part of a
         *        Map Run. When you <a
         *        href="https://docs.aws.amazon.com/step-functions/latest/dg/redrive-map-run.html">redrive</a> the Map
         *        Run, these workflows are restarted using the <a>StartExecution</a> API action.
         *        </p>
         *        </li>
         * @see ExecutionRedriveStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionRedriveStatus
         */
        Builder redriveStatus(String redriveStatus);

        /**
         * <p>
         * Indicates whether or not an execution can be redriven at a given point in time.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For executions of type <code>STANDARD</code>, <code>redriveStatus</code> is <code>NOT_REDRIVABLE</code> if
         * calling the <a>RedriveExecution</a> API action would return the <code>ExecutionNotRedrivable</code> error.
         * </p>
         * </li>
         * <li>
         * <p>
         * For a Distributed Map that includes child workflows of type <code>STANDARD</code>, <code>redriveStatus</code>
         * indicates whether or not the Map Run can redrive child workflow executions.
         * </p>
         * </li>
         * <li>
         * <p>
         * For a Distributed Map that includes child workflows of type <code>EXPRESS</code>, <code>redriveStatus</code>
         * indicates whether or not the Map Run can redrive child workflow executions.
         * </p>
         * <p>
         * You can redrive failed or timed out <code>EXPRESS</code> workflows <i>only if</i> they're a part of a Map
         * Run. When you <a href="https://docs.aws.amazon.com/step-functions/latest/dg/redrive-map-run.html">redrive</a>
         * the Map Run, these workflows are restarted using the <a>StartExecution</a> API action.
         * </p>
         * </li>
         * </ul>
         * 
         * @param redriveStatus
         *        Indicates whether or not an execution can be redriven at a given point in time.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For executions of type <code>STANDARD</code>, <code>redriveStatus</code> is
         *        <code>NOT_REDRIVABLE</code> if calling the <a>RedriveExecution</a> API action would return the
         *        <code>ExecutionNotRedrivable</code> error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For a Distributed Map that includes child workflows of type <code>STANDARD</code>,
         *        <code>redriveStatus</code> indicates whether or not the Map Run can redrive child workflow executions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For a Distributed Map that includes child workflows of type <code>EXPRESS</code>,
         *        <code>redriveStatus</code> indicates whether or not the Map Run can redrive child workflow executions.
         *        </p>
         *        <p>
         *        You can redrive failed or timed out <code>EXPRESS</code> workflows <i>only if</i> they're a part of a
         *        Map Run. When you <a
         *        href="https://docs.aws.amazon.com/step-functions/latest/dg/redrive-map-run.html">redrive</a> the Map
         *        Run, these workflows are restarted using the <a>StartExecution</a> API action.
         *        </p>
         *        </li>
         * @see ExecutionRedriveStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionRedriveStatus
         */
        Builder redriveStatus(ExecutionRedriveStatus redriveStatus);

        /**
         * <p>
         * When <code>redriveStatus</code> is <code>NOT_REDRIVABLE</code>, <code>redriveStatusReason</code> specifies
         * the reason why an execution cannot be redriven.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For executions of type <code>STANDARD</code>, or for a Distributed Map that includes child workflows of type
         * <code>STANDARD</code>, <code>redriveStatusReason</code> can include one of the following reasons:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>State machine is in DELETING status</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Execution is RUNNING and cannot be redriven</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Execution is SUCCEEDED and cannot be redriven</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Execution was started before the launch of RedriveExecution</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Execution history event limit exceeded</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Execution has exceeded the max execution time</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Execution redrivable period exceeded</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * For a Distributed Map that includes child workflows of type <code>EXPRESS</code>,
         * <code>redriveStatusReason</code> is only returned if the child workflows are not redrivable. This happens
         * when the child workflow executions have completed successfully.
         * </p>
         * </li>
         * </ul>
         * 
         * @param redriveStatusReason
         *        When <code>redriveStatus</code> is <code>NOT_REDRIVABLE</code>, <code>redriveStatusReason</code>
         *        specifies the reason why an execution cannot be redriven.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For executions of type <code>STANDARD</code>, or for a Distributed Map that includes child workflows
         *        of type <code>STANDARD</code>, <code>redriveStatusReason</code> can include one of the following
         *        reasons:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>State machine is in DELETING status</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Execution is RUNNING and cannot be redriven</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Execution is SUCCEEDED and cannot be redriven</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Execution was started before the launch of RedriveExecution</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Execution history event limit exceeded</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Execution has exceeded the max execution time</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Execution redrivable period exceeded</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        For a Distributed Map that includes child workflows of type <code>EXPRESS</code>,
         *        <code>redriveStatusReason</code> is only returned if the child workflows are not redrivable. This
         *        happens when the child workflow executions have completed successfully.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redriveStatusReason(String redriveStatusReason);
    }

    static final class BuilderImpl extends SfnResponse.BuilderImpl implements Builder {
        private String executionArn;

        private String stateMachineArn;

        private String name;

        private String status;

        private Instant startDate;

        private Instant stopDate;

        private String input;

        private CloudWatchEventsExecutionDataDetails inputDetails;

        private String output;

        private CloudWatchEventsExecutionDataDetails outputDetails;

        private String traceHeader;

        private String mapRunArn;

        private String error;

        private String causeValue;

        private String stateMachineVersionArn;

        private String stateMachineAliasArn;

        private Integer redriveCount;

        private Instant redriveDate;

        private String redriveStatus;

        private String redriveStatusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExecutionResponse model) {
            super(model);
            executionArn(model.executionArn);
            stateMachineArn(model.stateMachineArn);
            name(model.name);
            status(model.status);
            startDate(model.startDate);
            stopDate(model.stopDate);
            input(model.input);
            inputDetails(model.inputDetails);
            output(model.output);
            outputDetails(model.outputDetails);
            traceHeader(model.traceHeader);
            mapRunArn(model.mapRunArn);
            error(model.error);
            cause(model.causeValue);
            stateMachineVersionArn(model.stateMachineVersionArn);
            stateMachineAliasArn(model.stateMachineAliasArn);
            redriveCount(model.redriveCount);
            redriveDate(model.redriveDate);
            redriveStatus(model.redriveStatus);
            redriveStatusReason(model.redriveStatusReason);
        }

        public final String getExecutionArn() {
            return executionArn;
        }

        public final void setExecutionArn(String executionArn) {
            this.executionArn = executionArn;
        }

        @Override
        public final Builder executionArn(String executionArn) {
            this.executionArn = executionArn;
            return this;
        }

        public final String getStateMachineArn() {
            return stateMachineArn;
        }

        public final void setStateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
        }

        @Override
        public final Builder stateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartDate() {
            return startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final Instant getStopDate() {
            return stopDate;
        }

        public final void setStopDate(Instant stopDate) {
            this.stopDate = stopDate;
        }

        @Override
        public final Builder stopDate(Instant stopDate) {
            this.stopDate = stopDate;
            return this;
        }

        public final String getInput() {
            return input;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final CloudWatchEventsExecutionDataDetails.Builder getInputDetails() {
            return inputDetails != null ? inputDetails.toBuilder() : null;
        }

        public final void setInputDetails(CloudWatchEventsExecutionDataDetails.BuilderImpl inputDetails) {
            this.inputDetails = inputDetails != null ? inputDetails.build() : null;
        }

        @Override
        public final Builder inputDetails(CloudWatchEventsExecutionDataDetails inputDetails) {
            this.inputDetails = inputDetails;
            return this;
        }

        public final String getOutput() {
            return output;
        }

        public final void setOutput(String output) {
            this.output = output;
        }

        @Override
        public final Builder output(String output) {
            this.output = output;
            return this;
        }

        public final CloudWatchEventsExecutionDataDetails.Builder getOutputDetails() {
            return outputDetails != null ? outputDetails.toBuilder() : null;
        }

        public final void setOutputDetails(CloudWatchEventsExecutionDataDetails.BuilderImpl outputDetails) {
            this.outputDetails = outputDetails != null ? outputDetails.build() : null;
        }

        @Override
        public final Builder outputDetails(CloudWatchEventsExecutionDataDetails outputDetails) {
            this.outputDetails = outputDetails;
            return this;
        }

        public final String getTraceHeader() {
            return traceHeader;
        }

        public final void setTraceHeader(String traceHeader) {
            this.traceHeader = traceHeader;
        }

        @Override
        public final Builder traceHeader(String traceHeader) {
            this.traceHeader = traceHeader;
            return this;
        }

        public final String getMapRunArn() {
            return mapRunArn;
        }

        public final void setMapRunArn(String mapRunArn) {
            this.mapRunArn = mapRunArn;
        }

        @Override
        public final Builder mapRunArn(String mapRunArn) {
            this.mapRunArn = mapRunArn;
            return this;
        }

        public final String getError() {
            return error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final String getCause() {
            return causeValue;
        }

        public final void setCause(String causeValue) {
            this.causeValue = causeValue;
        }

        @Override
        public final Builder cause(String causeValue) {
            this.causeValue = causeValue;
            return this;
        }

        public final String getStateMachineVersionArn() {
            return stateMachineVersionArn;
        }

        public final void setStateMachineVersionArn(String stateMachineVersionArn) {
            this.stateMachineVersionArn = stateMachineVersionArn;
        }

        @Override
        public final Builder stateMachineVersionArn(String stateMachineVersionArn) {
            this.stateMachineVersionArn = stateMachineVersionArn;
            return this;
        }

        public final String getStateMachineAliasArn() {
            return stateMachineAliasArn;
        }

        public final void setStateMachineAliasArn(String stateMachineAliasArn) {
            this.stateMachineAliasArn = stateMachineAliasArn;
        }

        @Override
        public final Builder stateMachineAliasArn(String stateMachineAliasArn) {
            this.stateMachineAliasArn = stateMachineAliasArn;
            return this;
        }

        public final Integer getRedriveCount() {
            return redriveCount;
        }

        public final void setRedriveCount(Integer redriveCount) {
            this.redriveCount = redriveCount;
        }

        @Override
        public final Builder redriveCount(Integer redriveCount) {
            this.redriveCount = redriveCount;
            return this;
        }

        public final Instant getRedriveDate() {
            return redriveDate;
        }

        public final void setRedriveDate(Instant redriveDate) {
            this.redriveDate = redriveDate;
        }

        @Override
        public final Builder redriveDate(Instant redriveDate) {
            this.redriveDate = redriveDate;
            return this;
        }

        public final String getRedriveStatus() {
            return redriveStatus;
        }

        public final void setRedriveStatus(String redriveStatus) {
            this.redriveStatus = redriveStatus;
        }

        @Override
        public final Builder redriveStatus(String redriveStatus) {
            this.redriveStatus = redriveStatus;
            return this;
        }

        @Override
        public final Builder redriveStatus(ExecutionRedriveStatus redriveStatus) {
            this.redriveStatus(redriveStatus == null ? null : redriveStatus.toString());
            return this;
        }

        public final String getRedriveStatusReason() {
            return redriveStatusReason;
        }

        public final void setRedriveStatusReason(String redriveStatusReason) {
            this.redriveStatusReason = redriveStatusReason;
        }

        @Override
        public final Builder redriveStatusReason(String redriveStatusReason) {
            this.redriveStatusReason = redriveStatusReason;
            return this;
        }

        @Override
        public DescribeExecutionResponse build() {
            return new DescribeExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
