/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains additional details about the state's execution, including its input and output data processing flow, and
 * HTTP response information. The <code>inspectionLevel</code> request parameter specifies which details are returned.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InspectionDataResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<InspectionDataResponse.Builder, InspectionDataResponse> {
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("protocol").getter(getter(InspectionDataResponse::protocol)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()).build();

    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusCode").getter(getter(InspectionDataResponse::statusCode)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCode").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(InspectionDataResponse::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<String> HEADERS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("headers")
            .getter(getter(InspectionDataResponse::headers)).setter(setter(Builder::headers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headers").build()).build();

    private static final SdkField<String> BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("body")
            .getter(getter(InspectionDataResponse::body)).setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTOCOL_FIELD,
            STATUS_CODE_FIELD, STATUS_MESSAGE_FIELD, HEADERS_FIELD, BODY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("protocol", PROTOCOL_FIELD);
                    put("statusCode", STATUS_CODE_FIELD);
                    put("statusMessage", STATUS_MESSAGE_FIELD);
                    put("headers", HEADERS_FIELD);
                    put("body", BODY_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String protocol;

    private final String statusCodeValue;

    private final String statusMessage;

    private final String headers;

    private final String body;

    private InspectionDataResponse(BuilderImpl builder) {
        this.protocol = builder.protocol;
        this.statusCodeValue = builder.statusCodeValue;
        this.statusMessage = builder.statusMessage;
        this.headers = builder.headers;
        this.body = builder.body;
    }

    /**
     * <p>
     * The protocol used to return the HTTP response.
     * </p>
     * 
     * @return The protocol used to return the HTTP response.
     */
    public final String protocol() {
        return protocol;
    }

    /**
     * <p>
     * The HTTP response status code for the HTTP response.
     * </p>
     * 
     * @return The HTTP response status code for the HTTP response.
     */
    public final String statusCode() {
        return statusCodeValue;
    }

    /**
     * <p>
     * The message associated with the HTTP status code.
     * </p>
     * 
     * @return The message associated with the HTTP status code.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The response headers associated with the HTTP response.
     * </p>
     * 
     * @return The response headers associated with the HTTP response.
     */
    public final String headers() {
        return headers;
    }

    /**
     * <p>
     * The HTTP response returned.
     * </p>
     * 
     * @return The HTTP response returned.
     */
    public final String body() {
        return body;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        hashCode = 31 * hashCode + Objects.hashCode(statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(headers());
        hashCode = 31 * hashCode + Objects.hashCode(body());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InspectionDataResponse)) {
            return false;
        }
        InspectionDataResponse other = (InspectionDataResponse) obj;
        return Objects.equals(protocol(), other.protocol()) && Objects.equals(statusCode(), other.statusCode())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(headers(), other.headers())
                && Objects.equals(body(), other.body());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InspectionDataResponse").add("Protocol", protocol()).add("StatusCode", statusCode())
                .add("StatusMessage", statusMessage()).add("Headers", headers()).add("Body", body()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "protocol":
            return Optional.ofNullable(clazz.cast(protocol()));
        case "statusCode":
            return Optional.ofNullable(clazz.cast(statusCode()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "headers":
            return Optional.ofNullable(clazz.cast(headers()));
        case "body":
            return Optional.ofNullable(clazz.cast(body()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InspectionDataResponse, T> g) {
        return obj -> g.apply((InspectionDataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InspectionDataResponse> {
        /**
         * <p>
         * The protocol used to return the HTTP response.
         * </p>
         * 
         * @param protocol
         *        The protocol used to return the HTTP response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The HTTP response status code for the HTTP response.
         * </p>
         * 
         * @param statusCodeValue
         *        The HTTP response status code for the HTTP response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCode(String statusCodeValue);

        /**
         * <p>
         * The message associated with the HTTP status code.
         * </p>
         * 
         * @param statusMessage
         *        The message associated with the HTTP status code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The response headers associated with the HTTP response.
         * </p>
         * 
         * @param headers
         *        The response headers associated with the HTTP response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headers(String headers);

        /**
         * <p>
         * The HTTP response returned.
         * </p>
         * 
         * @param body
         *        The HTTP response returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(String body);
    }

    static final class BuilderImpl implements Builder {
        private String protocol;

        private String statusCodeValue;

        private String statusMessage;

        private String headers;

        private String body;

        private BuilderImpl() {
        }

        private BuilderImpl(InspectionDataResponse model) {
            protocol(model.protocol);
            statusCode(model.statusCodeValue);
            statusMessage(model.statusMessage);
            headers(model.headers);
            body(model.body);
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final String getStatusCode() {
            return statusCodeValue;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        @Override
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getHeaders() {
            return headers;
        }

        public final void setHeaders(String headers) {
            this.headers = headers;
        }

        @Override
        public final Builder headers(String headers) {
            this.headers = headers;
            return this;
        }

        public final String getBody() {
            return body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        @Override
        public InspectionDataResponse build() {
            return new InspectionDataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
