/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about items that were processed in all of the child workflow executions that were started by a Map
 * Run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MapRunItemCounts implements SdkPojo, Serializable,
        ToCopyableBuilder<MapRunItemCounts.Builder, MapRunItemCounts> {
    private static final SdkField<Long> PENDING_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("pending")
            .getter(getter(MapRunItemCounts::pending)).setter(setter(Builder::pending))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pending").build()).build();

    private static final SdkField<Long> RUNNING_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("running")
            .getter(getter(MapRunItemCounts::running)).setter(setter(Builder::running))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("running").build()).build();

    private static final SdkField<Long> SUCCEEDED_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("succeeded")
            .getter(getter(MapRunItemCounts::succeeded)).setter(setter(Builder::succeeded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("succeeded").build()).build();

    private static final SdkField<Long> FAILED_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("failed")
            .getter(getter(MapRunItemCounts::failed)).setter(setter(Builder::failed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failed").build()).build();

    private static final SdkField<Long> TIMED_OUT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("timedOut")
            .getter(getter(MapRunItemCounts::timedOut)).setter(setter(Builder::timedOut))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timedOut").build()).build();

    private static final SdkField<Long> ABORTED_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("aborted")
            .getter(getter(MapRunItemCounts::aborted)).setter(setter(Builder::aborted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aborted").build()).build();

    private static final SdkField<Long> TOTAL_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("total")
            .getter(getter(MapRunItemCounts::total)).setter(setter(Builder::total))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("total").build()).build();

    private static final SdkField<Long> RESULTS_WRITTEN_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("resultsWritten").getter(getter(MapRunItemCounts::resultsWritten))
            .setter(setter(Builder::resultsWritten))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resultsWritten").build()).build();

    private static final SdkField<Long> FAILURES_NOT_REDRIVABLE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("failuresNotRedrivable").getter(getter(MapRunItemCounts::failuresNotRedrivable))
            .setter(setter(Builder::failuresNotRedrivable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failuresNotRedrivable").build())
            .build();

    private static final SdkField<Long> PENDING_REDRIVE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("pendingRedrive").getter(getter(MapRunItemCounts::pendingRedrive))
            .setter(setter(Builder::pendingRedrive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingRedrive").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PENDING_FIELD, RUNNING_FIELD,
            SUCCEEDED_FIELD, FAILED_FIELD, TIMED_OUT_FIELD, ABORTED_FIELD, TOTAL_FIELD, RESULTS_WRITTEN_FIELD,
            FAILURES_NOT_REDRIVABLE_FIELD, PENDING_REDRIVE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("pending", PENDING_FIELD);
                    put("running", RUNNING_FIELD);
                    put("succeeded", SUCCEEDED_FIELD);
                    put("failed", FAILED_FIELD);
                    put("timedOut", TIMED_OUT_FIELD);
                    put("aborted", ABORTED_FIELD);
                    put("total", TOTAL_FIELD);
                    put("resultsWritten", RESULTS_WRITTEN_FIELD);
                    put("failuresNotRedrivable", FAILURES_NOT_REDRIVABLE_FIELD);
                    put("pendingRedrive", PENDING_REDRIVE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Long pending;

    private final Long running;

    private final Long succeeded;

    private final Long failed;

    private final Long timedOut;

    private final Long aborted;

    private final Long total;

    private final Long resultsWritten;

    private final Long failuresNotRedrivable;

    private final Long pendingRedrive;

    private MapRunItemCounts(BuilderImpl builder) {
        this.pending = builder.pending;
        this.running = builder.running;
        this.succeeded = builder.succeeded;
        this.failed = builder.failed;
        this.timedOut = builder.timedOut;
        this.aborted = builder.aborted;
        this.total = builder.total;
        this.resultsWritten = builder.resultsWritten;
        this.failuresNotRedrivable = builder.failuresNotRedrivable;
        this.pendingRedrive = builder.pendingRedrive;
    }

    /**
     * <p>
     * The total number of items to process in child workflow executions that haven't started running yet.
     * </p>
     * 
     * @return The total number of items to process in child workflow executions that haven't started running yet.
     */
    public final Long pending() {
        return pending;
    }

    /**
     * <p>
     * The total number of items being processed in child workflow executions that are currently in-progress.
     * </p>
     * 
     * @return The total number of items being processed in child workflow executions that are currently in-progress.
     */
    public final Long running() {
        return running;
    }

    /**
     * <p>
     * The total number of items processed in child workflow executions that have completed successfully.
     * </p>
     * 
     * @return The total number of items processed in child workflow executions that have completed successfully.
     */
    public final Long succeeded() {
        return succeeded;
    }

    /**
     * <p>
     * The total number of items processed in child workflow executions that have failed.
     * </p>
     * 
     * @return The total number of items processed in child workflow executions that have failed.
     */
    public final Long failed() {
        return failed;
    }

    /**
     * <p>
     * The total number of items processed in child workflow executions that have timed out.
     * </p>
     * 
     * @return The total number of items processed in child workflow executions that have timed out.
     */
    public final Long timedOut() {
        return timedOut;
    }

    /**
     * <p>
     * The total number of items processed in child workflow executions that were either stopped by the user or by Step
     * Functions, because the Map Run failed.
     * </p>
     * 
     * @return The total number of items processed in child workflow executions that were either stopped by the user or
     *         by Step Functions, because the Map Run failed.
     */
    public final Long aborted() {
        return aborted;
    }

    /**
     * <p>
     * The total number of items processed in all the child workflow executions started by a Map Run.
     * </p>
     * 
     * @return The total number of items processed in all the child workflow executions started by a Map Run.
     */
    public final Long total() {
        return total;
    }

    /**
     * <p>
     * Returns the count of items whose results were written by <code>ResultWriter</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-resultwriter.html">ResultWriter</a> in
     * the <i>Step Functions Developer Guide</i>.
     * </p>
     * 
     * @return Returns the count of items whose results were written by <code>ResultWriter</code>. For more information,
     *         see <a
     *         href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-resultwriter.html">ResultWriter
     *         </a> in the <i>Step Functions Developer Guide</i>.
     */
    public final Long resultsWritten() {
        return resultsWritten;
    }

    /**
     * <p>
     * The number of <code>FAILED</code>, <code>ABORTED</code>, or <code>TIMED_OUT</code> items in child workflow
     * executions that cannot be redriven because the execution status of those child workflows is terminal. For
     * example, child workflows with an execution status of <code>FAILED</code>, <code>ABORTED</code>, or
     * <code>TIMED_OUT</code> and a <code>redriveStatus</code> of <code>NOT_REDRIVABLE</code>.
     * </p>
     * 
     * @return The number of <code>FAILED</code>, <code>ABORTED</code>, or <code>TIMED_OUT</code> items in child
     *         workflow executions that cannot be redriven because the execution status of those child workflows is
     *         terminal. For example, child workflows with an execution status of <code>FAILED</code>,
     *         <code>ABORTED</code>, or <code>TIMED_OUT</code> and a <code>redriveStatus</code> of
     *         <code>NOT_REDRIVABLE</code>.
     */
    public final Long failuresNotRedrivable() {
        return failuresNotRedrivable;
    }

    /**
     * <p>
     * The number of unsuccessful items in child workflow executions currently waiting to be redriven.
     * </p>
     * 
     * @return The number of unsuccessful items in child workflow executions currently waiting to be redriven.
     */
    public final Long pendingRedrive() {
        return pendingRedrive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pending());
        hashCode = 31 * hashCode + Objects.hashCode(running());
        hashCode = 31 * hashCode + Objects.hashCode(succeeded());
        hashCode = 31 * hashCode + Objects.hashCode(failed());
        hashCode = 31 * hashCode + Objects.hashCode(timedOut());
        hashCode = 31 * hashCode + Objects.hashCode(aborted());
        hashCode = 31 * hashCode + Objects.hashCode(total());
        hashCode = 31 * hashCode + Objects.hashCode(resultsWritten());
        hashCode = 31 * hashCode + Objects.hashCode(failuresNotRedrivable());
        hashCode = 31 * hashCode + Objects.hashCode(pendingRedrive());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MapRunItemCounts)) {
            return false;
        }
        MapRunItemCounts other = (MapRunItemCounts) obj;
        return Objects.equals(pending(), other.pending()) && Objects.equals(running(), other.running())
                && Objects.equals(succeeded(), other.succeeded()) && Objects.equals(failed(), other.failed())
                && Objects.equals(timedOut(), other.timedOut()) && Objects.equals(aborted(), other.aborted())
                && Objects.equals(total(), other.total()) && Objects.equals(resultsWritten(), other.resultsWritten())
                && Objects.equals(failuresNotRedrivable(), other.failuresNotRedrivable())
                && Objects.equals(pendingRedrive(), other.pendingRedrive());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MapRunItemCounts").add("Pending", pending()).add("Running", running())
                .add("Succeeded", succeeded()).add("Failed", failed()).add("TimedOut", timedOut()).add("Aborted", aborted())
                .add("Total", total()).add("ResultsWritten", resultsWritten())
                .add("FailuresNotRedrivable", failuresNotRedrivable()).add("PendingRedrive", pendingRedrive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pending":
            return Optional.ofNullable(clazz.cast(pending()));
        case "running":
            return Optional.ofNullable(clazz.cast(running()));
        case "succeeded":
            return Optional.ofNullable(clazz.cast(succeeded()));
        case "failed":
            return Optional.ofNullable(clazz.cast(failed()));
        case "timedOut":
            return Optional.ofNullable(clazz.cast(timedOut()));
        case "aborted":
            return Optional.ofNullable(clazz.cast(aborted()));
        case "total":
            return Optional.ofNullable(clazz.cast(total()));
        case "resultsWritten":
            return Optional.ofNullable(clazz.cast(resultsWritten()));
        case "failuresNotRedrivable":
            return Optional.ofNullable(clazz.cast(failuresNotRedrivable()));
        case "pendingRedrive":
            return Optional.ofNullable(clazz.cast(pendingRedrive()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MapRunItemCounts, T> g) {
        return obj -> g.apply((MapRunItemCounts) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MapRunItemCounts> {
        /**
         * <p>
         * The total number of items to process in child workflow executions that haven't started running yet.
         * </p>
         * 
         * @param pending
         *        The total number of items to process in child workflow executions that haven't started running yet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pending(Long pending);

        /**
         * <p>
         * The total number of items being processed in child workflow executions that are currently in-progress.
         * </p>
         * 
         * @param running
         *        The total number of items being processed in child workflow executions that are currently in-progress.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder running(Long running);

        /**
         * <p>
         * The total number of items processed in child workflow executions that have completed successfully.
         * </p>
         * 
         * @param succeeded
         *        The total number of items processed in child workflow executions that have completed successfully.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder succeeded(Long succeeded);

        /**
         * <p>
         * The total number of items processed in child workflow executions that have failed.
         * </p>
         * 
         * @param failed
         *        The total number of items processed in child workflow executions that have failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(Long failed);

        /**
         * <p>
         * The total number of items processed in child workflow executions that have timed out.
         * </p>
         * 
         * @param timedOut
         *        The total number of items processed in child workflow executions that have timed out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timedOut(Long timedOut);

        /**
         * <p>
         * The total number of items processed in child workflow executions that were either stopped by the user or by
         * Step Functions, because the Map Run failed.
         * </p>
         * 
         * @param aborted
         *        The total number of items processed in child workflow executions that were either stopped by the user
         *        or by Step Functions, because the Map Run failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aborted(Long aborted);

        /**
         * <p>
         * The total number of items processed in all the child workflow executions started by a Map Run.
         * </p>
         * 
         * @param total
         *        The total number of items processed in all the child workflow executions started by a Map Run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder total(Long total);

        /**
         * <p>
         * Returns the count of items whose results were written by <code>ResultWriter</code>. For more information, see
         * <a
         * href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-resultwriter.html">ResultWriter</a>
         * in the <i>Step Functions Developer Guide</i>.
         * </p>
         * 
         * @param resultsWritten
         *        Returns the count of items whose results were written by <code>ResultWriter</code>. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-resultwriter.html"
         *        >ResultWriter</a> in the <i>Step Functions Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultsWritten(Long resultsWritten);

        /**
         * <p>
         * The number of <code>FAILED</code>, <code>ABORTED</code>, or <code>TIMED_OUT</code> items in child workflow
         * executions that cannot be redriven because the execution status of those child workflows is terminal. For
         * example, child workflows with an execution status of <code>FAILED</code>, <code>ABORTED</code>, or
         * <code>TIMED_OUT</code> and a <code>redriveStatus</code> of <code>NOT_REDRIVABLE</code>.
         * </p>
         * 
         * @param failuresNotRedrivable
         *        The number of <code>FAILED</code>, <code>ABORTED</code>, or <code>TIMED_OUT</code> items in child
         *        workflow executions that cannot be redriven because the execution status of those child workflows is
         *        terminal. For example, child workflows with an execution status of <code>FAILED</code>,
         *        <code>ABORTED</code>, or <code>TIMED_OUT</code> and a <code>redriveStatus</code> of
         *        <code>NOT_REDRIVABLE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failuresNotRedrivable(Long failuresNotRedrivable);

        /**
         * <p>
         * The number of unsuccessful items in child workflow executions currently waiting to be redriven.
         * </p>
         * 
         * @param pendingRedrive
         *        The number of unsuccessful items in child workflow executions currently waiting to be redriven.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingRedrive(Long pendingRedrive);
    }

    static final class BuilderImpl implements Builder {
        private Long pending;

        private Long running;

        private Long succeeded;

        private Long failed;

        private Long timedOut;

        private Long aborted;

        private Long total;

        private Long resultsWritten;

        private Long failuresNotRedrivable;

        private Long pendingRedrive;

        private BuilderImpl() {
        }

        private BuilderImpl(MapRunItemCounts model) {
            pending(model.pending);
            running(model.running);
            succeeded(model.succeeded);
            failed(model.failed);
            timedOut(model.timedOut);
            aborted(model.aborted);
            total(model.total);
            resultsWritten(model.resultsWritten);
            failuresNotRedrivable(model.failuresNotRedrivable);
            pendingRedrive(model.pendingRedrive);
        }

        public final Long getPending() {
            return pending;
        }

        public final void setPending(Long pending) {
            this.pending = pending;
        }

        @Override
        public final Builder pending(Long pending) {
            this.pending = pending;
            return this;
        }

        public final Long getRunning() {
            return running;
        }

        public final void setRunning(Long running) {
            this.running = running;
        }

        @Override
        public final Builder running(Long running) {
            this.running = running;
            return this;
        }

        public final Long getSucceeded() {
            return succeeded;
        }

        public final void setSucceeded(Long succeeded) {
            this.succeeded = succeeded;
        }

        @Override
        public final Builder succeeded(Long succeeded) {
            this.succeeded = succeeded;
            return this;
        }

        public final Long getFailed() {
            return failed;
        }

        public final void setFailed(Long failed) {
            this.failed = failed;
        }

        @Override
        public final Builder failed(Long failed) {
            this.failed = failed;
            return this;
        }

        public final Long getTimedOut() {
            return timedOut;
        }

        public final void setTimedOut(Long timedOut) {
            this.timedOut = timedOut;
        }

        @Override
        public final Builder timedOut(Long timedOut) {
            this.timedOut = timedOut;
            return this;
        }

        public final Long getAborted() {
            return aborted;
        }

        public final void setAborted(Long aborted) {
            this.aborted = aborted;
        }

        @Override
        public final Builder aborted(Long aborted) {
            this.aborted = aborted;
            return this;
        }

        public final Long getTotal() {
            return total;
        }

        public final void setTotal(Long total) {
            this.total = total;
        }

        @Override
        public final Builder total(Long total) {
            this.total = total;
            return this;
        }

        public final Long getResultsWritten() {
            return resultsWritten;
        }

        public final void setResultsWritten(Long resultsWritten) {
            this.resultsWritten = resultsWritten;
        }

        @Override
        public final Builder resultsWritten(Long resultsWritten) {
            this.resultsWritten = resultsWritten;
            return this;
        }

        public final Long getFailuresNotRedrivable() {
            return failuresNotRedrivable;
        }

        public final void setFailuresNotRedrivable(Long failuresNotRedrivable) {
            this.failuresNotRedrivable = failuresNotRedrivable;
        }

        @Override
        public final Builder failuresNotRedrivable(Long failuresNotRedrivable) {
            this.failuresNotRedrivable = failuresNotRedrivable;
            return this;
        }

        public final Long getPendingRedrive() {
            return pendingRedrive;
        }

        public final void setPendingRedrive(Long pendingRedrive) {
            this.pendingRedrive = pendingRedrive;
        }

        @Override
        public final Builder pendingRedrive(Long pendingRedrive) {
            this.pendingRedrive = pendingRedrive;
            return this;
        }

        @Override
        public MapRunItemCounts build() {
            return new MapRunItemCounts(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
