/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sns.model.SMSSandboxPhoneNumberVerificationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SMSSandboxPhoneNumber
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SMSSandboxPhoneNumber> {
    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhoneNumber").getter(SMSSandboxPhoneNumber.getter(SMSSandboxPhoneNumber::phoneNumber)).setter(SMSSandboxPhoneNumber.setter(Builder::phoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(SMSSandboxPhoneNumber.getter(SMSSandboxPhoneNumber::statusAsString)).setter(SMSSandboxPhoneNumber.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String phoneNumber;
    private final String status;

    private SMSSandboxPhoneNumber(BuilderImpl builder) {
        this.phoneNumber = builder.phoneNumber;
        this.status = builder.status;
    }

    public final String phoneNumber() {
        return this.phoneNumber;
    }

    public final SMSSandboxPhoneNumberVerificationStatus status() {
        return SMSSandboxPhoneNumberVerificationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SMSSandboxPhoneNumber)) {
            return false;
        }
        SMSSandboxPhoneNumber other = (SMSSandboxPhoneNumber)obj;
        return Objects.equals(this.phoneNumber(), other.phoneNumber()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SMSSandboxPhoneNumber").add("PhoneNumber", (Object)(this.phoneNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.phoneNumber()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SMSSandboxPhoneNumber, T> g) {
        return obj -> g.apply((SMSSandboxPhoneNumber)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String phoneNumber;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(SMSSandboxPhoneNumber model) {
            this.phoneNumber(model.phoneNumber);
            this.status(model.status);
        }

        public final String getPhoneNumber() {
            return this.phoneNumber;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SMSSandboxPhoneNumberVerificationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public SMSSandboxPhoneNumber build() {
            return new SMSSandboxPhoneNumber(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SMSSandboxPhoneNumber> {
        public Builder phoneNumber(String var1);

        public Builder status(String var1);

        public Builder status(SMSSandboxPhoneNumberVerificationStatus var1);
    }
}

