/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.NodeSummaryListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListNodesSummaryResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, ListNodesSummaryResponse> {
    private static final SdkField<List<Map<String, String>>> SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Summary").getter(ListNodesSummaryResponse.getter(ListNodesSummaryResponse::summary)).setter(ListNodesSummaryResponse.setter(Builder::summary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Summary").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListNodesSummaryResponse.getter(ListNodesSummaryResponse::nextToken)).setter(ListNodesSummaryResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARY_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Summary", SUMMARY_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<Map<String, String>> summary;
    private final String nextToken;

    private ListNodesSummaryResponse(BuilderImpl builder) {
        super(builder);
        this.summary = builder.summary;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSummary() {
        return this.summary != null && !(this.summary instanceof SdkAutoConstructList);
    }

    public final List<Map<String, String>> summary() {
        return this.summary;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSummary() ? this.summary() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNodesSummaryResponse)) {
            return false;
        }
        ListNodesSummaryResponse other = (ListNodesSummaryResponse)((Object)obj);
        return this.hasSummary() == other.hasSummary() && Objects.equals(this.summary(), other.summary()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListNodesSummaryResponse").add("Summary", this.hasSummary() ? this.summary() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Summary": {
                return Optional.ofNullable(clazz.cast(this.summary()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListNodesSummaryResponse, T> g) {
        return obj -> g.apply((ListNodesSummaryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<Map<String, String>> summary = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNodesSummaryResponse model) {
            super(model);
            this.summary(model.summary);
            this.nextToken(model.nextToken);
        }

        public final Collection<? extends Map<String, String>> getSummary() {
            if (this.summary instanceof SdkAutoConstructList) {
                return null;
            }
            return this.summary;
        }

        public final void setSummary(Collection<? extends Map<String, String>> summary) {
            this.summary = NodeSummaryListCopier.copy(summary);
        }

        @Override
        public final Builder summary(Collection<? extends Map<String, String>> summary) {
            this.summary = NodeSummaryListCopier.copy(summary);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summary(Map<String, String> ... summary) {
            this.summary(Arrays.asList(summary));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListNodesSummaryResponse build() {
            return new ListNodesSummaryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListNodesSummaryResponse> {
        public Builder summary(Collection<? extends Map<String, String>> var1);

        public Builder summary(Map<String, String> ... var1);

        public Builder nextToken(String var1);
    }
}

