/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NodeOwnerInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NodeOwnerInfo> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(NodeOwnerInfo.getter(NodeOwnerInfo::accountId)).setter(NodeOwnerInfo.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> ORGANIZATIONAL_UNIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationalUnitId").getter(NodeOwnerInfo.getter(NodeOwnerInfo::organizationalUnitId)).setter(NodeOwnerInfo.setter(Builder::organizationalUnitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnitId").build()}).build();
    private static final SdkField<String> ORGANIZATIONAL_UNIT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationalUnitPath").getter(NodeOwnerInfo.getter(NodeOwnerInfo::organizationalUnitPath)).setter(NodeOwnerInfo.setter(Builder::organizationalUnitPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnitPath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, ORGANIZATIONAL_UNIT_ID_FIELD, ORGANIZATIONAL_UNIT_PATH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AccountId", ACCOUNT_ID_FIELD);
            this.put("OrganizationalUnitId", ORGANIZATIONAL_UNIT_ID_FIELD);
            this.put("OrganizationalUnitPath", ORGANIZATIONAL_UNIT_PATH_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String organizationalUnitId;
    private final String organizationalUnitPath;

    private NodeOwnerInfo(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.organizationalUnitId = builder.organizationalUnitId;
        this.organizationalUnitPath = builder.organizationalUnitPath;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String organizationalUnitId() {
        return this.organizationalUnitId;
    }

    public final String organizationalUnitPath() {
        return this.organizationalUnitPath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationalUnitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationalUnitPath());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeOwnerInfo)) {
            return false;
        }
        NodeOwnerInfo other = (NodeOwnerInfo)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.organizationalUnitId(), other.organizationalUnitId()) && Objects.equals(this.organizationalUnitPath(), other.organizationalUnitPath());
    }

    public final String toString() {
        return ToString.builder((String)"NodeOwnerInfo").add("AccountId", (Object)this.accountId()).add("OrganizationalUnitId", (Object)this.organizationalUnitId()).add("OrganizationalUnitPath", (Object)this.organizationalUnitPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "OrganizationalUnitId": {
                return Optional.ofNullable(clazz.cast(this.organizationalUnitId()));
            }
            case "OrganizationalUnitPath": {
                return Optional.ofNullable(clazz.cast(this.organizationalUnitPath()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<NodeOwnerInfo, T> g) {
        return obj -> g.apply((NodeOwnerInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String organizationalUnitId;
        private String organizationalUnitPath;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeOwnerInfo model) {
            this.accountId(model.accountId);
            this.organizationalUnitId(model.organizationalUnitId);
            this.organizationalUnitPath(model.organizationalUnitPath);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getOrganizationalUnitId() {
            return this.organizationalUnitId;
        }

        public final void setOrganizationalUnitId(String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
        }

        @Override
        public final Builder organizationalUnitId(String organizationalUnitId) {
            this.organizationalUnitId = organizationalUnitId;
            return this;
        }

        public final String getOrganizationalUnitPath() {
            return this.organizationalUnitPath;
        }

        public final void setOrganizationalUnitPath(String organizationalUnitPath) {
            this.organizationalUnitPath = organizationalUnitPath;
        }

        @Override
        public final Builder organizationalUnitPath(String organizationalUnitPath) {
            this.organizationalUnitPath = organizationalUnitPath;
            return this;
        }

        public NodeOwnerInfo build() {
            return new NodeOwnerInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NodeOwnerInfo> {
        public Builder accountId(String var1);

        public Builder organizationalUnitId(String var1);

        public Builder organizationalUnitPath(String var1);
    }
}

