/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ItemType {
    ANALYSIS("ANALYSIS"),
    INCIDENT("INCIDENT"),
    METRIC("METRIC"),
    PARENT("PARENT"),
    ATTACHMENT("ATTACHMENT"),
    OTHER("OTHER"),
    AUTOMATION("AUTOMATION"),
    INVOLVED_RESOURCE("INVOLVED_RESOURCE"),
    TASK("TASK"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ItemType> VALUE_MAP;
    private final String value;

    private ItemType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ItemType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ItemType> knownValues() {
        EnumSet<ItemType> knownValues = EnumSet.allOf(ItemType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ItemType.class, ItemType::toString);
    }
}

