/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmincidents.SsmIncidentsAsyncClient;
import software.amazon.awssdk.services.ssmincidents.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssmincidents.model.FindingSummary;
import software.amazon.awssdk.services.ssmincidents.model.ListIncidentFindingsRequest;
import software.amazon.awssdk.services.ssmincidents.model.ListIncidentFindingsResponse;

public class ListIncidentFindingsPublisher
implements SdkPublisher<ListIncidentFindingsResponse> {
    private final SsmIncidentsAsyncClient client;
    private final ListIncidentFindingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListIncidentFindingsPublisher(SsmIncidentsAsyncClient client, ListIncidentFindingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListIncidentFindingsPublisher(SsmIncidentsAsyncClient client, ListIncidentFindingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListIncidentFindingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListIncidentFindingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FindingSummary> findings() {
        Function<ListIncidentFindingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.findings() != null) {
                return response.findings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListIncidentFindingsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListIncidentFindingsResponseFetcher
    implements AsyncPageFetcher<ListIncidentFindingsResponse> {
        private ListIncidentFindingsResponseFetcher() {
        }

        public boolean hasNextPage(ListIncidentFindingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListIncidentFindingsResponse> nextPage(ListIncidentFindingsResponse previousPage) {
            if (previousPage == null) {
                return ListIncidentFindingsPublisher.this.client.listIncidentFindings(ListIncidentFindingsPublisher.this.firstRequest);
            }
            return ListIncidentFindingsPublisher.this.client.listIncidentFindings((ListIncidentFindingsRequest)((Object)ListIncidentFindingsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

