/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.ChapCredentialsCopier;
import software.amazon.awssdk.services.storagegateway.model.ChapInfo;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeChapCredentialsResponse
extends StorageGatewayResponse
implements ToCopyableBuilder<Builder, DescribeChapCredentialsResponse> {
    private static final SdkField<List<ChapInfo>> CHAP_CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeChapCredentialsResponse.getter(DescribeChapCredentialsResponse::chapCredentials)).setter(DescribeChapCredentialsResponse.setter(Builder::chapCredentials)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChapCredentials").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChapInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHAP_CREDENTIALS_FIELD));
    private final List<ChapInfo> chapCredentials;

    private DescribeChapCredentialsResponse(BuilderImpl builder) {
        super(builder);
        this.chapCredentials = builder.chapCredentials;
    }

    public boolean hasChapCredentials() {
        return this.chapCredentials != null && !(this.chapCredentials instanceof SdkAutoConstructList);
    }

    public List<ChapInfo> chapCredentials() {
        return this.chapCredentials;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.chapCredentials());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeChapCredentialsResponse)) {
            return false;
        }
        DescribeChapCredentialsResponse other = (DescribeChapCredentialsResponse)((Object)obj);
        return Objects.equals(this.chapCredentials(), other.chapCredentials());
    }

    public String toString() {
        return ToString.builder((String)"DescribeChapCredentialsResponse").add("ChapCredentials", this.chapCredentials()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChapCredentials": {
                return Optional.ofNullable(clazz.cast(this.chapCredentials()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeChapCredentialsResponse, T> g) {
        return obj -> g.apply((DescribeChapCredentialsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayResponse.BuilderImpl
    implements Builder {
        private List<ChapInfo> chapCredentials = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeChapCredentialsResponse model) {
            super(model);
            this.chapCredentials(model.chapCredentials);
        }

        public final Collection<ChapInfo.Builder> getChapCredentials() {
            return this.chapCredentials != null ? (Collection)this.chapCredentials.stream().map(ChapInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder chapCredentials(Collection<ChapInfo> chapCredentials) {
            this.chapCredentials = ChapCredentialsCopier.copy(chapCredentials);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder chapCredentials(ChapInfo ... chapCredentials) {
            this.chapCredentials(Arrays.asList(chapCredentials));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder chapCredentials(Consumer<ChapInfo.Builder> ... chapCredentials) {
            this.chapCredentials(Stream.of(chapCredentials).map(c -> (ChapInfo)((ChapInfo.Builder)ChapInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setChapCredentials(Collection<ChapInfo.BuilderImpl> chapCredentials) {
            this.chapCredentials = ChapCredentialsCopier.copyFromBuilder(chapCredentials);
        }

        @Override
        public DescribeChapCredentialsResponse build() {
            return new DescribeChapCredentialsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeChapCredentialsResponse> {
        public Builder chapCredentials(Collection<ChapInfo> var1);

        public Builder chapCredentials(ChapInfo ... var1);

        public Builder chapCredentials(Consumer<ChapInfo.Builder> ... var1);
    }
}

