/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.storagegateway.model.ActiveDirectoryStatus;
import software.amazon.awssdk.services.storagegateway.model.SMBSecurityStrategy;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSmbSettingsResponse
extends StorageGatewayResponse
implements ToCopyableBuilder<Builder, DescribeSmbSettingsResponse> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeSmbSettingsResponse.getter(DescribeSmbSettingsResponse::gatewayARN)).setter(DescribeSmbSettingsResponse.setter(Builder::gatewayARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeSmbSettingsResponse.getter(DescribeSmbSettingsResponse::domainName)).setter(DescribeSmbSettingsResponse.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> ACTIVE_DIRECTORY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeSmbSettingsResponse.getter(DescribeSmbSettingsResponse::activeDirectoryStatusAsString)).setter(DescribeSmbSettingsResponse.setter(Builder::activeDirectoryStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDirectoryStatus").build()}).build();
    private static final SdkField<Boolean> SMB_GUEST_PASSWORD_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DescribeSmbSettingsResponse.getter(DescribeSmbSettingsResponse::smbGuestPasswordSet)).setter(DescribeSmbSettingsResponse.setter(Builder::smbGuestPasswordSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMBGuestPasswordSet").build()}).build();
    private static final SdkField<String> SMB_SECURITY_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeSmbSettingsResponse.getter(DescribeSmbSettingsResponse::smbSecurityStrategyAsString)).setter(DescribeSmbSettingsResponse.setter(Builder::smbSecurityStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMBSecurityStrategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD, DOMAIN_NAME_FIELD, ACTIVE_DIRECTORY_STATUS_FIELD, SMB_GUEST_PASSWORD_SET_FIELD, SMB_SECURITY_STRATEGY_FIELD));
    private final String gatewayARN;
    private final String domainName;
    private final String activeDirectoryStatus;
    private final Boolean smbGuestPasswordSet;
    private final String smbSecurityStrategy;

    private DescribeSmbSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.domainName = builder.domainName;
        this.activeDirectoryStatus = builder.activeDirectoryStatus;
        this.smbGuestPasswordSet = builder.smbGuestPasswordSet;
        this.smbSecurityStrategy = builder.smbSecurityStrategy;
    }

    public String gatewayARN() {
        return this.gatewayARN;
    }

    public String domainName() {
        return this.domainName;
    }

    public ActiveDirectoryStatus activeDirectoryStatus() {
        return ActiveDirectoryStatus.fromValue(this.activeDirectoryStatus);
    }

    public String activeDirectoryStatusAsString() {
        return this.activeDirectoryStatus;
    }

    public Boolean smbGuestPasswordSet() {
        return this.smbGuestPasswordSet;
    }

    public SMBSecurityStrategy smbSecurityStrategy() {
        return SMBSecurityStrategy.fromValue(this.smbSecurityStrategy);
    }

    public String smbSecurityStrategyAsString() {
        return this.smbSecurityStrategy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeDirectoryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.smbGuestPasswordSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.smbSecurityStrategyAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSmbSettingsResponse)) {
            return false;
        }
        DescribeSmbSettingsResponse other = (DescribeSmbSettingsResponse)((Object)obj);
        return Objects.equals(this.gatewayARN(), other.gatewayARN()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.activeDirectoryStatusAsString(), other.activeDirectoryStatusAsString()) && Objects.equals(this.smbGuestPasswordSet(), other.smbGuestPasswordSet()) && Objects.equals(this.smbSecurityStrategyAsString(), other.smbSecurityStrategyAsString());
    }

    public String toString() {
        return ToString.builder((String)"DescribeSmbSettingsResponse").add("GatewayARN", (Object)this.gatewayARN()).add("DomainName", (Object)this.domainName()).add("ActiveDirectoryStatus", (Object)this.activeDirectoryStatusAsString()).add("SMBGuestPasswordSet", (Object)this.smbGuestPasswordSet()).add("SMBSecurityStrategy", (Object)this.smbSecurityStrategyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayARN": {
                return Optional.ofNullable(clazz.cast(this.gatewayARN()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "ActiveDirectoryStatus": {
                return Optional.ofNullable(clazz.cast(this.activeDirectoryStatusAsString()));
            }
            case "SMBGuestPasswordSet": {
                return Optional.ofNullable(clazz.cast(this.smbGuestPasswordSet()));
            }
            case "SMBSecurityStrategy": {
                return Optional.ofNullable(clazz.cast(this.smbSecurityStrategyAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSmbSettingsResponse, T> g) {
        return obj -> g.apply((DescribeSmbSettingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayResponse.BuilderImpl
    implements Builder {
        private String gatewayARN;
        private String domainName;
        private String activeDirectoryStatus;
        private Boolean smbGuestPasswordSet;
        private String smbSecurityStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSmbSettingsResponse model) {
            super(model);
            this.gatewayARN(model.gatewayARN);
            this.domainName(model.domainName);
            this.activeDirectoryStatus(model.activeDirectoryStatus);
            this.smbGuestPasswordSet(model.smbGuestPasswordSet);
            this.smbSecurityStrategy(model.smbSecurityStrategy);
        }

        public final String getGatewayARN() {
            return this.gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getActiveDirectoryStatusAsString() {
            return this.activeDirectoryStatus;
        }

        @Override
        public final Builder activeDirectoryStatus(String activeDirectoryStatus) {
            this.activeDirectoryStatus = activeDirectoryStatus;
            return this;
        }

        @Override
        public final Builder activeDirectoryStatus(ActiveDirectoryStatus activeDirectoryStatus) {
            this.activeDirectoryStatus(activeDirectoryStatus == null ? null : activeDirectoryStatus.toString());
            return this;
        }

        public final void setActiveDirectoryStatus(String activeDirectoryStatus) {
            this.activeDirectoryStatus = activeDirectoryStatus;
        }

        public final Boolean getSmbGuestPasswordSet() {
            return this.smbGuestPasswordSet;
        }

        @Override
        public final Builder smbGuestPasswordSet(Boolean smbGuestPasswordSet) {
            this.smbGuestPasswordSet = smbGuestPasswordSet;
            return this;
        }

        public final void setSmbGuestPasswordSet(Boolean smbGuestPasswordSet) {
            this.smbGuestPasswordSet = smbGuestPasswordSet;
        }

        public final String getSmbSecurityStrategyAsString() {
            return this.smbSecurityStrategy;
        }

        @Override
        public final Builder smbSecurityStrategy(String smbSecurityStrategy) {
            this.smbSecurityStrategy = smbSecurityStrategy;
            return this;
        }

        @Override
        public final Builder smbSecurityStrategy(SMBSecurityStrategy smbSecurityStrategy) {
            this.smbSecurityStrategy(smbSecurityStrategy == null ? null : smbSecurityStrategy.toString());
            return this;
        }

        public final void setSmbSecurityStrategy(String smbSecurityStrategy) {
            this.smbSecurityStrategy = smbSecurityStrategy;
        }

        @Override
        public DescribeSmbSettingsResponse build() {
            return new DescribeSmbSettingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSmbSettingsResponse> {
        public Builder gatewayARN(String var1);

        public Builder domainName(String var1);

        public Builder activeDirectoryStatus(String var1);

        public Builder activeDirectoryStatus(ActiveDirectoryStatus var1);

        public Builder smbGuestPasswordSet(Boolean var1);

        public Builder smbSecurityStrategy(String var1);

        public Builder smbSecurityStrategy(SMBSecurityStrategy var1);
    }
}

