/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayResponse;
import software.amazon.awssdk.services.storagegateway.model.TapeRecoveryPointInfo;
import software.amazon.awssdk.services.storagegateway.model.TapeRecoveryPointInfosCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTapeRecoveryPointsResponse
extends StorageGatewayResponse
implements ToCopyableBuilder<Builder, DescribeTapeRecoveryPointsResponse> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTapeRecoveryPointsResponse.getter(DescribeTapeRecoveryPointsResponse::gatewayARN)).setter(DescribeTapeRecoveryPointsResponse.setter(Builder::gatewayARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()}).build();
    private static final SdkField<List<TapeRecoveryPointInfo>> TAPE_RECOVERY_POINT_INFOS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeTapeRecoveryPointsResponse.getter(DescribeTapeRecoveryPointsResponse::tapeRecoveryPointInfos)).setter(DescribeTapeRecoveryPointsResponse.setter(Builder::tapeRecoveryPointInfos)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeRecoveryPointInfos").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TapeRecoveryPointInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTapeRecoveryPointsResponse.getter(DescribeTapeRecoveryPointsResponse::marker)).setter(DescribeTapeRecoveryPointsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD, TAPE_RECOVERY_POINT_INFOS_FIELD, MARKER_FIELD));
    private final String gatewayARN;
    private final List<TapeRecoveryPointInfo> tapeRecoveryPointInfos;
    private final String marker;

    private DescribeTapeRecoveryPointsResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.tapeRecoveryPointInfos = builder.tapeRecoveryPointInfos;
        this.marker = builder.marker;
    }

    public String gatewayARN() {
        return this.gatewayARN;
    }

    public boolean hasTapeRecoveryPointInfos() {
        return this.tapeRecoveryPointInfos != null && !(this.tapeRecoveryPointInfos instanceof SdkAutoConstructList);
    }

    public List<TapeRecoveryPointInfo> tapeRecoveryPointInfos() {
        return this.tapeRecoveryPointInfos;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.tapeRecoveryPointInfos());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTapeRecoveryPointsResponse)) {
            return false;
        }
        DescribeTapeRecoveryPointsResponse other = (DescribeTapeRecoveryPointsResponse)((Object)obj);
        return Objects.equals(this.gatewayARN(), other.gatewayARN()) && Objects.equals(this.tapeRecoveryPointInfos(), other.tapeRecoveryPointInfos()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"DescribeTapeRecoveryPointsResponse").add("GatewayARN", (Object)this.gatewayARN()).add("TapeRecoveryPointInfos", this.tapeRecoveryPointInfos()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayARN": {
                return Optional.ofNullable(clazz.cast(this.gatewayARN()));
            }
            case "TapeRecoveryPointInfos": {
                return Optional.ofNullable(clazz.cast(this.tapeRecoveryPointInfos()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTapeRecoveryPointsResponse, T> g) {
        return obj -> g.apply((DescribeTapeRecoveryPointsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayResponse.BuilderImpl
    implements Builder {
        private String gatewayARN;
        private List<TapeRecoveryPointInfo> tapeRecoveryPointInfos = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTapeRecoveryPointsResponse model) {
            super(model);
            this.gatewayARN(model.gatewayARN);
            this.tapeRecoveryPointInfos(model.tapeRecoveryPointInfos);
            this.marker(model.marker);
        }

        public final String getGatewayARN() {
            return this.gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final Collection<TapeRecoveryPointInfo.Builder> getTapeRecoveryPointInfos() {
            return this.tapeRecoveryPointInfos != null ? (Collection)this.tapeRecoveryPointInfos.stream().map(TapeRecoveryPointInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tapeRecoveryPointInfos(Collection<TapeRecoveryPointInfo> tapeRecoveryPointInfos) {
            this.tapeRecoveryPointInfos = TapeRecoveryPointInfosCopier.copy(tapeRecoveryPointInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tapeRecoveryPointInfos(TapeRecoveryPointInfo ... tapeRecoveryPointInfos) {
            this.tapeRecoveryPointInfos(Arrays.asList(tapeRecoveryPointInfos));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tapeRecoveryPointInfos(Consumer<TapeRecoveryPointInfo.Builder> ... tapeRecoveryPointInfos) {
            this.tapeRecoveryPointInfos(Stream.of(tapeRecoveryPointInfos).map(c -> (TapeRecoveryPointInfo)((TapeRecoveryPointInfo.Builder)TapeRecoveryPointInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTapeRecoveryPointInfos(Collection<TapeRecoveryPointInfo.BuilderImpl> tapeRecoveryPointInfos) {
            this.tapeRecoveryPointInfos = TapeRecoveryPointInfosCopier.copyFromBuilder(tapeRecoveryPointInfos);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeTapeRecoveryPointsResponse build() {
            return new DescribeTapeRecoveryPointsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTapeRecoveryPointsResponse> {
        public Builder gatewayARN(String var1);

        public Builder tapeRecoveryPointInfos(Collection<TapeRecoveryPointInfo> var1);

        public Builder tapeRecoveryPointInfos(TapeRecoveryPointInfo ... var1);

        public Builder tapeRecoveryPointInfos(Consumer<TapeRecoveryPointInfo.Builder> ... var1);

        public Builder marker(String var1);
    }
}

