/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.storagegateway.model.ActiveDirectoryStatus;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JoinDomainResponse
extends StorageGatewayResponse
implements ToCopyableBuilder<Builder, JoinDomainResponse> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JoinDomainResponse.getter(JoinDomainResponse::gatewayARN)).setter(JoinDomainResponse.setter(Builder::gatewayARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()}).build();
    private static final SdkField<String> ACTIVE_DIRECTORY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JoinDomainResponse.getter(JoinDomainResponse::activeDirectoryStatusAsString)).setter(JoinDomainResponse.setter(Builder::activeDirectoryStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDirectoryStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD, ACTIVE_DIRECTORY_STATUS_FIELD));
    private final String gatewayARN;
    private final String activeDirectoryStatus;

    private JoinDomainResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.activeDirectoryStatus = builder.activeDirectoryStatus;
    }

    public String gatewayARN() {
        return this.gatewayARN;
    }

    public ActiveDirectoryStatus activeDirectoryStatus() {
        return ActiveDirectoryStatus.fromValue(this.activeDirectoryStatus);
    }

    public String activeDirectoryStatusAsString() {
        return this.activeDirectoryStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeDirectoryStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JoinDomainResponse)) {
            return false;
        }
        JoinDomainResponse other = (JoinDomainResponse)((Object)obj);
        return Objects.equals(this.gatewayARN(), other.gatewayARN()) && Objects.equals(this.activeDirectoryStatusAsString(), other.activeDirectoryStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"JoinDomainResponse").add("GatewayARN", (Object)this.gatewayARN()).add("ActiveDirectoryStatus", (Object)this.activeDirectoryStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayARN": {
                return Optional.ofNullable(clazz.cast(this.gatewayARN()));
            }
            case "ActiveDirectoryStatus": {
                return Optional.ofNullable(clazz.cast(this.activeDirectoryStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JoinDomainResponse, T> g) {
        return obj -> g.apply((JoinDomainResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayResponse.BuilderImpl
    implements Builder {
        private String gatewayARN;
        private String activeDirectoryStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(JoinDomainResponse model) {
            super(model);
            this.gatewayARN(model.gatewayARN);
            this.activeDirectoryStatus(model.activeDirectoryStatus);
        }

        public final String getGatewayARN() {
            return this.gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final String getActiveDirectoryStatusAsString() {
            return this.activeDirectoryStatus;
        }

        @Override
        public final Builder activeDirectoryStatus(String activeDirectoryStatus) {
            this.activeDirectoryStatus = activeDirectoryStatus;
            return this;
        }

        @Override
        public final Builder activeDirectoryStatus(ActiveDirectoryStatus activeDirectoryStatus) {
            this.activeDirectoryStatus(activeDirectoryStatus == null ? null : activeDirectoryStatus.toString());
            return this;
        }

        public final void setActiveDirectoryStatus(String activeDirectoryStatus) {
            this.activeDirectoryStatus = activeDirectoryStatus;
        }

        @Override
        public JoinDomainResponse build() {
            return new JoinDomainResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, JoinDomainResponse> {
        public Builder gatewayARN(String var1);

        public Builder activeDirectoryStatus(String var1);

        public Builder activeDirectoryStatus(ActiveDirectoryStatus var1);
    }
}

