/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.DiskIdsCopier;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCacheResponse
extends StorageGatewayResponse
implements ToCopyableBuilder<Builder, DescribeCacheResponse> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayARN").getter(DescribeCacheResponse.getter(DescribeCacheResponse::gatewayARN)).setter(DescribeCacheResponse.setter(Builder::gatewayARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()}).build();
    private static final SdkField<List<String>> DISK_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DiskIds").getter(DescribeCacheResponse.getter(DescribeCacheResponse::diskIds)).setter(DescribeCacheResponse.setter(Builder::diskIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> CACHE_ALLOCATED_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CacheAllocatedInBytes").getter(DescribeCacheResponse.getter(DescribeCacheResponse::cacheAllocatedInBytes)).setter(DescribeCacheResponse.setter(Builder::cacheAllocatedInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheAllocatedInBytes").build()}).build();
    private static final SdkField<Double> CACHE_USED_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("CacheUsedPercentage").getter(DescribeCacheResponse.getter(DescribeCacheResponse::cacheUsedPercentage)).setter(DescribeCacheResponse.setter(Builder::cacheUsedPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheUsedPercentage").build()}).build();
    private static final SdkField<Double> CACHE_DIRTY_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("CacheDirtyPercentage").getter(DescribeCacheResponse.getter(DescribeCacheResponse::cacheDirtyPercentage)).setter(DescribeCacheResponse.setter(Builder::cacheDirtyPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheDirtyPercentage").build()}).build();
    private static final SdkField<Double> CACHE_HIT_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("CacheHitPercentage").getter(DescribeCacheResponse.getter(DescribeCacheResponse::cacheHitPercentage)).setter(DescribeCacheResponse.setter(Builder::cacheHitPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheHitPercentage").build()}).build();
    private static final SdkField<Double> CACHE_MISS_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("CacheMissPercentage").getter(DescribeCacheResponse.getter(DescribeCacheResponse::cacheMissPercentage)).setter(DescribeCacheResponse.setter(Builder::cacheMissPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheMissPercentage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD, DISK_IDS_FIELD, CACHE_ALLOCATED_IN_BYTES_FIELD, CACHE_USED_PERCENTAGE_FIELD, CACHE_DIRTY_PERCENTAGE_FIELD, CACHE_HIT_PERCENTAGE_FIELD, CACHE_MISS_PERCENTAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeCacheResponse.memberNameToFieldInitializer();
    private final String gatewayARN;
    private final List<String> diskIds;
    private final Long cacheAllocatedInBytes;
    private final Double cacheUsedPercentage;
    private final Double cacheDirtyPercentage;
    private final Double cacheHitPercentage;
    private final Double cacheMissPercentage;

    private DescribeCacheResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.diskIds = builder.diskIds;
        this.cacheAllocatedInBytes = builder.cacheAllocatedInBytes;
        this.cacheUsedPercentage = builder.cacheUsedPercentage;
        this.cacheDirtyPercentage = builder.cacheDirtyPercentage;
        this.cacheHitPercentage = builder.cacheHitPercentage;
        this.cacheMissPercentage = builder.cacheMissPercentage;
    }

    public final String gatewayARN() {
        return this.gatewayARN;
    }

    public final boolean hasDiskIds() {
        return this.diskIds != null && !(this.diskIds instanceof SdkAutoConstructList);
    }

    public final List<String> diskIds() {
        return this.diskIds;
    }

    public final Long cacheAllocatedInBytes() {
        return this.cacheAllocatedInBytes;
    }

    public final Double cacheUsedPercentage() {
        return this.cacheUsedPercentage;
    }

    public final Double cacheDirtyPercentage() {
        return this.cacheDirtyPercentage;
    }

    public final Double cacheHitPercentage() {
        return this.cacheHitPercentage;
    }

    public final Double cacheMissPercentage() {
        return this.cacheMissPercentage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDiskIds() ? this.diskIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheAllocatedInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheUsedPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheDirtyPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheHitPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheMissPercentage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCacheResponse)) {
            return false;
        }
        DescribeCacheResponse other = (DescribeCacheResponse)((Object)obj);
        return Objects.equals(this.gatewayARN(), other.gatewayARN()) && this.hasDiskIds() == other.hasDiskIds() && Objects.equals(this.diskIds(), other.diskIds()) && Objects.equals(this.cacheAllocatedInBytes(), other.cacheAllocatedInBytes()) && Objects.equals(this.cacheUsedPercentage(), other.cacheUsedPercentage()) && Objects.equals(this.cacheDirtyPercentage(), other.cacheDirtyPercentage()) && Objects.equals(this.cacheHitPercentage(), other.cacheHitPercentage()) && Objects.equals(this.cacheMissPercentage(), other.cacheMissPercentage());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeCacheResponse").add("GatewayARN", (Object)this.gatewayARN()).add("DiskIds", this.hasDiskIds() ? this.diskIds() : null).add("CacheAllocatedInBytes", (Object)this.cacheAllocatedInBytes()).add("CacheUsedPercentage", (Object)this.cacheUsedPercentage()).add("CacheDirtyPercentage", (Object)this.cacheDirtyPercentage()).add("CacheHitPercentage", (Object)this.cacheHitPercentage()).add("CacheMissPercentage", (Object)this.cacheMissPercentage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayARN": {
                return Optional.ofNullable(clazz.cast(this.gatewayARN()));
            }
            case "DiskIds": {
                return Optional.ofNullable(clazz.cast(this.diskIds()));
            }
            case "CacheAllocatedInBytes": {
                return Optional.ofNullable(clazz.cast(this.cacheAllocatedInBytes()));
            }
            case "CacheUsedPercentage": {
                return Optional.ofNullable(clazz.cast(this.cacheUsedPercentage()));
            }
            case "CacheDirtyPercentage": {
                return Optional.ofNullable(clazz.cast(this.cacheDirtyPercentage()));
            }
            case "CacheHitPercentage": {
                return Optional.ofNullable(clazz.cast(this.cacheHitPercentage()));
            }
            case "CacheMissPercentage": {
                return Optional.ofNullable(clazz.cast(this.cacheMissPercentage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GatewayARN", GATEWAY_ARN_FIELD);
        map.put("DiskIds", DISK_IDS_FIELD);
        map.put("CacheAllocatedInBytes", CACHE_ALLOCATED_IN_BYTES_FIELD);
        map.put("CacheUsedPercentage", CACHE_USED_PERCENTAGE_FIELD);
        map.put("CacheDirtyPercentage", CACHE_DIRTY_PERCENTAGE_FIELD);
        map.put("CacheHitPercentage", CACHE_HIT_PERCENTAGE_FIELD);
        map.put("CacheMissPercentage", CACHE_MISS_PERCENTAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCacheResponse, T> g) {
        return obj -> g.apply((DescribeCacheResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayResponse.BuilderImpl
    implements Builder {
        private String gatewayARN;
        private List<String> diskIds = DefaultSdkAutoConstructList.getInstance();
        private Long cacheAllocatedInBytes;
        private Double cacheUsedPercentage;
        private Double cacheDirtyPercentage;
        private Double cacheHitPercentage;
        private Double cacheMissPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCacheResponse model) {
            super(model);
            this.gatewayARN(model.gatewayARN);
            this.diskIds(model.diskIds);
            this.cacheAllocatedInBytes(model.cacheAllocatedInBytes);
            this.cacheUsedPercentage(model.cacheUsedPercentage);
            this.cacheDirtyPercentage(model.cacheDirtyPercentage);
            this.cacheHitPercentage(model.cacheHitPercentage);
            this.cacheMissPercentage(model.cacheMissPercentage);
        }

        public final String getGatewayARN() {
            return this.gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final Collection<String> getDiskIds() {
            if (this.diskIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.diskIds;
        }

        public final void setDiskIds(Collection<String> diskIds) {
            this.diskIds = DiskIdsCopier.copy(diskIds);
        }

        @Override
        public final Builder diskIds(Collection<String> diskIds) {
            this.diskIds = DiskIdsCopier.copy(diskIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder diskIds(String ... diskIds) {
            this.diskIds(Arrays.asList(diskIds));
            return this;
        }

        public final Long getCacheAllocatedInBytes() {
            return this.cacheAllocatedInBytes;
        }

        public final void setCacheAllocatedInBytes(Long cacheAllocatedInBytes) {
            this.cacheAllocatedInBytes = cacheAllocatedInBytes;
        }

        @Override
        public final Builder cacheAllocatedInBytes(Long cacheAllocatedInBytes) {
            this.cacheAllocatedInBytes = cacheAllocatedInBytes;
            return this;
        }

        public final Double getCacheUsedPercentage() {
            return this.cacheUsedPercentage;
        }

        public final void setCacheUsedPercentage(Double cacheUsedPercentage) {
            this.cacheUsedPercentage = cacheUsedPercentage;
        }

        @Override
        public final Builder cacheUsedPercentage(Double cacheUsedPercentage) {
            this.cacheUsedPercentage = cacheUsedPercentage;
            return this;
        }

        public final Double getCacheDirtyPercentage() {
            return this.cacheDirtyPercentage;
        }

        public final void setCacheDirtyPercentage(Double cacheDirtyPercentage) {
            this.cacheDirtyPercentage = cacheDirtyPercentage;
        }

        @Override
        public final Builder cacheDirtyPercentage(Double cacheDirtyPercentage) {
            this.cacheDirtyPercentage = cacheDirtyPercentage;
            return this;
        }

        public final Double getCacheHitPercentage() {
            return this.cacheHitPercentage;
        }

        public final void setCacheHitPercentage(Double cacheHitPercentage) {
            this.cacheHitPercentage = cacheHitPercentage;
        }

        @Override
        public final Builder cacheHitPercentage(Double cacheHitPercentage) {
            this.cacheHitPercentage = cacheHitPercentage;
            return this;
        }

        public final Double getCacheMissPercentage() {
            return this.cacheMissPercentage;
        }

        public final void setCacheMissPercentage(Double cacheMissPercentage) {
            this.cacheMissPercentage = cacheMissPercentage;
        }

        @Override
        public final Builder cacheMissPercentage(Double cacheMissPercentage) {
            this.cacheMissPercentage = cacheMissPercentage;
            return this;
        }

        @Override
        public DescribeCacheResponse build() {
            return new DescribeCacheResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends StorageGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCacheResponse> {
        public Builder gatewayARN(String var1);

        public Builder diskIds(Collection<String> var1);

        public Builder diskIds(String ... var1);

        public Builder cacheAllocatedInBytes(Long var1);

        public Builder cacheUsedPercentage(Double var1);

        public Builder cacheDirtyPercentage(Double var1);

        public Builder cacheHitPercentage(Double var1);

        public Builder cacheMissPercentage(Double var1);
    }
}

