/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.storagegateway.model.ActiveDirectoryStatus;
import software.amazon.awssdk.services.storagegateway.model.SMBLocalGroups;
import software.amazon.awssdk.services.storagegateway.model.SMBSecurityStrategy;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSmbSettingsResponse
extends StorageGatewayResponse
implements ToCopyableBuilder<Builder, DescribeSmbSettingsResponse> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayARN").getter(DescribeSmbSettingsResponse.getter(DescribeSmbSettingsResponse::gatewayARN)).setter(DescribeSmbSettingsResponse.setter(Builder::gatewayARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(DescribeSmbSettingsResponse.getter(DescribeSmbSettingsResponse::domainName)).setter(DescribeSmbSettingsResponse.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> ACTIVE_DIRECTORY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActiveDirectoryStatus").getter(DescribeSmbSettingsResponse.getter(DescribeSmbSettingsResponse::activeDirectoryStatusAsString)).setter(DescribeSmbSettingsResponse.setter(Builder::activeDirectoryStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDirectoryStatus").build()}).build();
    private static final SdkField<Boolean> SMB_GUEST_PASSWORD_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SMBGuestPasswordSet").getter(DescribeSmbSettingsResponse.getter(DescribeSmbSettingsResponse::smbGuestPasswordSet)).setter(DescribeSmbSettingsResponse.setter(Builder::smbGuestPasswordSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMBGuestPasswordSet").build()}).build();
    private static final SdkField<String> SMB_SECURITY_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SMBSecurityStrategy").getter(DescribeSmbSettingsResponse.getter(DescribeSmbSettingsResponse::smbSecurityStrategyAsString)).setter(DescribeSmbSettingsResponse.setter(Builder::smbSecurityStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMBSecurityStrategy").build()}).build();
    private static final SdkField<Boolean> FILE_SHARES_VISIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("FileSharesVisible").getter(DescribeSmbSettingsResponse.getter(DescribeSmbSettingsResponse::fileSharesVisible)).setter(DescribeSmbSettingsResponse.setter(Builder::fileSharesVisible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSharesVisible").build()}).build();
    private static final SdkField<SMBLocalGroups> SMB_LOCAL_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SMBLocalGroups").getter(DescribeSmbSettingsResponse.getter(DescribeSmbSettingsResponse::smbLocalGroups)).setter(DescribeSmbSettingsResponse.setter(Builder::smbLocalGroups)).constructor(SMBLocalGroups::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMBLocalGroups").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD, DOMAIN_NAME_FIELD, ACTIVE_DIRECTORY_STATUS_FIELD, SMB_GUEST_PASSWORD_SET_FIELD, SMB_SECURITY_STRATEGY_FIELD, FILE_SHARES_VISIBLE_FIELD, SMB_LOCAL_GROUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeSmbSettingsResponse.memberNameToFieldInitializer();
    private final String gatewayARN;
    private final String domainName;
    private final String activeDirectoryStatus;
    private final Boolean smbGuestPasswordSet;
    private final String smbSecurityStrategy;
    private final Boolean fileSharesVisible;
    private final SMBLocalGroups smbLocalGroups;

    private DescribeSmbSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.domainName = builder.domainName;
        this.activeDirectoryStatus = builder.activeDirectoryStatus;
        this.smbGuestPasswordSet = builder.smbGuestPasswordSet;
        this.smbSecurityStrategy = builder.smbSecurityStrategy;
        this.fileSharesVisible = builder.fileSharesVisible;
        this.smbLocalGroups = builder.smbLocalGroups;
    }

    public final String gatewayARN() {
        return this.gatewayARN;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final ActiveDirectoryStatus activeDirectoryStatus() {
        return ActiveDirectoryStatus.fromValue(this.activeDirectoryStatus);
    }

    public final String activeDirectoryStatusAsString() {
        return this.activeDirectoryStatus;
    }

    public final Boolean smbGuestPasswordSet() {
        return this.smbGuestPasswordSet;
    }

    public final SMBSecurityStrategy smbSecurityStrategy() {
        return SMBSecurityStrategy.fromValue(this.smbSecurityStrategy);
    }

    public final String smbSecurityStrategyAsString() {
        return this.smbSecurityStrategy;
    }

    public final Boolean fileSharesVisible() {
        return this.fileSharesVisible;
    }

    public final SMBLocalGroups smbLocalGroups() {
        return this.smbLocalGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeDirectoryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.smbGuestPasswordSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.smbSecurityStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSharesVisible());
        hashCode = 31 * hashCode + Objects.hashCode(this.smbLocalGroups());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSmbSettingsResponse)) {
            return false;
        }
        DescribeSmbSettingsResponse other = (DescribeSmbSettingsResponse)((Object)obj);
        return Objects.equals(this.gatewayARN(), other.gatewayARN()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.activeDirectoryStatusAsString(), other.activeDirectoryStatusAsString()) && Objects.equals(this.smbGuestPasswordSet(), other.smbGuestPasswordSet()) && Objects.equals(this.smbSecurityStrategyAsString(), other.smbSecurityStrategyAsString()) && Objects.equals(this.fileSharesVisible(), other.fileSharesVisible()) && Objects.equals(this.smbLocalGroups(), other.smbLocalGroups());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSmbSettingsResponse").add("GatewayARN", (Object)this.gatewayARN()).add("DomainName", (Object)this.domainName()).add("ActiveDirectoryStatus", (Object)this.activeDirectoryStatusAsString()).add("SMBGuestPasswordSet", (Object)this.smbGuestPasswordSet()).add("SMBSecurityStrategy", (Object)this.smbSecurityStrategyAsString()).add("FileSharesVisible", (Object)this.fileSharesVisible()).add("SMBLocalGroups", (Object)this.smbLocalGroups()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayARN": {
                return Optional.ofNullable(clazz.cast(this.gatewayARN()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "ActiveDirectoryStatus": {
                return Optional.ofNullable(clazz.cast(this.activeDirectoryStatusAsString()));
            }
            case "SMBGuestPasswordSet": {
                return Optional.ofNullable(clazz.cast(this.smbGuestPasswordSet()));
            }
            case "SMBSecurityStrategy": {
                return Optional.ofNullable(clazz.cast(this.smbSecurityStrategyAsString()));
            }
            case "FileSharesVisible": {
                return Optional.ofNullable(clazz.cast(this.fileSharesVisible()));
            }
            case "SMBLocalGroups": {
                return Optional.ofNullable(clazz.cast(this.smbLocalGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GatewayARN", GATEWAY_ARN_FIELD);
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("ActiveDirectoryStatus", ACTIVE_DIRECTORY_STATUS_FIELD);
        map.put("SMBGuestPasswordSet", SMB_GUEST_PASSWORD_SET_FIELD);
        map.put("SMBSecurityStrategy", SMB_SECURITY_STRATEGY_FIELD);
        map.put("FileSharesVisible", FILE_SHARES_VISIBLE_FIELD);
        map.put("SMBLocalGroups", SMB_LOCAL_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeSmbSettingsResponse, T> g) {
        return obj -> g.apply((DescribeSmbSettingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayResponse.BuilderImpl
    implements Builder {
        private String gatewayARN;
        private String domainName;
        private String activeDirectoryStatus;
        private Boolean smbGuestPasswordSet;
        private String smbSecurityStrategy;
        private Boolean fileSharesVisible;
        private SMBLocalGroups smbLocalGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSmbSettingsResponse model) {
            super(model);
            this.gatewayARN(model.gatewayARN);
            this.domainName(model.domainName);
            this.activeDirectoryStatus(model.activeDirectoryStatus);
            this.smbGuestPasswordSet(model.smbGuestPasswordSet);
            this.smbSecurityStrategy(model.smbSecurityStrategy);
            this.fileSharesVisible(model.fileSharesVisible);
            this.smbLocalGroups(model.smbLocalGroups);
        }

        public final String getGatewayARN() {
            return this.gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getActiveDirectoryStatus() {
            return this.activeDirectoryStatus;
        }

        public final void setActiveDirectoryStatus(String activeDirectoryStatus) {
            this.activeDirectoryStatus = activeDirectoryStatus;
        }

        @Override
        public final Builder activeDirectoryStatus(String activeDirectoryStatus) {
            this.activeDirectoryStatus = activeDirectoryStatus;
            return this;
        }

        @Override
        public final Builder activeDirectoryStatus(ActiveDirectoryStatus activeDirectoryStatus) {
            this.activeDirectoryStatus(activeDirectoryStatus == null ? null : activeDirectoryStatus.toString());
            return this;
        }

        public final Boolean getSmbGuestPasswordSet() {
            return this.smbGuestPasswordSet;
        }

        public final void setSmbGuestPasswordSet(Boolean smbGuestPasswordSet) {
            this.smbGuestPasswordSet = smbGuestPasswordSet;
        }

        @Override
        public final Builder smbGuestPasswordSet(Boolean smbGuestPasswordSet) {
            this.smbGuestPasswordSet = smbGuestPasswordSet;
            return this;
        }

        public final String getSmbSecurityStrategy() {
            return this.smbSecurityStrategy;
        }

        public final void setSmbSecurityStrategy(String smbSecurityStrategy) {
            this.smbSecurityStrategy = smbSecurityStrategy;
        }

        @Override
        public final Builder smbSecurityStrategy(String smbSecurityStrategy) {
            this.smbSecurityStrategy = smbSecurityStrategy;
            return this;
        }

        @Override
        public final Builder smbSecurityStrategy(SMBSecurityStrategy smbSecurityStrategy) {
            this.smbSecurityStrategy(smbSecurityStrategy == null ? null : smbSecurityStrategy.toString());
            return this;
        }

        public final Boolean getFileSharesVisible() {
            return this.fileSharesVisible;
        }

        public final void setFileSharesVisible(Boolean fileSharesVisible) {
            this.fileSharesVisible = fileSharesVisible;
        }

        @Override
        public final Builder fileSharesVisible(Boolean fileSharesVisible) {
            this.fileSharesVisible = fileSharesVisible;
            return this;
        }

        public final SMBLocalGroups.Builder getSmbLocalGroups() {
            return this.smbLocalGroups != null ? this.smbLocalGroups.toBuilder() : null;
        }

        public final void setSmbLocalGroups(SMBLocalGroups.BuilderImpl smbLocalGroups) {
            this.smbLocalGroups = smbLocalGroups != null ? smbLocalGroups.build() : null;
        }

        @Override
        public final Builder smbLocalGroups(SMBLocalGroups smbLocalGroups) {
            this.smbLocalGroups = smbLocalGroups;
            return this;
        }

        @Override
        public DescribeSmbSettingsResponse build() {
            return new DescribeSmbSettingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends StorageGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSmbSettingsResponse> {
        public Builder gatewayARN(String var1);

        public Builder domainName(String var1);

        public Builder activeDirectoryStatus(String var1);

        public Builder activeDirectoryStatus(ActiveDirectoryStatus var1);

        public Builder smbGuestPasswordSet(Boolean var1);

        public Builder smbSecurityStrategy(String var1);

        public Builder smbSecurityStrategy(SMBSecurityStrategy var1);

        public Builder fileSharesVisible(Boolean var1);

        public Builder smbLocalGroups(SMBLocalGroups var1);

        default public Builder smbLocalGroups(Consumer<SMBLocalGroups.Builder> smbLocalGroups) {
            return this.smbLocalGroups((SMBLocalGroups)((SMBLocalGroups.Builder)SMBLocalGroups.builder().applyMutation(smbLocalGroups)).build());
        }
    }
}

