/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteChapCredentialsResponse
extends StorageGatewayResponse
implements ToCopyableBuilder<Builder, DeleteChapCredentialsResponse> {
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteChapCredentialsResponse.getter(DeleteChapCredentialsResponse::targetARN)).setter(DeleteChapCredentialsResponse.setter(Builder::targetARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetARN").build()}).build();
    private static final SdkField<String> INITIATOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteChapCredentialsResponse.getter(DeleteChapCredentialsResponse::initiatorName)).setter(DeleteChapCredentialsResponse.setter(Builder::initiatorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiatorName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ARN_FIELD, INITIATOR_NAME_FIELD));
    private final String targetARN;
    private final String initiatorName;

    private DeleteChapCredentialsResponse(BuilderImpl builder) {
        super(builder);
        this.targetARN = builder.targetARN;
        this.initiatorName = builder.initiatorName;
    }

    public String targetARN() {
        return this.targetARN;
    }

    public String initiatorName() {
        return this.initiatorName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.initiatorName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteChapCredentialsResponse)) {
            return false;
        }
        DeleteChapCredentialsResponse other = (DeleteChapCredentialsResponse)((Object)obj);
        return Objects.equals(this.targetARN(), other.targetARN()) && Objects.equals(this.initiatorName(), other.initiatorName());
    }

    public String toString() {
        return ToString.builder((String)"DeleteChapCredentialsResponse").add("TargetARN", (Object)this.targetARN()).add("InitiatorName", (Object)this.initiatorName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetARN": {
                return Optional.ofNullable(clazz.cast(this.targetARN()));
            }
            case "InitiatorName": {
                return Optional.ofNullable(clazz.cast(this.initiatorName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteChapCredentialsResponse, T> g) {
        return obj -> g.apply((DeleteChapCredentialsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayResponse.BuilderImpl
    implements Builder {
        private String targetARN;
        private String initiatorName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteChapCredentialsResponse model) {
            super(model);
            this.targetARN(model.targetARN);
            this.initiatorName(model.initiatorName);
        }

        public final String getTargetARN() {
            return this.targetARN;
        }

        @Override
        public final Builder targetARN(String targetARN) {
            this.targetARN = targetARN;
            return this;
        }

        public final void setTargetARN(String targetARN) {
            this.targetARN = targetARN;
        }

        public final String getInitiatorName() {
            return this.initiatorName;
        }

        @Override
        public final Builder initiatorName(String initiatorName) {
            this.initiatorName = initiatorName;
            return this;
        }

        public final void setInitiatorName(String initiatorName) {
            this.initiatorName = initiatorName;
        }

        @Override
        public DeleteChapCredentialsResponse build() {
            return new DeleteChapCredentialsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteChapCredentialsResponse> {
        public Builder targetARN(String var1);

        public Builder initiatorName(String var1);
    }
}

