/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayResponse;
import software.amazon.awssdk.services.storagegateway.model.TapeArchive;
import software.amazon.awssdk.services.storagegateway.model.TapeArchivesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTapeArchivesResponse
extends StorageGatewayResponse
implements ToCopyableBuilder<Builder, DescribeTapeArchivesResponse> {
    private static final SdkField<List<TapeArchive>> TAPE_ARCHIVES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeTapeArchivesResponse.getter(DescribeTapeArchivesResponse::tapeArchives)).setter(DescribeTapeArchivesResponse.setter(Builder::tapeArchives)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeArchives").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TapeArchive::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTapeArchivesResponse.getter(DescribeTapeArchivesResponse::marker)).setter(DescribeTapeArchivesResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAPE_ARCHIVES_FIELD, MARKER_FIELD));
    private final List<TapeArchive> tapeArchives;
    private final String marker;

    private DescribeTapeArchivesResponse(BuilderImpl builder) {
        super(builder);
        this.tapeArchives = builder.tapeArchives;
        this.marker = builder.marker;
    }

    public List<TapeArchive> tapeArchives() {
        return this.tapeArchives;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tapeArchives());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTapeArchivesResponse)) {
            return false;
        }
        DescribeTapeArchivesResponse other = (DescribeTapeArchivesResponse)((Object)obj);
        return Objects.equals(this.tapeArchives(), other.tapeArchives()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"DescribeTapeArchivesResponse").add("TapeArchives", this.tapeArchives()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TapeArchives": {
                return Optional.ofNullable(clazz.cast(this.tapeArchives()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTapeArchivesResponse, T> g) {
        return obj -> g.apply((DescribeTapeArchivesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayResponse.BuilderImpl
    implements Builder {
        private List<TapeArchive> tapeArchives = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTapeArchivesResponse model) {
            super(model);
            this.tapeArchives(model.tapeArchives);
            this.marker(model.marker);
        }

        public final Collection<TapeArchive.Builder> getTapeArchives() {
            return this.tapeArchives != null ? (Collection)this.tapeArchives.stream().map(TapeArchive::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tapeArchives(Collection<TapeArchive> tapeArchives) {
            this.tapeArchives = TapeArchivesCopier.copy(tapeArchives);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tapeArchives(TapeArchive ... tapeArchives) {
            this.tapeArchives(Arrays.asList(tapeArchives));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tapeArchives(Consumer<TapeArchive.Builder> ... tapeArchives) {
            this.tapeArchives(Stream.of(tapeArchives).map(c -> (TapeArchive)((TapeArchive.Builder)TapeArchive.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTapeArchives(Collection<TapeArchive.BuilderImpl> tapeArchives) {
            this.tapeArchives = TapeArchivesCopier.copyFromBuilder(tapeArchives);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeTapeArchivesResponse build() {
            return new DescribeTapeArchivesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTapeArchivesResponse> {
        public Builder tapeArchives(Collection<TapeArchive> var1);

        public Builder tapeArchives(TapeArchive ... var1);

        public Builder tapeArchives(Consumer<TapeArchive.Builder> ... var1);

        public Builder marker(String var1);
    }
}

