/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TapeArchive
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TapeArchive> {
    private static final SdkField<String> TAPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TapeArchive.getter(TapeArchive::tapeARN)).setter(TapeArchive.setter(Builder::tapeARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeARN").build()}).build();
    private static final SdkField<String> TAPE_BARCODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TapeArchive.getter(TapeArchive::tapeBarcode)).setter(TapeArchive.setter(Builder::tapeBarcode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeBarcode").build()}).build();
    private static final SdkField<Instant> TAPE_CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(TapeArchive.getter(TapeArchive::tapeCreatedDate)).setter(TapeArchive.setter(Builder::tapeCreatedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeCreatedDate").build()}).build();
    private static final SdkField<Long> TAPE_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(TapeArchive.getter(TapeArchive::tapeSizeInBytes)).setter(TapeArchive.setter(Builder::tapeSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeSizeInBytes").build()}).build();
    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(TapeArchive.getter(TapeArchive::completionTime)).setter(TapeArchive.setter(Builder::completionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTime").build()}).build();
    private static final SdkField<String> RETRIEVED_TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TapeArchive.getter(TapeArchive::retrievedTo)).setter(TapeArchive.setter(Builder::retrievedTo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrievedTo").build()}).build();
    private static final SdkField<String> TAPE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TapeArchive.getter(TapeArchive::tapeStatus)).setter(TapeArchive.setter(Builder::tapeStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeStatus").build()}).build();
    private static final SdkField<Long> TAPE_USED_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(TapeArchive.getter(TapeArchive::tapeUsedInBytes)).setter(TapeArchive.setter(Builder::tapeUsedInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeUsedInBytes").build()}).build();
    private static final SdkField<String> KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TapeArchive.getter(TapeArchive::kmsKey)).setter(TapeArchive.setter(Builder::kmsKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAPE_ARN_FIELD, TAPE_BARCODE_FIELD, TAPE_CREATED_DATE_FIELD, TAPE_SIZE_IN_BYTES_FIELD, COMPLETION_TIME_FIELD, RETRIEVED_TO_FIELD, TAPE_STATUS_FIELD, TAPE_USED_IN_BYTES_FIELD, KMS_KEY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String tapeARN;
    private final String tapeBarcode;
    private final Instant tapeCreatedDate;
    private final Long tapeSizeInBytes;
    private final Instant completionTime;
    private final String retrievedTo;
    private final String tapeStatus;
    private final Long tapeUsedInBytes;
    private final String kmsKey;

    private TapeArchive(BuilderImpl builder) {
        this.tapeARN = builder.tapeARN;
        this.tapeBarcode = builder.tapeBarcode;
        this.tapeCreatedDate = builder.tapeCreatedDate;
        this.tapeSizeInBytes = builder.tapeSizeInBytes;
        this.completionTime = builder.completionTime;
        this.retrievedTo = builder.retrievedTo;
        this.tapeStatus = builder.tapeStatus;
        this.tapeUsedInBytes = builder.tapeUsedInBytes;
        this.kmsKey = builder.kmsKey;
    }

    public String tapeARN() {
        return this.tapeARN;
    }

    public String tapeBarcode() {
        return this.tapeBarcode;
    }

    public Instant tapeCreatedDate() {
        return this.tapeCreatedDate;
    }

    public Long tapeSizeInBytes() {
        return this.tapeSizeInBytes;
    }

    public Instant completionTime() {
        return this.completionTime;
    }

    public String retrievedTo() {
        return this.retrievedTo;
    }

    public String tapeStatus() {
        return this.tapeStatus;
    }

    public Long tapeUsedInBytes() {
        return this.tapeUsedInBytes;
    }

    public String kmsKey() {
        return this.kmsKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tapeARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.tapeBarcode());
        hashCode = 31 * hashCode + Objects.hashCode(this.tapeCreatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.tapeSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.retrievedTo());
        hashCode = 31 * hashCode + Objects.hashCode(this.tapeStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.tapeUsedInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKey());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TapeArchive)) {
            return false;
        }
        TapeArchive other = (TapeArchive)obj;
        return Objects.equals(this.tapeARN(), other.tapeARN()) && Objects.equals(this.tapeBarcode(), other.tapeBarcode()) && Objects.equals(this.tapeCreatedDate(), other.tapeCreatedDate()) && Objects.equals(this.tapeSizeInBytes(), other.tapeSizeInBytes()) && Objects.equals(this.completionTime(), other.completionTime()) && Objects.equals(this.retrievedTo(), other.retrievedTo()) && Objects.equals(this.tapeStatus(), other.tapeStatus()) && Objects.equals(this.tapeUsedInBytes(), other.tapeUsedInBytes()) && Objects.equals(this.kmsKey(), other.kmsKey());
    }

    public String toString() {
        return ToString.builder((String)"TapeArchive").add("TapeARN", (Object)this.tapeARN()).add("TapeBarcode", (Object)this.tapeBarcode()).add("TapeCreatedDate", (Object)this.tapeCreatedDate()).add("TapeSizeInBytes", (Object)this.tapeSizeInBytes()).add("CompletionTime", (Object)this.completionTime()).add("RetrievedTo", (Object)this.retrievedTo()).add("TapeStatus", (Object)this.tapeStatus()).add("TapeUsedInBytes", (Object)this.tapeUsedInBytes()).add("KMSKey", (Object)this.kmsKey()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TapeARN": {
                return Optional.ofNullable(clazz.cast(this.tapeARN()));
            }
            case "TapeBarcode": {
                return Optional.ofNullable(clazz.cast(this.tapeBarcode()));
            }
            case "TapeCreatedDate": {
                return Optional.ofNullable(clazz.cast(this.tapeCreatedDate()));
            }
            case "TapeSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.tapeSizeInBytes()));
            }
            case "CompletionTime": {
                return Optional.ofNullable(clazz.cast(this.completionTime()));
            }
            case "RetrievedTo": {
                return Optional.ofNullable(clazz.cast(this.retrievedTo()));
            }
            case "TapeStatus": {
                return Optional.ofNullable(clazz.cast(this.tapeStatus()));
            }
            case "TapeUsedInBytes": {
                return Optional.ofNullable(clazz.cast(this.tapeUsedInBytes()));
            }
            case "KMSKey": {
                return Optional.ofNullable(clazz.cast(this.kmsKey()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TapeArchive, T> g) {
        return obj -> g.apply((TapeArchive)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tapeARN;
        private String tapeBarcode;
        private Instant tapeCreatedDate;
        private Long tapeSizeInBytes;
        private Instant completionTime;
        private String retrievedTo;
        private String tapeStatus;
        private Long tapeUsedInBytes;
        private String kmsKey;

        private BuilderImpl() {
        }

        private BuilderImpl(TapeArchive model) {
            this.tapeARN(model.tapeARN);
            this.tapeBarcode(model.tapeBarcode);
            this.tapeCreatedDate(model.tapeCreatedDate);
            this.tapeSizeInBytes(model.tapeSizeInBytes);
            this.completionTime(model.completionTime);
            this.retrievedTo(model.retrievedTo);
            this.tapeStatus(model.tapeStatus);
            this.tapeUsedInBytes(model.tapeUsedInBytes);
            this.kmsKey(model.kmsKey);
        }

        public final String getTapeARN() {
            return this.tapeARN;
        }

        @Override
        public final Builder tapeARN(String tapeARN) {
            this.tapeARN = tapeARN;
            return this;
        }

        public final void setTapeARN(String tapeARN) {
            this.tapeARN = tapeARN;
        }

        public final String getTapeBarcode() {
            return this.tapeBarcode;
        }

        @Override
        public final Builder tapeBarcode(String tapeBarcode) {
            this.tapeBarcode = tapeBarcode;
            return this;
        }

        public final void setTapeBarcode(String tapeBarcode) {
            this.tapeBarcode = tapeBarcode;
        }

        public final Instant getTapeCreatedDate() {
            return this.tapeCreatedDate;
        }

        @Override
        public final Builder tapeCreatedDate(Instant tapeCreatedDate) {
            this.tapeCreatedDate = tapeCreatedDate;
            return this;
        }

        public final void setTapeCreatedDate(Instant tapeCreatedDate) {
            this.tapeCreatedDate = tapeCreatedDate;
        }

        public final Long getTapeSizeInBytes() {
            return this.tapeSizeInBytes;
        }

        @Override
        public final Builder tapeSizeInBytes(Long tapeSizeInBytes) {
            this.tapeSizeInBytes = tapeSizeInBytes;
            return this;
        }

        public final void setTapeSizeInBytes(Long tapeSizeInBytes) {
            this.tapeSizeInBytes = tapeSizeInBytes;
        }

        public final Instant getCompletionTime() {
            return this.completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        public final String getRetrievedTo() {
            return this.retrievedTo;
        }

        @Override
        public final Builder retrievedTo(String retrievedTo) {
            this.retrievedTo = retrievedTo;
            return this;
        }

        public final void setRetrievedTo(String retrievedTo) {
            this.retrievedTo = retrievedTo;
        }

        public final String getTapeStatus() {
            return this.tapeStatus;
        }

        @Override
        public final Builder tapeStatus(String tapeStatus) {
            this.tapeStatus = tapeStatus;
            return this;
        }

        public final void setTapeStatus(String tapeStatus) {
            this.tapeStatus = tapeStatus;
        }

        public final Long getTapeUsedInBytes() {
            return this.tapeUsedInBytes;
        }

        @Override
        public final Builder tapeUsedInBytes(Long tapeUsedInBytes) {
            this.tapeUsedInBytes = tapeUsedInBytes;
            return this;
        }

        public final void setTapeUsedInBytes(Long tapeUsedInBytes) {
            this.tapeUsedInBytes = tapeUsedInBytes;
        }

        public final String getKmsKey() {
            return this.kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        public TapeArchive build() {
            return new TapeArchive(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TapeArchive> {
        public Builder tapeARN(String var1);

        public Builder tapeBarcode(String var1);

        public Builder tapeCreatedDate(Instant var1);

        public Builder tapeSizeInBytes(Long var1);

        public Builder completionTime(Instant var1);

        public Builder retrievedTo(String var1);

        public Builder tapeStatus(String var1);

        public Builder tapeUsedInBytes(Long var1);

        public Builder kmsKey(String var1);
    }
}

