/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.storagegateway.model.DeviceiSCSIAttributes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VTLDevice
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VTLDevice> {
    private static final SdkField<String> VTL_DEVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VTLDevice.getter(VTLDevice::vtlDeviceARN)).setter(VTLDevice.setter(Builder::vtlDeviceARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VTLDeviceARN").build()}).build();
    private static final SdkField<String> VTL_DEVICE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VTLDevice.getter(VTLDevice::vtlDeviceType)).setter(VTLDevice.setter(Builder::vtlDeviceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VTLDeviceType").build()}).build();
    private static final SdkField<String> VTL_DEVICE_VENDOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VTLDevice.getter(VTLDevice::vtlDeviceVendor)).setter(VTLDevice.setter(Builder::vtlDeviceVendor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VTLDeviceVendor").build()}).build();
    private static final SdkField<String> VTL_DEVICE_PRODUCT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VTLDevice.getter(VTLDevice::vtlDeviceProductIdentifier)).setter(VTLDevice.setter(Builder::vtlDeviceProductIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VTLDeviceProductIdentifier").build()}).build();
    private static final SdkField<DeviceiSCSIAttributes> DEVICEI_SCSI_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(VTLDevice.getter(VTLDevice::deviceiSCSIAttributes)).setter(VTLDevice.setter(Builder::deviceiSCSIAttributes)).constructor(DeviceiSCSIAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceiSCSIAttributes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VTL_DEVICE_ARN_FIELD, VTL_DEVICE_TYPE_FIELD, VTL_DEVICE_VENDOR_FIELD, VTL_DEVICE_PRODUCT_IDENTIFIER_FIELD, DEVICEI_SCSI_ATTRIBUTES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String vtlDeviceARN;
    private final String vtlDeviceType;
    private final String vtlDeviceVendor;
    private final String vtlDeviceProductIdentifier;
    private final DeviceiSCSIAttributes deviceiSCSIAttributes;

    private VTLDevice(BuilderImpl builder) {
        this.vtlDeviceARN = builder.vtlDeviceARN;
        this.vtlDeviceType = builder.vtlDeviceType;
        this.vtlDeviceVendor = builder.vtlDeviceVendor;
        this.vtlDeviceProductIdentifier = builder.vtlDeviceProductIdentifier;
        this.deviceiSCSIAttributes = builder.deviceiSCSIAttributes;
    }

    public String vtlDeviceARN() {
        return this.vtlDeviceARN;
    }

    public String vtlDeviceType() {
        return this.vtlDeviceType;
    }

    public String vtlDeviceVendor() {
        return this.vtlDeviceVendor;
    }

    public String vtlDeviceProductIdentifier() {
        return this.vtlDeviceProductIdentifier;
    }

    public DeviceiSCSIAttributes deviceiSCSIAttributes() {
        return this.deviceiSCSIAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vtlDeviceARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.vtlDeviceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.vtlDeviceVendor());
        hashCode = 31 * hashCode + Objects.hashCode(this.vtlDeviceProductIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceiSCSIAttributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VTLDevice)) {
            return false;
        }
        VTLDevice other = (VTLDevice)obj;
        return Objects.equals(this.vtlDeviceARN(), other.vtlDeviceARN()) && Objects.equals(this.vtlDeviceType(), other.vtlDeviceType()) && Objects.equals(this.vtlDeviceVendor(), other.vtlDeviceVendor()) && Objects.equals(this.vtlDeviceProductIdentifier(), other.vtlDeviceProductIdentifier()) && Objects.equals(this.deviceiSCSIAttributes(), other.deviceiSCSIAttributes());
    }

    public String toString() {
        return ToString.builder((String)"VTLDevice").add("VTLDeviceARN", (Object)this.vtlDeviceARN()).add("VTLDeviceType", (Object)this.vtlDeviceType()).add("VTLDeviceVendor", (Object)this.vtlDeviceVendor()).add("VTLDeviceProductIdentifier", (Object)this.vtlDeviceProductIdentifier()).add("DeviceiSCSIAttributes", (Object)this.deviceiSCSIAttributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VTLDeviceARN": {
                return Optional.ofNullable(clazz.cast(this.vtlDeviceARN()));
            }
            case "VTLDeviceType": {
                return Optional.ofNullable(clazz.cast(this.vtlDeviceType()));
            }
            case "VTLDeviceVendor": {
                return Optional.ofNullable(clazz.cast(this.vtlDeviceVendor()));
            }
            case "VTLDeviceProductIdentifier": {
                return Optional.ofNullable(clazz.cast(this.vtlDeviceProductIdentifier()));
            }
            case "DeviceiSCSIAttributes": {
                return Optional.ofNullable(clazz.cast(this.deviceiSCSIAttributes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VTLDevice, T> g) {
        return obj -> g.apply((VTLDevice)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String vtlDeviceARN;
        private String vtlDeviceType;
        private String vtlDeviceVendor;
        private String vtlDeviceProductIdentifier;
        private DeviceiSCSIAttributes deviceiSCSIAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(VTLDevice model) {
            this.vtlDeviceARN(model.vtlDeviceARN);
            this.vtlDeviceType(model.vtlDeviceType);
            this.vtlDeviceVendor(model.vtlDeviceVendor);
            this.vtlDeviceProductIdentifier(model.vtlDeviceProductIdentifier);
            this.deviceiSCSIAttributes(model.deviceiSCSIAttributes);
        }

        public final String getVtlDeviceARN() {
            return this.vtlDeviceARN;
        }

        @Override
        public final Builder vtlDeviceARN(String vtlDeviceARN) {
            this.vtlDeviceARN = vtlDeviceARN;
            return this;
        }

        public final void setVtlDeviceARN(String vtlDeviceARN) {
            this.vtlDeviceARN = vtlDeviceARN;
        }

        public final String getVtlDeviceType() {
            return this.vtlDeviceType;
        }

        @Override
        public final Builder vtlDeviceType(String vtlDeviceType) {
            this.vtlDeviceType = vtlDeviceType;
            return this;
        }

        public final void setVtlDeviceType(String vtlDeviceType) {
            this.vtlDeviceType = vtlDeviceType;
        }

        public final String getVtlDeviceVendor() {
            return this.vtlDeviceVendor;
        }

        @Override
        public final Builder vtlDeviceVendor(String vtlDeviceVendor) {
            this.vtlDeviceVendor = vtlDeviceVendor;
            return this;
        }

        public final void setVtlDeviceVendor(String vtlDeviceVendor) {
            this.vtlDeviceVendor = vtlDeviceVendor;
        }

        public final String getVtlDeviceProductIdentifier() {
            return this.vtlDeviceProductIdentifier;
        }

        @Override
        public final Builder vtlDeviceProductIdentifier(String vtlDeviceProductIdentifier) {
            this.vtlDeviceProductIdentifier = vtlDeviceProductIdentifier;
            return this;
        }

        public final void setVtlDeviceProductIdentifier(String vtlDeviceProductIdentifier) {
            this.vtlDeviceProductIdentifier = vtlDeviceProductIdentifier;
        }

        public final DeviceiSCSIAttributes.Builder getDeviceiSCSIAttributes() {
            return this.deviceiSCSIAttributes != null ? this.deviceiSCSIAttributes.toBuilder() : null;
        }

        @Override
        public final Builder deviceiSCSIAttributes(DeviceiSCSIAttributes deviceiSCSIAttributes) {
            this.deviceiSCSIAttributes = deviceiSCSIAttributes;
            return this;
        }

        public final void setDeviceiSCSIAttributes(DeviceiSCSIAttributes.BuilderImpl deviceiSCSIAttributes) {
            this.deviceiSCSIAttributes = deviceiSCSIAttributes != null ? deviceiSCSIAttributes.build() : null;
        }

        public VTLDevice build() {
            return new VTLDevice(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VTLDevice> {
        public Builder vtlDeviceARN(String var1);

        public Builder vtlDeviceType(String var1);

        public Builder vtlDeviceVendor(String var1);

        public Builder vtlDeviceProductIdentifier(String var1);

        public Builder deviceiSCSIAttributes(DeviceiSCSIAttributes var1);

        default public Builder deviceiSCSIAttributes(Consumer<DeviceiSCSIAttributes.Builder> deviceiSCSIAttributes) {
            return this.deviceiSCSIAttributes((DeviceiSCSIAttributes)((DeviceiSCSIAttributes.Builder)DeviceiSCSIAttributes.builder().applyMutation(deviceiSCSIAttributes)).build());
        }
    }
}

