/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VolumeiSCSIAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VolumeiSCSIAttributes> {
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VolumeiSCSIAttributes.getter(VolumeiSCSIAttributes::targetARN)).setter(VolumeiSCSIAttributes.setter(Builder::targetARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetARN").build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VolumeiSCSIAttributes.getter(VolumeiSCSIAttributes::networkInterfaceId)).setter(VolumeiSCSIAttributes.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").build()}).build();
    private static final SdkField<Integer> NETWORK_INTERFACE_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(VolumeiSCSIAttributes.getter(VolumeiSCSIAttributes::networkInterfacePort)).setter(VolumeiSCSIAttributes.setter(Builder::networkInterfacePort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfacePort").build()}).build();
    private static final SdkField<Integer> LUN_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(VolumeiSCSIAttributes.getter(VolumeiSCSIAttributes::lunNumber)).setter(VolumeiSCSIAttributes.setter(Builder::lunNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LunNumber").build()}).build();
    private static final SdkField<Boolean> CHAP_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(VolumeiSCSIAttributes.getter(VolumeiSCSIAttributes::chapEnabled)).setter(VolumeiSCSIAttributes.setter(Builder::chapEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChapEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ARN_FIELD, NETWORK_INTERFACE_ID_FIELD, NETWORK_INTERFACE_PORT_FIELD, LUN_NUMBER_FIELD, CHAP_ENABLED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String targetARN;
    private final String networkInterfaceId;
    private final Integer networkInterfacePort;
    private final Integer lunNumber;
    private final Boolean chapEnabled;

    private VolumeiSCSIAttributes(BuilderImpl builder) {
        this.targetARN = builder.targetARN;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.networkInterfacePort = builder.networkInterfacePort;
        this.lunNumber = builder.lunNumber;
        this.chapEnabled = builder.chapEnabled;
    }

    public String targetARN() {
        return this.targetARN;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public Integer networkInterfacePort() {
        return this.networkInterfacePort;
    }

    public Integer lunNumber() {
        return this.lunNumber;
    }

    public Boolean chapEnabled() {
        return this.chapEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfacePort());
        hashCode = 31 * hashCode + Objects.hashCode(this.lunNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.chapEnabled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeiSCSIAttributes)) {
            return false;
        }
        VolumeiSCSIAttributes other = (VolumeiSCSIAttributes)obj;
        return Objects.equals(this.targetARN(), other.targetARN()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.networkInterfacePort(), other.networkInterfacePort()) && Objects.equals(this.lunNumber(), other.lunNumber()) && Objects.equals(this.chapEnabled(), other.chapEnabled());
    }

    public String toString() {
        return ToString.builder((String)"VolumeiSCSIAttributes").add("TargetARN", (Object)this.targetARN()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("NetworkInterfacePort", (Object)this.networkInterfacePort()).add("LunNumber", (Object)this.lunNumber()).add("ChapEnabled", (Object)this.chapEnabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetARN": {
                return Optional.ofNullable(clazz.cast(this.targetARN()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "NetworkInterfacePort": {
                return Optional.ofNullable(clazz.cast(this.networkInterfacePort()));
            }
            case "LunNumber": {
                return Optional.ofNullable(clazz.cast(this.lunNumber()));
            }
            case "ChapEnabled": {
                return Optional.ofNullable(clazz.cast(this.chapEnabled()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VolumeiSCSIAttributes, T> g) {
        return obj -> g.apply((VolumeiSCSIAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String targetARN;
        private String networkInterfaceId;
        private Integer networkInterfacePort;
        private Integer lunNumber;
        private Boolean chapEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeiSCSIAttributes model) {
            this.targetARN(model.targetARN);
            this.networkInterfaceId(model.networkInterfaceId);
            this.networkInterfacePort(model.networkInterfacePort);
            this.lunNumber(model.lunNumber);
            this.chapEnabled(model.chapEnabled);
        }

        public final String getTargetARN() {
            return this.targetARN;
        }

        @Override
        public final Builder targetARN(String targetARN) {
            this.targetARN = targetARN;
            return this;
        }

        public final void setTargetARN(String targetARN) {
            this.targetARN = targetARN;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final Integer getNetworkInterfacePort() {
            return this.networkInterfacePort;
        }

        @Override
        public final Builder networkInterfacePort(Integer networkInterfacePort) {
            this.networkInterfacePort = networkInterfacePort;
            return this;
        }

        public final void setNetworkInterfacePort(Integer networkInterfacePort) {
            this.networkInterfacePort = networkInterfacePort;
        }

        public final Integer getLunNumber() {
            return this.lunNumber;
        }

        @Override
        public final Builder lunNumber(Integer lunNumber) {
            this.lunNumber = lunNumber;
            return this;
        }

        public final void setLunNumber(Integer lunNumber) {
            this.lunNumber = lunNumber;
        }

        public final Boolean getChapEnabled() {
            return this.chapEnabled;
        }

        @Override
        public final Builder chapEnabled(Boolean chapEnabled) {
            this.chapEnabled = chapEnabled;
            return this;
        }

        public final void setChapEnabled(Boolean chapEnabled) {
            this.chapEnabled = chapEnabled;
        }

        public VolumeiSCSIAttributes build() {
            return new VolumeiSCSIAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VolumeiSCSIAttributes> {
        public Builder targetARN(String var1);

        public Builder networkInterfaceId(String var1);

        public Builder networkInterfacePort(Integer var1);

        public Builder lunNumber(Integer var1);

        public Builder chapEnabled(Boolean var1);
    }
}

