/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.storagegateway.StorageGatewayClient;
import software.amazon.awssdk.services.storagegateway.model.DescribeTapesRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeTapesResponse;
import software.amazon.awssdk.services.storagegateway.model.Tape;

public class DescribeTapesIterable
implements SdkIterable<DescribeTapesResponse> {
    private final StorageGatewayClient client;
    private final DescribeTapesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeTapesIterable(StorageGatewayClient client, DescribeTapesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeTapesResponseFetcher();
    }

    public Iterator<DescribeTapesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Tape> tapes() {
        Function<DescribeTapesResponse, Iterator> getIterator = response -> {
            if (response != null && response.tapes() != null) {
                return response.tapes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeTapesIterable resume(DescribeTapesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeTapesIterable(this.client, (DescribeTapesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeTapesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeTapesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeTapesResponseFetcher
    implements SyncPageFetcher<DescribeTapesResponse> {
        private DescribeTapesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTapesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeTapesResponse nextPage(DescribeTapesResponse previousPage) {
            if (previousPage == null) {
                return DescribeTapesIterable.this.client.describeTapes(DescribeTapesIterable.this.firstRequest);
            }
            return DescribeTapesIterable.this.client.describeTapes((DescribeTapesRequest)((Object)DescribeTapesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

