/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.storagegateway.StorageGatewayAsyncClient;
import software.amazon.awssdk.services.storagegateway.model.DescribeTapesRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeTapesResponse;
import software.amazon.awssdk.services.storagegateway.model.Tape;

public class DescribeTapesPublisher
implements SdkPublisher<DescribeTapesResponse> {
    private final StorageGatewayAsyncClient client;
    private final DescribeTapesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeTapesPublisher(StorageGatewayAsyncClient client, DescribeTapesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeTapesPublisher(StorageGatewayAsyncClient client, DescribeTapesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeTapesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeTapesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Tape> tapes() {
        Function<DescribeTapesResponse, Iterator> getIterator = response -> {
            if (response != null && response.tapes() != null) {
                return response.tapes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeTapesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final DescribeTapesPublisher resume(DescribeTapesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeTapesPublisher(this.client, (DescribeTapesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeTapesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeTapesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeTapesResponseFetcher
    implements AsyncPageFetcher<DescribeTapesResponse> {
        private DescribeTapesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTapesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeTapesResponse> nextPage(DescribeTapesResponse previousPage) {
            if (previousPage == null) {
                return DescribeTapesPublisher.this.client.describeTapes(DescribeTapesPublisher.this.firstRequest);
            }
            return DescribeTapesPublisher.this.client.describeTapes((DescribeTapesRequest)((Object)DescribeTapesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

