/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.storagegateway.StorageGatewayAsyncClient;
import software.amazon.awssdk.services.storagegateway.model.GatewayInfo;
import software.amazon.awssdk.services.storagegateway.model.ListGatewaysRequest;
import software.amazon.awssdk.services.storagegateway.model.ListGatewaysResponse;

public class ListGatewaysPublisher
implements SdkPublisher<ListGatewaysResponse> {
    private final StorageGatewayAsyncClient client;
    private final ListGatewaysRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListGatewaysPublisher(StorageGatewayAsyncClient client, ListGatewaysRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListGatewaysPublisher(StorageGatewayAsyncClient client, ListGatewaysRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListGatewaysResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListGatewaysResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GatewayInfo> gateways() {
        Function<ListGatewaysResponse, Iterator> getIterator = response -> {
            if (response != null && response.gateways() != null) {
                return response.gateways().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListGatewaysResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final ListGatewaysPublisher resume(ListGatewaysResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListGatewaysPublisher(this.client, (ListGatewaysRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListGatewaysPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListGatewaysResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListGatewaysResponseFetcher
    implements AsyncPageFetcher<ListGatewaysResponse> {
        private ListGatewaysResponseFetcher() {
        }

        public boolean hasNextPage(ListGatewaysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<ListGatewaysResponse> nextPage(ListGatewaysResponse previousPage) {
            if (previousPage == null) {
                return ListGatewaysPublisher.this.client.listGateways(ListGatewaysPublisher.this.firstRequest);
            }
            return ListGatewaysPublisher.this.client.listGateways((ListGatewaysRequest)((Object)ListGatewaysPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

