/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.storagegateway.StorageGatewayClient;
import software.amazon.awssdk.services.storagegateway.model.ListVolumesRequest;
import software.amazon.awssdk.services.storagegateway.model.ListVolumesResponse;
import software.amazon.awssdk.services.storagegateway.model.VolumeInfo;

public class ListVolumesIterable
implements SdkIterable<ListVolumesResponse> {
    private final StorageGatewayClient client;
    private final ListVolumesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListVolumesIterable(StorageGatewayClient client, ListVolumesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListVolumesResponseFetcher();
    }

    public Iterator<ListVolumesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<VolumeInfo> volumeInfos() {
        Function<ListVolumesResponse, Iterator> getIterator = response -> {
            if (response != null && response.volumeInfos() != null) {
                return response.volumeInfos().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final ListVolumesIterable resume(ListVolumesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListVolumesIterable(this.client, (ListVolumesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListVolumesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListVolumesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListVolumesResponseFetcher
    implements SyncPageFetcher<ListVolumesResponse> {
        private ListVolumesResponseFetcher() {
        }

        public boolean hasNextPage(ListVolumesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public ListVolumesResponse nextPage(ListVolumesResponse previousPage) {
            if (previousPage == null) {
                return ListVolumesIterable.this.client.listVolumes(ListVolumesIterable.this.firstRequest);
            }
            return ListVolumesIterable.this.client.listVolumes((ListVolumesRequest)((Object)ListVolumesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

