/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.endpoints.internal;

import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4AuthScheme;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.endpoints.StsEndpointParams;
import software.amazon.awssdk.services.sts.endpoints.StsEndpointProvider;
import software.amazon.awssdk.services.sts.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.sts.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.sts.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultStsEndpointProvider
implements StsEndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(StsEndpointParams params) {
        Validate.notNull((Object)params.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useGlobalEndpoint(), (String)"Parameter 'UseGlobalEndpoint' must not be null", (Object[])new Object[0]);
        try {
            RuleResult result = DefaultStsEndpointProvider.endpointRule0(params, new LocalState(params.region()));
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(StsEndpointParams params, LocalState locals) {
        RuleResult result = DefaultStsEndpointProvider.endpointRule1(params, locals);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultStsEndpointProvider.endpointRule19(params, locals);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultStsEndpointProvider.endpointRule23(params, locals);
        if (result.isResolved()) {
            return result;
        }
        return DefaultStsEndpointProvider.endpointRule40(params, locals);
    }

    private static RuleResult endpointRule1(StsEndpointParams params, LocalState locals) {
        if (params.useGlobalEndpoint().booleanValue() && params.endpoint() == null && locals.region() != null) {
            RulePartition partitionResult = null;
            partitionResult = RulesFunctions.awsPartition(locals.region());
            if (partitionResult != null) {
                locals = locals.toBuilder().partitionResult(partitionResult).build();
                if (!params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                    RuleResult result = DefaultStsEndpointProvider.endpointRule2(params, locals);
                    if (result.isResolved()) {
                        return result;
                    }
                    result = DefaultStsEndpointProvider.endpointRule3(params, locals);
                    if (result.isResolved()) {
                        return result;
                    }
                    result = DefaultStsEndpointProvider.endpointRule4(params, locals);
                    if (result.isResolved()) {
                        return result;
                    }
                    result = DefaultStsEndpointProvider.endpointRule5(params, locals);
                    if (result.isResolved()) {
                        return result;
                    }
                    result = DefaultStsEndpointProvider.endpointRule6(params, locals);
                    if (result.isResolved()) {
                        return result;
                    }
                    result = DefaultStsEndpointProvider.endpointRule7(params, locals);
                    if (result.isResolved()) {
                        return result;
                    }
                    result = DefaultStsEndpointProvider.endpointRule8(params, locals);
                    if (result.isResolved()) {
                        return result;
                    }
                    result = DefaultStsEndpointProvider.endpointRule9(params, locals);
                    if (result.isResolved()) {
                        return result;
                    }
                    result = DefaultStsEndpointProvider.endpointRule10(params, locals);
                    if (result.isResolved()) {
                        return result;
                    }
                    result = DefaultStsEndpointProvider.endpointRule11(params, locals);
                    if (result.isResolved()) {
                        return result;
                    }
                    result = DefaultStsEndpointProvider.endpointRule12(params, locals);
                    if (result.isResolved()) {
                        return result;
                    }
                    result = DefaultStsEndpointProvider.endpointRule13(params, locals);
                    if (result.isResolved()) {
                        return result;
                    }
                    result = DefaultStsEndpointProvider.endpointRule14(params, locals);
                    if (result.isResolved()) {
                        return result;
                    }
                    result = DefaultStsEndpointProvider.endpointRule15(params, locals);
                    if (result.isResolved()) {
                        return result;
                    }
                    result = DefaultStsEndpointProvider.endpointRule16(params, locals);
                    if (result.isResolved()) {
                        return result;
                    }
                    result = DefaultStsEndpointProvider.endpointRule17(params, locals);
                    if (result.isResolved()) {
                        return result;
                    }
                    return DefaultStsEndpointProvider.endpointRule18(params, locals);
                }
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule2(StsEndpointParams params, LocalState locals) {
        if ("ap-northeast-1".equals(locals.region())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("sts").signingRegion("us-east-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule3(StsEndpointParams params, LocalState locals) {
        if ("ap-south-1".equals(locals.region())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("sts").signingRegion("us-east-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule4(StsEndpointParams params, LocalState locals) {
        if ("ap-southeast-1".equals(locals.region())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("sts").signingRegion("us-east-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule5(StsEndpointParams params, LocalState locals) {
        if ("ap-southeast-2".equals(locals.region())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("sts").signingRegion("us-east-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule6(StsEndpointParams params, LocalState locals) {
        if ("aws-global".equals(locals.region())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("sts").signingRegion("us-east-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule7(StsEndpointParams params, LocalState locals) {
        if ("ca-central-1".equals(locals.region())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("sts").signingRegion("us-east-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule8(StsEndpointParams params, LocalState locals) {
        if ("eu-central-1".equals(locals.region())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("sts").signingRegion("us-east-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule9(StsEndpointParams params, LocalState locals) {
        if ("eu-north-1".equals(locals.region())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("sts").signingRegion("us-east-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule10(StsEndpointParams params, LocalState locals) {
        if ("eu-west-1".equals(locals.region())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("sts").signingRegion("us-east-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule11(StsEndpointParams params, LocalState locals) {
        if ("eu-west-2".equals(locals.region())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("sts").signingRegion("us-east-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule12(StsEndpointParams params, LocalState locals) {
        if ("eu-west-3".equals(locals.region())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("sts").signingRegion("us-east-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule13(StsEndpointParams params, LocalState locals) {
        if ("sa-east-1".equals(locals.region())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("sts").signingRegion("us-east-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule14(StsEndpointParams params, LocalState locals) {
        if ("us-east-1".equals(locals.region())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("sts").signingRegion("us-east-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule15(StsEndpointParams params, LocalState locals) {
        if ("us-east-2".equals(locals.region())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("sts").signingRegion("us-east-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule16(StsEndpointParams params, LocalState locals) {
        if ("us-west-1".equals(locals.region())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("sts").signingRegion("us-east-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule17(StsEndpointParams params, LocalState locals) {
        if ("us-west-2".equals(locals.region())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("sts").signingRegion("us-east-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule18(StsEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts." + locals.region() + "." + locals.partitionResult().dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("sts").signingRegion(locals.region()).build())).build());
    }

    private static RuleResult endpointRule19(StsEndpointParams params, LocalState locals) {
        if (params.endpoint() != null) {
            RuleResult result = DefaultStsEndpointProvider.endpointRule20(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultStsEndpointProvider.endpointRule21(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultStsEndpointProvider.endpointRule22(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule20(StsEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            return RuleResult.error("Invalid Configuration: FIPS and custom endpoint are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule21(StsEndpointParams params, LocalState locals) {
        if (params.useDualStack().booleanValue()) {
            return RuleResult.error("Invalid Configuration: Dualstack and custom endpoint are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule22(StsEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).build());
    }

    private static RuleResult endpointRule23(StsEndpointParams params, LocalState locals) {
        if (locals.region() != null) {
            return DefaultStsEndpointProvider.endpointRule24(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule24(StsEndpointParams params, LocalState locals) {
        RulePartition partitionResult = null;
        partitionResult = RulesFunctions.awsPartition(locals.region());
        if (partitionResult != null) {
            RuleResult result = DefaultStsEndpointProvider.endpointRule25(params, locals = locals.toBuilder().partitionResult(partitionResult).build());
            if (result.isResolved()) {
                return result;
            }
            result = DefaultStsEndpointProvider.endpointRule29(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultStsEndpointProvider.endpointRule34(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultStsEndpointProvider.endpointRule38(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultStsEndpointProvider.endpointRule39(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule25(StsEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultStsEndpointProvider.endpointRule26(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultStsEndpointProvider.endpointRule28(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule26(StsEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsFIPS() && locals.partitionResult().supportsDualStack()) {
            return DefaultStsEndpointProvider.endpointRule27(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule27(StsEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts-fips." + locals.region() + "." + locals.partitionResult().dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule28(StsEndpointParams params, LocalState locals) {
        return RuleResult.error("FIPS and DualStack are enabled, but this partition does not support one or both");
    }

    private static RuleResult endpointRule29(StsEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultStsEndpointProvider.endpointRule30(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultStsEndpointProvider.endpointRule33(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule30(StsEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsFIPS()) {
            RuleResult result = DefaultStsEndpointProvider.endpointRule31(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultStsEndpointProvider.endpointRule32(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule31(StsEndpointParams params, LocalState locals) {
        if ("aws-us-gov".equals(locals.partitionResult().name())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts." + locals.region() + ".amazonaws.com")).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule32(StsEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts-fips." + locals.region() + "." + locals.partitionResult().dnsSuffix())).build());
    }

    private static RuleResult endpointRule33(StsEndpointParams params, LocalState locals) {
        return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
    }

    private static RuleResult endpointRule34(StsEndpointParams params, LocalState locals) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultStsEndpointProvider.endpointRule35(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultStsEndpointProvider.endpointRule37(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule35(StsEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsDualStack()) {
            return DefaultStsEndpointProvider.endpointRule36(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule36(StsEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts." + locals.region() + "." + locals.partitionResult().dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule37(StsEndpointParams params, LocalState locals) {
        return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
    }

    private static RuleResult endpointRule38(StsEndpointParams params, LocalState locals) {
        if ("aws-global".equals(locals.region())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("sts").signingRegion("us-east-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule39(StsEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://sts." + locals.region() + "." + locals.partitionResult().dnsSuffix())).build());
    }

    private static RuleResult endpointRule40(StsEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid Configuration: Missing Region");
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    private static final class LocalStateBuilder {
        private String region;
        private RulePartition partitionResult;

        LocalStateBuilder() {
            this.region = null;
            this.partitionResult = null;
        }

        LocalStateBuilder(LocalState locals) {
            this.region = locals.region;
            this.partitionResult = locals.partitionResult;
        }

        public LocalStateBuilder region(String value) {
            this.region = value;
            return this;
        }

        public LocalStateBuilder partitionResult(RulePartition value) {
            this.partitionResult = value;
            return this;
        }

        LocalState build() {
            return new LocalState(this);
        }
    }

    private static final class LocalState {
        private final String region;
        private final RulePartition partitionResult;

        LocalState() {
            this.region = null;
            this.partitionResult = null;
        }

        LocalState(Region region) {
            this.region = region != null ? region.id() : null;
            this.partitionResult = null;
        }

        LocalState(LocalStateBuilder builder) {
            this.region = builder.region;
            this.partitionResult = builder.partitionResult;
        }

        public String region() {
            return this.region;
        }

        public RulePartition partitionResult() {
            return this.partitionResult;
        }

        public LocalStateBuilder toBuilder() {
            return new LocalStateBuilder(this);
        }
    }
}

