/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.testutils;

import java.util.function.Consumer;
import org.junit.rules.ExternalResource;
import software.amazon.awssdk.utils.SystemSetting;
import software.amazon.awssdk.utils.internal.SystemSettingUtilsTestBackdoor;

public class EnvironmentVariableHelper
extends ExternalResource {
    public void remove(SystemSetting setting) {
        this.remove(setting.environmentVariable());
    }

    public void remove(String key) {
        SystemSettingUtilsTestBackdoor.addEnvironmentVariableOverride((String)key, null);
    }

    public void set(SystemSetting setting, String value) {
        this.set(setting.environmentVariable(), value);
    }

    public void set(String key, String value) {
        SystemSettingUtilsTestBackdoor.addEnvironmentVariableOverride((String)key, (String)value);
    }

    public void reset() {
        SystemSettingUtilsTestBackdoor.clearEnvironmentVariableOverrides();
    }

    protected void after() {
        this.reset();
    }

    public static void run(Consumer<EnvironmentVariableHelper> helperConsumer) {
        EnvironmentVariableHelper helper = new EnvironmentVariableHelper();
        try {
            helperConsumer.accept(helper);
        }
        finally {
            helper.reset();
        }
    }
}

