/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.testutils.hamcrest;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public final class CollectionContainsOnlyInOrder<T>
extends TypeSafeMatcher<Collection<T>> {
    private final List<Matcher<? extends T>> matchers;

    private CollectionContainsOnlyInOrder(List<Matcher<? extends T>> matchers) {
        this.matchers = matchers;
    }

    static <T> TypeSafeMatcher<Collection<T>> containsOnlyInOrder(List<Matcher<? extends T>> matchers) {
        return new CollectionContainsOnlyInOrder<T>(matchers);
    }

    protected boolean matchesSafely(Collection<T> actualItems) {
        LinkedList<Matcher<T>> copyOfMatchers = new LinkedList<Matcher<T>>(this.matchers);
        for (T item : actualItems) {
            if (!copyOfMatchers.isEmpty() && ((Matcher)copyOfMatchers.remove()).matches(item)) continue;
            return false;
        }
        return copyOfMatchers.isEmpty();
    }

    public void describeTo(Description description) {
        description.appendText("collection containing ").appendList("[", ", ", "]", this.matchers).appendText(" in order ");
    }
}

