/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.IpGroupIdListCopier;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeIpGroupsRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, DescribeIpGroupsRequest> {
    private static final SdkField<List<String>> GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GroupIds").getter(DescribeIpGroupsRequest.getter(DescribeIpGroupsRequest::groupIds)).setter(DescribeIpGroupsRequest.setter(Builder::groupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeIpGroupsRequest.getter(DescribeIpGroupsRequest::nextToken)).setter(DescribeIpGroupsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeIpGroupsRequest.getter(DescribeIpGroupsRequest::maxResults)).setter(DescribeIpGroupsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_IDS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final List<String> groupIds;
    private final String nextToken;
    private final Integer maxResults;

    private DescribeIpGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.groupIds = builder.groupIds;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final boolean hasGroupIds() {
        return this.groupIds != null && !(this.groupIds instanceof SdkAutoConstructList);
    }

    public final List<String> groupIds() {
        return this.groupIds;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupIds() ? this.groupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIpGroupsRequest)) {
            return false;
        }
        DescribeIpGroupsRequest other = (DescribeIpGroupsRequest)((Object)obj);
        return this.hasGroupIds() == other.hasGroupIds() && Objects.equals(this.groupIds(), other.groupIds()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeIpGroupsRequest").add("GroupIds", this.hasGroupIds() ? this.groupIds() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupIds": {
                return Optional.ofNullable(clazz.cast(this.groupIds()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeIpGroupsRequest, T> g) {
        return obj -> g.apply((DescribeIpGroupsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private List<String> groupIds = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIpGroupsRequest model) {
            super(model);
            this.groupIds(model.groupIds);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final Collection<String> getGroupIds() {
            if (this.groupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.groupIds;
        }

        public final void setGroupIds(Collection<String> groupIds) {
            this.groupIds = IpGroupIdListCopier.copy(groupIds);
        }

        @Override
        public final Builder groupIds(Collection<String> groupIds) {
            this.groupIds = IpGroupIdListCopier.copy(groupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupIds(String ... groupIds) {
            this.groupIds(Arrays.asList(groupIds));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeIpGroupsRequest build() {
            return new DescribeIpGroupsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeIpGroupsRequest> {
        public Builder groupIds(Collection<String> var1);

        public Builder groupIds(String ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

