/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WorkspaceBundleState {
    AVAILABLE("AVAILABLE"),
    PENDING("PENDING"),
    ERROR("ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WorkspaceBundleState> VALUE_MAP;
    private final String value;

    private WorkspaceBundleState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WorkspaceBundleState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WorkspaceBundleState> knownValues() {
        EnumSet<WorkspaceBundleState> knownValues = EnumSet.allOf(WorkspaceBundleState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WorkspaceBundleState.class, WorkspaceBundleState::toString);
    }
}

