/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workspaces.WorkSpacesAsyncClient;
import software.amazon.awssdk.services.workspaces.internal.UserAgentUtils;
import software.amazon.awssdk.services.workspaces.model.AccountLink;
import software.amazon.awssdk.services.workspaces.model.ListAccountLinksRequest;
import software.amazon.awssdk.services.workspaces.model.ListAccountLinksResponse;

public class ListAccountLinksPublisher
implements SdkPublisher<ListAccountLinksResponse> {
    private final WorkSpacesAsyncClient client;
    private final ListAccountLinksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAccountLinksPublisher(WorkSpacesAsyncClient client, ListAccountLinksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAccountLinksPublisher(WorkSpacesAsyncClient client, ListAccountLinksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAccountLinksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAccountLinksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AccountLink> accountLinks() {
        Function<ListAccountLinksResponse, Iterator> getIterator = response -> {
            if (response != null && response.accountLinks() != null) {
                return response.accountLinks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAccountLinksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAccountLinksResponseFetcher
    implements AsyncPageFetcher<ListAccountLinksResponse> {
        private ListAccountLinksResponseFetcher() {
        }

        public boolean hasNextPage(ListAccountLinksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAccountLinksResponse> nextPage(ListAccountLinksResponse previousPage) {
            if (previousPage == null) {
                return ListAccountLinksPublisher.this.client.listAccountLinks(ListAccountLinksPublisher.this.firstRequest);
            }
            return ListAccountLinksPublisher.this.client.listAccountLinks((ListAccountLinksRequest)((Object)ListAccountLinksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

