/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.workspaces.model.LoginMessageCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DefaultImportClientBrandingAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DefaultImportClientBrandingAttributes> {
    private static final SdkField<SdkBytes> LOGO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("Logo").getter(DefaultImportClientBrandingAttributes.getter(DefaultImportClientBrandingAttributes::logo)).setter(DefaultImportClientBrandingAttributes.setter(Builder::logo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Logo").build()}).build();
    private static final SdkField<String> SUPPORT_EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SupportEmail").getter(DefaultImportClientBrandingAttributes.getter(DefaultImportClientBrandingAttributes::supportEmail)).setter(DefaultImportClientBrandingAttributes.setter(Builder::supportEmail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportEmail").build()}).build();
    private static final SdkField<String> SUPPORT_LINK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SupportLink").getter(DefaultImportClientBrandingAttributes.getter(DefaultImportClientBrandingAttributes::supportLink)).setter(DefaultImportClientBrandingAttributes.setter(Builder::supportLink)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportLink").build()}).build();
    private static final SdkField<String> FORGOT_PASSWORD_LINK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ForgotPasswordLink").getter(DefaultImportClientBrandingAttributes.getter(DefaultImportClientBrandingAttributes::forgotPasswordLink)).setter(DefaultImportClientBrandingAttributes.setter(Builder::forgotPasswordLink)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForgotPasswordLink").build()}).build();
    private static final SdkField<Map<String, String>> LOGIN_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("LoginMessage").getter(DefaultImportClientBrandingAttributes.getter(DefaultImportClientBrandingAttributes::loginMessage)).setter(DefaultImportClientBrandingAttributes.setter(Builder::loginMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoginMessage").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGO_FIELD, SUPPORT_EMAIL_FIELD, SUPPORT_LINK_FIELD, FORGOT_PASSWORD_LINK_FIELD, LOGIN_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DefaultImportClientBrandingAttributes.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SdkBytes logo;
    private final String supportEmail;
    private final String supportLink;
    private final String forgotPasswordLink;
    private final Map<String, String> loginMessage;

    private DefaultImportClientBrandingAttributes(BuilderImpl builder) {
        this.logo = builder.logo;
        this.supportEmail = builder.supportEmail;
        this.supportLink = builder.supportLink;
        this.forgotPasswordLink = builder.forgotPasswordLink;
        this.loginMessage = builder.loginMessage;
    }

    public final SdkBytes logo() {
        return this.logo;
    }

    public final String supportEmail() {
        return this.supportEmail;
    }

    public final String supportLink() {
        return this.supportLink;
    }

    public final String forgotPasswordLink() {
        return this.forgotPasswordLink;
    }

    public final boolean hasLoginMessage() {
        return this.loginMessage != null && !(this.loginMessage instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> loginMessage() {
        return this.loginMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logo());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportEmail());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportLink());
        hashCode = 31 * hashCode + Objects.hashCode(this.forgotPasswordLink());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLoginMessage() ? this.loginMessage() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultImportClientBrandingAttributes)) {
            return false;
        }
        DefaultImportClientBrandingAttributes other = (DefaultImportClientBrandingAttributes)obj;
        return Objects.equals(this.logo(), other.logo()) && Objects.equals(this.supportEmail(), other.supportEmail()) && Objects.equals(this.supportLink(), other.supportLink()) && Objects.equals(this.forgotPasswordLink(), other.forgotPasswordLink()) && this.hasLoginMessage() == other.hasLoginMessage() && Objects.equals(this.loginMessage(), other.loginMessage());
    }

    public final String toString() {
        return ToString.builder((String)"DefaultImportClientBrandingAttributes").add("Logo", (Object)this.logo()).add("SupportEmail", (Object)this.supportEmail()).add("SupportLink", (Object)this.supportLink()).add("ForgotPasswordLink", (Object)this.forgotPasswordLink()).add("LoginMessage", this.hasLoginMessage() ? this.loginMessage() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Logo": {
                return Optional.ofNullable(clazz.cast(this.logo()));
            }
            case "SupportEmail": {
                return Optional.ofNullable(clazz.cast(this.supportEmail()));
            }
            case "SupportLink": {
                return Optional.ofNullable(clazz.cast(this.supportLink()));
            }
            case "ForgotPasswordLink": {
                return Optional.ofNullable(clazz.cast(this.forgotPasswordLink()));
            }
            case "LoginMessage": {
                return Optional.ofNullable(clazz.cast(this.loginMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Logo", LOGO_FIELD);
        map.put("SupportEmail", SUPPORT_EMAIL_FIELD);
        map.put("SupportLink", SUPPORT_LINK_FIELD);
        map.put("ForgotPasswordLink", FORGOT_PASSWORD_LINK_FIELD);
        map.put("LoginMessage", LOGIN_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DefaultImportClientBrandingAttributes, T> g) {
        return obj -> g.apply((DefaultImportClientBrandingAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SdkBytes logo;
        private String supportEmail;
        private String supportLink;
        private String forgotPasswordLink;
        private Map<String, String> loginMessage = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultImportClientBrandingAttributes model) {
            this.logo(model.logo);
            this.supportEmail(model.supportEmail);
            this.supportLink(model.supportLink);
            this.forgotPasswordLink(model.forgotPasswordLink);
            this.loginMessage(model.loginMessage);
        }

        public final ByteBuffer getLogo() {
            return this.logo == null ? null : this.logo.asByteBuffer();
        }

        public final void setLogo(ByteBuffer logo) {
            this.logo(logo == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)logo));
        }

        @Override
        public final Builder logo(SdkBytes logo) {
            this.logo = logo;
            return this;
        }

        public final String getSupportEmail() {
            return this.supportEmail;
        }

        public final void setSupportEmail(String supportEmail) {
            this.supportEmail = supportEmail;
        }

        @Override
        public final Builder supportEmail(String supportEmail) {
            this.supportEmail = supportEmail;
            return this;
        }

        public final String getSupportLink() {
            return this.supportLink;
        }

        public final void setSupportLink(String supportLink) {
            this.supportLink = supportLink;
        }

        @Override
        public final Builder supportLink(String supportLink) {
            this.supportLink = supportLink;
            return this;
        }

        public final String getForgotPasswordLink() {
            return this.forgotPasswordLink;
        }

        public final void setForgotPasswordLink(String forgotPasswordLink) {
            this.forgotPasswordLink = forgotPasswordLink;
        }

        @Override
        public final Builder forgotPasswordLink(String forgotPasswordLink) {
            this.forgotPasswordLink = forgotPasswordLink;
            return this;
        }

        public final Map<String, String> getLoginMessage() {
            if (this.loginMessage instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.loginMessage;
        }

        public final void setLoginMessage(Map<String, String> loginMessage) {
            this.loginMessage = LoginMessageCopier.copy(loginMessage);
        }

        @Override
        public final Builder loginMessage(Map<String, String> loginMessage) {
            this.loginMessage = LoginMessageCopier.copy(loginMessage);
            return this;
        }

        public DefaultImportClientBrandingAttributes build() {
            return new DefaultImportClientBrandingAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DefaultImportClientBrandingAttributes> {
        public Builder logo(SdkBytes var1);

        public Builder supportEmail(String var1);

        public Builder supportLink(String var1);

        public Builder forgotPasswordLink(String var1);

        public Builder loginMessage(Map<String, String> var1);
    }
}

