/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspaces.model.TargetWorkspaceState;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyWorkspaceStateRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, ModifyWorkspaceStateRequest> {
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkspaceId").getter(ModifyWorkspaceStateRequest.getter(ModifyWorkspaceStateRequest::workspaceId)).setter(ModifyWorkspaceStateRequest.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceId").build()}).build();
    private static final SdkField<String> WORKSPACE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkspaceState").getter(ModifyWorkspaceStateRequest.getter(ModifyWorkspaceStateRequest::workspaceStateAsString)).setter(ModifyWorkspaceStateRequest.setter(Builder::workspaceState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_ID_FIELD, WORKSPACE_STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyWorkspaceStateRequest.memberNameToFieldInitializer();
    private final String workspaceId;
    private final String workspaceState;

    private ModifyWorkspaceStateRequest(BuilderImpl builder) {
        super(builder);
        this.workspaceId = builder.workspaceId;
        this.workspaceState = builder.workspaceState;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    public final TargetWorkspaceState workspaceState() {
        return TargetWorkspaceState.fromValue(this.workspaceState);
    }

    public final String workspaceStateAsString() {
        return this.workspaceState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyWorkspaceStateRequest)) {
            return false;
        }
        ModifyWorkspaceStateRequest other = (ModifyWorkspaceStateRequest)((Object)obj);
        return Objects.equals(this.workspaceId(), other.workspaceId()) && Objects.equals(this.workspaceStateAsString(), other.workspaceStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyWorkspaceStateRequest").add("WorkspaceId", (Object)this.workspaceId()).add("WorkspaceState", (Object)this.workspaceStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
            case "WorkspaceState": {
                return Optional.ofNullable(clazz.cast(this.workspaceStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("WorkspaceId", WORKSPACE_ID_FIELD);
        map.put("WorkspaceState", WORKSPACE_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyWorkspaceStateRequest, T> g) {
        return obj -> g.apply((ModifyWorkspaceStateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private String workspaceId;
        private String workspaceState;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyWorkspaceStateRequest model) {
            super(model);
            this.workspaceId(model.workspaceId);
            this.workspaceState(model.workspaceState);
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final String getWorkspaceState() {
            return this.workspaceState;
        }

        public final void setWorkspaceState(String workspaceState) {
            this.workspaceState = workspaceState;
        }

        @Override
        public final Builder workspaceState(String workspaceState) {
            this.workspaceState = workspaceState;
            return this;
        }

        @Override
        public final Builder workspaceState(TargetWorkspaceState workspaceState) {
            this.workspaceState(workspaceState == null ? null : workspaceState.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyWorkspaceStateRequest build() {
            return new ModifyWorkspaceStateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyWorkspaceStateRequest> {
        public Builder workspaceId(String var1);

        public Builder workspaceState(String var1);

        public Builder workspaceState(TargetWorkspaceState var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

