/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspacesweb.model.IdentityProviderListCopier;
import software.amazon.awssdk.services.workspacesweb.model.IdentityProviderSummary;
import software.amazon.awssdk.services.workspacesweb.model.WorkSpacesWebResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIdentityProvidersResponse
extends WorkSpacesWebResponse
implements ToCopyableBuilder<Builder, ListIdentityProvidersResponse> {
    private static final SdkField<List<IdentityProviderSummary>> IDENTITY_PROVIDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("identityProviders").getter(ListIdentityProvidersResponse.getter(ListIdentityProvidersResponse::identityProviders)).setter(ListIdentityProvidersResponse.setter(Builder::identityProviders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityProviders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IdentityProviderSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListIdentityProvidersResponse.getter(ListIdentityProvidersResponse::nextToken)).setter(ListIdentityProvidersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_PROVIDERS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListIdentityProvidersResponse.memberNameToFieldInitializer();
    private final List<IdentityProviderSummary> identityProviders;
    private final String nextToken;

    private ListIdentityProvidersResponse(BuilderImpl builder) {
        super(builder);
        this.identityProviders = builder.identityProviders;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasIdentityProviders() {
        return this.identityProviders != null && !(this.identityProviders instanceof SdkAutoConstructList);
    }

    public final List<IdentityProviderSummary> identityProviders() {
        return this.identityProviders;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIdentityProviders() ? this.identityProviders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentityProvidersResponse)) {
            return false;
        }
        ListIdentityProvidersResponse other = (ListIdentityProvidersResponse)((Object)obj);
        return this.hasIdentityProviders() == other.hasIdentityProviders() && Objects.equals(this.identityProviders(), other.identityProviders()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListIdentityProvidersResponse").add("IdentityProviders", this.hasIdentityProviders() ? this.identityProviders() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "identityProviders": {
                return Optional.ofNullable(clazz.cast(this.identityProviders()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("identityProviders", IDENTITY_PROVIDERS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListIdentityProvidersResponse, T> g) {
        return obj -> g.apply((ListIdentityProvidersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesWebResponse.BuilderImpl
    implements Builder {
        private List<IdentityProviderSummary> identityProviders = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIdentityProvidersResponse model) {
            super(model);
            this.identityProviders(model.identityProviders);
            this.nextToken(model.nextToken);
        }

        public final List<IdentityProviderSummary.Builder> getIdentityProviders() {
            List<IdentityProviderSummary.Builder> result = IdentityProviderListCopier.copyToBuilder(this.identityProviders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIdentityProviders(Collection<IdentityProviderSummary.BuilderImpl> identityProviders) {
            this.identityProviders = IdentityProviderListCopier.copyFromBuilder(identityProviders);
        }

        @Override
        public final Builder identityProviders(Collection<IdentityProviderSummary> identityProviders) {
            this.identityProviders = IdentityProviderListCopier.copy(identityProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityProviders(IdentityProviderSummary ... identityProviders) {
            this.identityProviders(Arrays.asList(identityProviders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityProviders(Consumer<IdentityProviderSummary.Builder> ... identityProviders) {
            this.identityProviders(Stream.of(identityProviders).map(c -> (IdentityProviderSummary)((IdentityProviderSummary.Builder)IdentityProviderSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListIdentityProvidersResponse build() {
            return new ListIdentityProvidersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkSpacesWebResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListIdentityProvidersResponse> {
        public Builder identityProviders(Collection<IdentityProviderSummary> var1);

        public Builder identityProviders(IdentityProviderSummary ... var1);

        public Builder identityProviders(Consumer<IdentityProviderSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

