/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jsii;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.VisibleForTesting;
import software.amazon.jsii.JsiiError;

public final class JsiiObjectRef {
    static final String TOKEN_REF = "$jsii.byref";
    static final String TOKEN_INTERFACES = "$jsii.interfaces";
    private JsonNode node;
    private String objId;
    private String fqn;
    private Set<String> interfaces;

    private JsiiObjectRef(String objId, JsonNode node) {
        this(objId, node.has(TOKEN_INTERFACES) ? JsiiObjectRef.parseInterfaces(node.get(TOKEN_INTERFACES)) : Collections.emptySet(), node);
    }

    @VisibleForTesting
    JsiiObjectRef(String objId, Set<String> interfaces) {
        this(objId, interfaces, JsiiObjectRef.makeJson(objId, interfaces));
    }

    private JsiiObjectRef(String objId, Set<String> interfaces, JsonNode node) {
        this.objId = objId;
        int fqnDelimiter = this.objId.lastIndexOf("@");
        this.fqn = this.objId.substring(0, fqnDelimiter);
        this.interfaces = interfaces;
        this.node = node;
    }

    public static JsiiObjectRef parse(JsonNode objRef) {
        if (!objRef.has(TOKEN_REF)) {
            throw new JsiiError("Malformed object reference. Expecting $jsii.byref");
        }
        return new JsiiObjectRef(objRef.get(TOKEN_REF).textValue(), objRef);
    }

    public static JsiiObjectRef fromObjId(String objId) {
        ObjectNode node = JsonNodeFactory.instance.objectNode();
        node.put(TOKEN_REF, objId);
        return new JsiiObjectRef(objId, (JsonNode)node);
    }

    JsiiObjectRef withInterface(String fqn) {
        HashSet<String> interfaces = new HashSet<String>(this.interfaces);
        interfaces.add(fqn);
        return new JsiiObjectRef(this.objId, interfaces);
    }

    private static JsonNode makeJson(String objId, Set<String> interfaces) {
        ObjectNode node = JsonNodeFactory.instance.objectNode();
        node.put(TOKEN_REF, objId);
        ArrayNode jsonInterfaces = JsonNodeFactory.instance.arrayNode();
        for (String iface : interfaces) {
            jsonInterfaces.add((JsonNode)JsonNodeFactory.instance.textNode(iface));
        }
        node.set(TOKEN_INTERFACES, (JsonNode)jsonInterfaces);
        return node;
    }

    private static Set<String> parseInterfaces(JsonNode node) {
        if (!node.isArray()) {
            throw new Error(String.format("Invalid value for %s. Expected array but received %s", TOKEN_INTERFACES, node));
        }
        HashSet result = new HashSet();
        node.forEach(entry -> {
            if (!entry.isTextual()) {
                throw new Error(String.format("Invalid entry in %s. Expected only strings, but received %s", TOKEN_INTERFACES, entry));
            }
            result.add(entry.asText());
        });
        return Collections.unmodifiableSet(result);
    }

    public String getFqn() {
        return this.fqn;
    }

    public JsonNode toJson() {
        return this.node;
    }

    public String getObjId() {
        return this.objId;
    }

    public Set<String> getInterfaces() {
        return this.interfaces;
    }

    public String toString() {
        return this.objId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof JsiiObjectRef)) {
            return false;
        }
        JsiiObjectRef other = (JsiiObjectRef)obj;
        return this.objId.equals(other.objId);
    }

    public int hashCode() {
        return this.objId.hashCode();
    }
}

