/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.metrics.internal;

import com.amazonaws.services.lambda.runtime.Context;
import java.lang.reflect.Field;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import software.amazon.cloudwatchlogs.emf.logger.MetricsLogger;
import software.amazon.cloudwatchlogs.emf.model.DimensionSet;
import software.amazon.cloudwatchlogs.emf.model.MetricsContext;
import software.amazon.cloudwatchlogs.emf.model.MetricsLoggerHelper;
import software.amazon.cloudwatchlogs.emf.model.Unit;
import software.amazon.lambda.powertools.core.internal.LambdaHandlerProcessor;
import software.amazon.lambda.powertools.metrics.Metrics;
import software.amazon.lambda.powertools.metrics.MetricsUtils;
import software.amazon.lambda.powertools.metrics.ValidationException;

@Aspect
public class LambdaMetricsAspect {
    private static final String NAMESPACE = System.getenv("POWERTOOLS_METRICS_NAMESPACE");
    public static final String TRACE_ID_PROPERTY = "xray_trace_id";
    public static final String REQUEST_ID_PROPERTY = "function_request_id";
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ LambdaMetricsAspect ajc$perSingletonInstance;

    static {
        try {
            LambdaMetricsAspect.ajc$perSingletonInstance = new LambdaMetricsAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    @Pointcut(value="@annotation(metrics)")
    public /* synthetic */ void callAt(Metrics metrics) {
    }

    @Around(value="callAt(metrics) && execution(@Metrics * *.*(..))", argNames="pjp,metrics")
    public Object around(ProceedingJoinPoint pjp, Metrics metrics) throws Throwable {
        Object[] proceedArgs = pjp.getArgs();
        if (LambdaHandlerProcessor.isHandlerMethod((ProceedingJoinPoint)pjp)) {
            MetricsLogger logger = MetricsUtils.metricsLogger();
            LambdaMetricsAspect.refreshMetricsContext(metrics);
            logger.setNamespace(this.namespace(metrics));
            Context extractedContext = LambdaHandlerProcessor.extractContext((ProceedingJoinPoint)pjp);
            if (extractedContext != null) {
                this.coldStartSingleMetricIfApplicable(extractedContext.getAwsRequestId(), extractedContext.getFunctionName(), metrics);
                logger.putProperty(REQUEST_ID_PROPERTY, (Object)extractedContext.getAwsRequestId());
            }
            LambdaHandlerProcessor.getXrayTraceId().ifPresent(traceId -> {
                MetricsLogger metricsLogger2 = logger.putProperty(TRACE_ID_PROPERTY, traceId);
            });
            try {
                Object object = pjp.proceed(proceedArgs);
                return object;
            }
            finally {
                LambdaHandlerProcessor.coldStartDone();
                this.validateMetricsAndRefreshOnFailure(metrics);
                logger.flush();
                LambdaMetricsAspect.refreshMetricsContext(metrics);
            }
        }
        return pjp.proceed(proceedArgs);
    }

    private void coldStartSingleMetricIfApplicable(String awsRequestId, String functionName, Metrics metrics) {
        if (metrics.captureColdStart() && LambdaHandlerProcessor.isColdStart()) {
            MetricsLogger metricsLogger = new MetricsLogger();
            metricsLogger.setNamespace(this.namespace(metrics));
            metricsLogger.putMetric("ColdStart", 1.0, Unit.COUNT);
            metricsLogger.setDimensions(new DimensionSet[]{DimensionSet.of((String)"Service", (String)LambdaMetricsAspect.service(metrics), (String)"FunctionName", (String)functionName)});
            metricsLogger.putProperty(REQUEST_ID_PROPERTY, (Object)awsRequestId);
            metricsLogger.flush();
        }
    }

    private void validateBeforeFlushingMetrics(Metrics metrics) {
        if (metrics.raiseOnEmptyMetrics() && MetricsLoggerHelper.hasNoMetrics()) {
            throw new ValidationException("No metrics captured, at least one metrics must be emitted");
        }
        if (MetricsLoggerHelper.dimensionsCount() > 9L) {
            throw new ValidationException(String.format("Number of Dimensions must be in range of 0-9. Actual size: %d.", MetricsLoggerHelper.dimensionsCount()));
        }
    }

    private String namespace(Metrics metrics) {
        return !"".equals(metrics.namespace()) ? metrics.namespace() : NAMESPACE;
    }

    private static String service(Metrics metrics) {
        return !"".equals(metrics.service()) ? metrics.service() : LambdaHandlerProcessor.serviceName();
    }

    private void validateMetricsAndRefreshOnFailure(Metrics metrics) {
        try {
            this.validateBeforeFlushingMetrics(metrics);
        }
        catch (ValidationException e) {
            LambdaMetricsAspect.refreshMetricsContext(metrics);
            throw e;
        }
    }

    public static void refreshMetricsContext(Metrics metrics) {
        try {
            DimensionSet[] dimensionSetArray;
            Field f = MetricsUtils.metricsLogger().getClass().getDeclaredField("context");
            f.setAccessible(true);
            MetricsContext context = new MetricsContext();
            if (MetricsUtils.hasDefaultDimension()) {
                dimensionSetArray = MetricsUtils.getDefaultDimensions();
            } else {
                DimensionSet[] dimensionSetArray2 = new DimensionSet[1];
                dimensionSetArray = dimensionSetArray2;
                dimensionSetArray2[0] = DimensionSet.of((String)"Service", (String)LambdaMetricsAspect.service(metrics));
            }
            DimensionSet[] defaultDimensions = dimensionSetArray;
            context.setDimensions(defaultDimensions);
            f.set(MetricsUtils.metricsLogger(), context);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static LambdaMetricsAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("software.amazon.lambda.powertools.metrics.internal.LambdaMetricsAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

