/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.mysql.shading.com.mysql.cj.protocol.a.authentication;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.rds.auth.GetIamAuthTokenRequest;
import com.amazonaws.services.rds.auth.RdsIamAuthTokenGenerator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.Messages;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.exceptions.ExceptionFactory;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.Log;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.LogFactory;

public class AwsIamAuthenticationTokenHelper {
    private String token;
    private final String region;
    private final String hostname;
    private final int port;
    private final Log log;
    private static final int REGION_MATCHER_GROUP = 3;

    public AwsIamAuthenticationTokenHelper(String hostname, int port, String logger) {
        this.log = LogFactory.getLogger(logger, "MySQL");
        this.hostname = hostname;
        this.port = port;
        this.region = this.getRdsRegion();
    }

    public String getOrGenerateToken(String user) {
        if (this.token == null) {
            this.token = this.generateAuthenticationToken(user);
        }
        return this.token;
    }

    private String generateAuthenticationToken(String user) {
        RdsIamAuthTokenGenerator generator = RdsIamAuthTokenGenerator.builder().region(this.region).credentials((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain()).build();
        return generator.getAuthToken(GetIamAuthTokenRequest.builder().hostname(this.hostname).port(this.port).userName(user).build());
    }

    private String getRdsRegion() {
        Pattern auroraDnsPattern = Pattern.compile("(.+)\\.(proxy-|cluster-|cluster-ro-|cluster-custom-)?[a-zA-Z0-9]+\\.([a-zA-Z0-9\\-]+)\\.rds\\.amazonaws\\.com", 2);
        Matcher matcher = auroraDnsPattern.matcher(this.hostname);
        if (!matcher.find()) {
            String exceptionMessage = Messages.getString("AuthenticationAwsIamPlugin.UnsupportedHostname", new String[]{this.hostname});
            this.log.logTrace(exceptionMessage);
            throw ExceptionFactory.createException(exceptionMessage);
        }
        String rdsRegion = matcher.group(3);
        try {
            Regions.fromName((String)rdsRegion);
        }
        catch (IllegalArgumentException exception) {
            String exceptionMessage = Messages.getString("AuthenticationAwsIamPlugin.UnsupportedRegion", new String[]{this.hostname});
            this.log.logTrace(exceptionMessage, exception);
            throw ExceptionFactory.createException(exceptionMessage, exception);
        }
        return rdsRegion;
    }
}

